/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityGoblin;

public class EntityAIGoblinMate
extends EntityAIBase {
    private final EntityGoblin goblinObj;
    private final World world;
    Village village;
    private EntityGoblin mate;
    private int matingTimeout;

    public EntityAIGoblinMate(EntityGoblin goblin) {
        this.goblinObj = goblin;
        this.world = goblin.world;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.goblinObj.getGrowingAge() != 0) {
            return false;
        }
        if (this.goblinObj.getRNG().nextInt(500) != 0) {
            return false;
        }
        this.village = this.world.villageCollection.getNearestVillage(this.goblinObj.getPos(), 0);
        if (this.village == null) {
            return false;
        }
        if (!this.checkSufficientDoorsPresentForNewVillager()) {
            return false;
        }
        EntityGoblin entity = (EntityGoblin)this.world.findNearestEntityWithinAABB(EntityGoblin.class, this.goblinObj.getEntityBoundingBox().expand(8.0, 3.0, 8.0), (Entity)this.goblinObj);
        if (entity == null) {
            return false;
        }
        this.mate = entity;
        return this.mate.getGrowingAge() == 0;
    }

    public void startExecuting() {
        this.matingTimeout = 300;
        this.goblinObj.setMating(true);
    }

    public void resetTask() {
        this.village = null;
        this.mate = null;
        this.goblinObj.setMating(false);
    }

    public boolean shouldContinueExecuting() {
        return this.matingTimeout >= 0 && this.checkSufficientDoorsPresentForNewVillager() && this.goblinObj.getGrowingAge() == 0;
    }

    public void updateTask() {
        --this.matingTimeout;
        this.goblinObj.getLookHelper().setLookPositionWithEntity((Entity)this.mate, 10.0f, 30.0f);
        if (this.goblinObj.getDistanceSq((Entity)this.mate) > 2.25) {
            this.goblinObj.getNavigator().tryMoveToEntityLiving((Entity)this.mate, 0.25);
        } else if (this.matingTimeout == 0 && this.mate.isMating()) {
            this.giveBirth();
        }
        if (this.goblinObj.getRNG().nextInt(35) == 0) {
            this.world.setEntityState((Entity)this.goblinObj, (byte)12);
        }
    }

    private boolean checkSufficientDoorsPresentForNewVillager() {
        if (!this.village.isMatingSeason()) {
            return false;
        }
        int i = (int)((double)this.village.getNumVillageDoors() * 0.35);
        return this.getNumVillagers() < i;
    }

    private int getNumVillagers() {
        if (this.world == null || this.goblinObj == null) {
            return 0;
        }
        List list2 = this.world.getEntitiesWithinAABB(EntityGoblin.class, this.goblinObj.getEntityBoundingBox().expand(32.0, 3.0, 32.0));
        return list2.size();
    }

    private void giveBirth() {
        EntityGoblin entityvillager = this.goblinObj.createChild(this.mate);
        this.mate.setGrowingAge(6000);
        this.goblinObj.setGrowingAge(6000);
        entityvillager.setGrowingAge(-24000);
        entityvillager.setLocationAndAngles(this.goblinObj.posX, this.goblinObj.posY, this.goblinObj.posZ, 0.0f, 0.0f);
        this.world.spawnEntity((Entity)entityvillager);
        this.world.setEntityState((Entity)entityvillager, (byte)12);
    }
}

