/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class EntityAIFlyingTempt
extends EntityAIBase {
    private final EntityCreature temptedEntity;
    private final Ingredient breedingFood;
    private final boolean scaredByPlayerMovement;
    private double targetX;
    private double targetY;
    private double targetZ;
    private EntityPlayer temptingPlayer;
    private int delayTemptCounter;

    public EntityAIFlyingTempt(EntityCreature entity, Ingredient ingredient, boolean scared) {
        this.temptedEntity = entity;
        this.breedingFood = ingredient;
        this.scaredByPlayerMovement = scared;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        boolean isTame;
        boolean bl = isTame = this.temptedEntity instanceof EntityTameable && ((EntityTameable)this.temptedEntity).isTamed();
        if (isTame) {
            return false;
        }
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.world.getClosestPlayerToEntity((Entity)this.temptedEntity, 10.0);
        if (this.temptingPlayer == null) {
            return false;
        }
        ItemStack itemstack = this.temptingPlayer.getHeldItemMainhand();
        return !itemstack.isEmpty() && this.isBreedingFood(itemstack);
    }

    private boolean isBreedingFood(ItemStack stack) {
        return this.breedingFood.test((Object)stack);
    }

    public boolean shouldContinueExecuting() {
        if (this.scaredByPlayerMovement) {
            if (this.temptedEntity.getDistanceSq((Entity)this.temptingPlayer) < 36.0) {
                if (this.temptingPlayer.getDistanceSq(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
            } else {
                this.targetX = this.temptingPlayer.posX;
                this.targetY = this.temptingPlayer.posY;
                this.targetZ = this.temptingPlayer.posZ;
            }
        }
        return this.shouldExecute();
    }

    public void resetTask() {
        this.temptingPlayer = null;
        this.delayTemptCounter = 100;
    }

    public void updateTask() {
        if (this.temptedEntity.getDistanceSq((Entity)this.temptingPlayer) >= 3.0) {
            float n;
            double d0 = this.targetX - this.temptedEntity.posX;
            double d2 = this.targetY - this.temptedEntity.posY;
            double d3 = this.targetZ - this.temptedEntity.posZ;
            double d4 = d0 * d0 + d2 * d2 + d3 * d3;
            if (this.isCourseTraversable(this.targetX, this.targetY, this.targetZ, d4 = (double)MathHelper.sqrt((double)d4))) {
                EntityCreature temptedEntity = this.temptedEntity;
                temptedEntity.motionX += d0 / d4 * 0.05;
                EntityCreature temptedEntity2 = this.temptedEntity;
                temptedEntity2.motionY = this.temptedEntity.posY < this.targetY + 1.0 ? (temptedEntity2.motionY += d2 / d4 * 0.05 + 0.025) : (temptedEntity2.motionY += d2 / d4 * 0.05);
                EntityCreature temptedEntity4 = this.temptedEntity;
                temptedEntity4.motionZ += d3 / d4 * 0.05;
            }
            this.temptedEntity.rotationYaw = n = -((float)Math.atan2(this.temptedEntity.motionX, this.temptedEntity.motionZ)) * 180.0f / (float)Math.PI;
            this.temptedEntity.renderYawOffset = n;
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.temptedEntity.posX) / par7;
        double d5 = (par3 - this.temptedEntity.posY) / par7;
        double d6 = (par5 - this.temptedEntity.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.temptedEntity.getEntityBoundingBox();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.temptedEntity.world.getCollisionBoxes((Entity)this.temptedEntity, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

