/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFlyerWander
extends EntityAIBase {
    public final double fleeDistance;
    final World world;
    final EntityLiving living;
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    private double xPosition;
    private double yPosition;
    private double zPosition;

    public EntityAIFlyerWander(EntityLiving par1EntityCreature, double fleeDistance) {
        this.living = par1EntityCreature;
        this.world = this.living.world;
        this.fleeDistance = fleeDistance;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        boolean isTame;
        boolean bl = isTame = this.living instanceof EntityTameable && ((EntityTameable)this.living).isTamed();
        return !isTame && this.living.world.getClosestPlayerToEntity((Entity)this.living, this.fleeDistance) != null || this.living.getIdleTime() < 100 && this.living.getRNG().nextInt(this.living.world.provider.isDaytime() ? 300 : 100) == 0 && (!(this.living instanceof EntityTameable) || !((EntityTameable)this.living).isSitting());
    }

    public boolean shouldContinueExecuting() {
        return this.living instanceof EntityTameable && !((EntityTameable)this.living).isSitting() || this.living.getRNG().nextInt(40) != 0;
    }

    public void startExecuting() {
    }

    public void updateTask() {
        float n;
        double d0 = this.waypointX - this.living.posX;
        double d2 = this.waypointY - this.living.posY;
        double d3 = this.waypointZ - this.living.posZ;
        double d4 = d0 * d0 + d2 * d2 + d3 * d3;
        if (d4 < 1.0 || d4 > 3600.0) {
            float distance = this.living instanceof EntityTameable && ((EntityTameable)this.living).isTamed() ? 2.0f : 6.0f;
            this.waypointX = this.living.posX + (double)((this.world.rand.nextFloat() * 8.0f - 4.0f) * distance);
            this.waypointY = this.living.posY + (double)((this.world.rand.nextFloat() * 2.0f - 1.0f) * distance);
            this.waypointZ = this.living.posZ + (double)((this.world.rand.nextFloat() * 8.0f - 4.0f) * distance);
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.world.rand.nextInt(2) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d4 = (double)MathHelper.sqrt((double)d4))) {
                EntityLiving living = this.living;
                living.motionX += d0 / d4 * 0.1;
                EntityLiving living2 = this.living;
                living2.motionY += d2 / d4 * 0.1;
                EntityLiving living3 = this.living;
                living3.motionZ += d3 / d4 * 0.1;
            } else {
                this.waypointX = this.living.posX;
                this.waypointY = this.living.posY;
                this.waypointZ = this.living.posZ;
            }
        }
        this.living.rotationYaw = n = -((float)Math.atan2(this.living.motionX, this.living.motionZ)) * 180.0f / (float)Math.PI;
        this.living.renderYawOffset = n;
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.living.posX) / par7;
        double d5 = (par3 - this.living.posY) / par7;
        double d6 = (par5 - this.living.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.living.getEntityBoundingBox();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.living.world.getCollisionBoxes((Entity)this.living, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

