/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFlyerMate
extends EntityAIBase {
    final World theWorld;
    final double moveSpeed;
    private final EntityAnimal theAnimal;
    int spawnBabyDelay;
    int updateDelay = 0;
    private EntityAnimal targetMate;

    public EntityAIFlyerMate(EntityAnimal par1EntityAnimal, double par2) {
        this.theAnimal = par1EntityAnimal;
        this.theWorld = par1EntityAnimal.world;
        this.moveSpeed = par2;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        if (!this.theAnimal.isInLove()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean shouldContinueExecuting() {
        return this.targetMate.isEntityAlive() && this.targetMate.isInLove() && this.spawnBabyDelay < 60;
    }

    public void resetTask() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
        this.updateDelay = 0;
    }

    public void updateTask() {
        float n;
        int updateDelay;
        this.updateDelay = updateDelay = this.updateDelay - 1;
        if (updateDelay <= 0) {
            double d0 = this.targetMate.posX - this.theAnimal.posX;
            double d2 = this.targetMate.posY - this.theAnimal.posY;
            double d3 = this.targetMate.posZ - this.theAnimal.posZ;
            double d4 = d0 * d0 + d2 * d2 + d3 * d3;
            if (this.isCourseTraversable(this.targetMate.posX, this.targetMate.posY, this.targetMate.posZ, d4 = (double)MathHelper.sqrt((double)d4))) {
                EntityAnimal theAnimal = this.theAnimal;
                theAnimal.motionX += d0 / d4 * 0.25;
                EntityAnimal theAnimal2 = this.theAnimal;
                theAnimal2.motionY += d2 / d4 * 0.25;
                EntityAnimal theAnimal3 = this.theAnimal;
                theAnimal3.motionZ += d3 / d4 * 0.25;
            }
            this.updateDelay = 10;
        }
        this.theAnimal.rotationYaw = n = -((float)Math.atan2(this.theAnimal.motionX, this.theAnimal.motionZ)) * 180.0f / (float)Math.PI;
        this.theAnimal.renderYawOffset = n;
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.theAnimal.getDistanceSq((Entity)this.targetMate) < 9.0) {
            this.spawnBaby();
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.theAnimal.posX) / par7;
        double d5 = (par3 - this.theAnimal.posY) / par7;
        double d6 = (par5 - this.theAnimal.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.theAnimal.getEntityBoundingBox();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.theAnimal.world.getCollisionBoxes((Entity)this.theAnimal, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private EntityAnimal getNearbyMate() {
        float f = 8.0f;
        List list2 = this.theWorld.getEntitiesWithinAABB(this.theAnimal.getClass(), this.theAnimal.getEntityBoundingBox().expand((double)f, (double)f, (double)f));
        double d0 = Double.MAX_VALUE;
        EntityAnimal entityanimal = null;
        for (EntityAnimal animal : list2) {
            if (!this.theAnimal.canMateWith(animal) || !(this.theAnimal.getDistanceSq((Entity)animal) < d0)) continue;
            entityanimal = animal;
            d0 = this.theAnimal.getDistanceSq((Entity)animal);
        }
        return entityanimal;
    }

    private void spawnBaby() {
        EntityAgeable entityageable = this.theAnimal.createChild((EntityAgeable)this.targetMate);
        if (entityageable != null) {
            this.theAnimal.setGrowingAge(6000);
            this.targetMate.setGrowingAge(6000);
            this.theAnimal.resetInLove();
            this.targetMate.resetInLove();
            entityageable.setGrowingAge(-24000);
            entityageable.setLocationAndAngles(this.theAnimal.posX, this.theAnimal.posY, this.theAnimal.posZ, 0.0f, 0.0f);
            this.theWorld.spawnEntity((Entity)entityageable);
            Random random = this.theAnimal.getRNG();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextGaussian() * 0.02;
                this.theWorld.spawnParticle(EnumParticleTypes.HEART, this.theAnimal.posX + (double)(random.nextFloat() * this.theAnimal.width * 2.0f) - (double)this.theAnimal.width, this.theAnimal.posY + 0.5 + (double)(random.nextFloat() * this.theAnimal.height), this.theAnimal.posZ + (double)(random.nextFloat() * this.theAnimal.width * 2.0f) - (double)this.theAnimal.width, d0, d2, d3, new int[0]);
            }
            this.theWorld.spawnEntity((Entity)new EntityXPOrb(this.theWorld, this.theAnimal.posX, this.theAnimal.posY, this.theAnimal.posZ, random.nextInt(7) + 1));
        }
    }
}

