/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFlyerLand
extends EntityAIBase {
    public final boolean findTrees;
    final World world;
    final EntityLiving living;
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    int[] target;

    public EntityAIFlyerLand(EntityLiving par1EntityCreature, boolean findTrees) {
        this.living = par1EntityCreature;
        this.world = this.living.world;
        this.findTrees = findTrees;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        return this.isLanded() && this.liquidBelow((int)this.living.posY - 1) && this.liquidBelow((int)this.living.posY) && this.world.rand.nextInt(20) == 0;
    }

    private boolean liquidBelow(int y) {
        return !this.world.getBlockState(new BlockPos(this.living.posX, (double)y, this.living.posZ)).getMaterial().isLiquid();
    }

    public boolean shouldContinueExecuting() {
        return this.isLanded() && this.liquidBelow((int)this.living.posY - 1) && this.liquidBelow((int)this.living.posY);
    }

    public void startExecuting() {
        this.courseChangeCooldown = 100;
        int x0 = MathHelper.floor((double)this.living.posX);
        int y0 = MathHelper.floor((double)this.living.posY);
        int z0 = MathHelper.floor((double)this.living.posZ);
        int[] nArray = this.target = this.findTrees ? this.findTreeTop(x0, y0, z0) : null;
        if (this.target == null) {
            this.target = this.findGround(x0, y0, z0);
        }
        if (this.target != null) {
            // empty if block
        }
    }

    public void resetTask() {
        this.target = null;
        super.resetTask();
    }

    private int[] findTreeTop(int x0, int y0, int z0) {
        int RADIUS = 16;
        int Y_RADIUS = 3;
        for (int y = Math.max(y0 - Y_RADIUS, 1); y <= y0 + Y_RADIUS; ++y) {
            for (int x = x0 - RADIUS; x <= x0 + RADIUS; ++x) {
                for (int z = z0 - RADIUS; z <= z0 + RADIUS; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = this.world.getBlockState(pos);
                    Block blockID = state.getBlock();
                    if (state.getMaterial() != Material.LEAVES) continue;
                    for (int y2 = y; y2 < y0 + 10; ++y2) {
                        if (!this.world.isAirBlock(pos)) continue;
                        double d0 = (double)x - this.living.posX;
                        double d2 = (double)y2 - this.living.posY;
                        double d3 = (double)z - this.living.posZ;
                        double d4 = d0 * d0 + d2 * d2 + d3 * d3;
                        if (!this.isCourseTraversable(x, y2, z, d4 = (double)MathHelper.sqrt((double)d4))) continue;
                        return new int[]{x, y2 + 2, z};
                    }
                }
            }
        }
        return null;
    }

    private int[] findGround(int x0, int y0, int z0) {
        for (int y = y0; y > 1; --y) {
            Material material = this.world.getBlockState(new BlockPos(x0, y, z0)).getMaterial();
            if (material == Material.AIR) continue;
            if (!material.isLiquid()) {
                return new int[]{x0, y + 1, z0};
            }
            for (int i = 0; i < 10; ++i) {
                int j = MathHelper.floor((double)(this.living.posX + (double)this.world.rand.nextInt(20) - 10.0));
                int k = MathHelper.floor((double)(this.living.getEntityBoundingBox().minY + (double)this.world.rand.nextInt(6) - 3.0));
                int l = MathHelper.floor((double)(this.living.posZ + (double)this.world.rand.nextInt(20) - 10.0));
                BlockPos pos = new BlockPos(j, k, l);
                IBlockState state = this.world.getBlockState(pos);
                Block blockID = state.getBlock();
                double d0 = (double)j - this.living.posX;
                double d2 = (double)k - this.living.posY;
                double d3 = (double)l - this.living.posZ;
                double d4 = d0 * d0 + d2 * d2 + d3 * d3;
                d4 = MathHelper.sqrt((double)d4);
                if (state.getMaterial() != Material.LEAVES && !state.getMaterial().isSolid() || !this.world.isAirBlock(pos.up()) || !this.isCourseTraversable(j, k, l, d4)) continue;
                return new int[]{j, k + 1, l};
            }
        }
        return null;
    }

    public void updateTask() {
        float n2;
        if (this.isLanded()) {
            float n;
            if (this.target != null && this.living.getDistanceSq((double)this.target[0], this.living.posY, (double)this.target[2]) > 1.0 && this.courseChangeCooldown-- > 0) {
                double d0 = (double)this.target[0] - this.living.posX;
                double d2 = (double)this.target[1] - this.living.posY;
                double d3 = (double)this.target[2] - this.living.posZ;
                double d4 = d0 * d0 + d2 * d2 + d3 * d3;
                if (this.isCourseTraversable(this.target[0], this.target[1], this.target[2], d4 = (double)MathHelper.sqrt((double)d4))) {
                    EntityLiving living = this.living;
                    living.motionX += d0 / d4 * 0.05;
                    EntityLiving living2 = this.living;
                    living2.motionY += d2 / d4 * 0.05;
                    EntityLiving living3 = this.living;
                    living3.motionZ += d3 / d4 * 0.05;
                }
            } else if (this.liquidBelow((int)(this.living.posY - 1.0))) {
                this.living.motionY = -0.1;
            }
            this.living.rotationYaw = n = -((float)Math.atan2(this.living.motionX, this.living.motionZ)) * 180.0f / (float)Math.PI;
            this.living.renderYawOffset = n;
        }
        this.living.rotationYaw = n2 = -((float)Math.atan2(this.living.motionX, this.living.motionZ)) * 180.0f / (float)Math.PI;
        this.living.renderYawOffset = n2;
    }

    private boolean isLanded() {
        BlockPos pos = new BlockPos(MathHelper.floor((double)this.living.posX), (int)(this.living.posY - 0.01), MathHelper.floor((double)this.living.posZ));
        IBlockState state = this.world.getBlockState(pos);
        Material material = state.getMaterial();
        return material != Material.LEAVES && !material.isSolid();
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.living.posX) / par7;
        double d5 = (par3 - this.living.posY) / par7;
        double d6 = (par5 - this.living.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.living.getEntityBoundingBox();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.world.getCollisionBoxes((Entity)this.living, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

