/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.msrandom.witchery.entity.familiar.Familiar;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;

public class EntityAIFlyerFollowOwner<T extends Entity>
extends EntityAIBase {
    private final T entity;
    private Familiar<?> familiar;
    private Entity owner;
    final float maxDist;
    final float minDist;
    private int timeToRecalcPath;

    public EntityAIFlyerFollowOwner(T ownable, float par4, float par5) {
        this.entity = ownable;
        this.minDist = par4;
        this.maxDist = par5;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        Familiar<T> familiar;
        Entity owner = null;
        if (this.entity instanceof IEntityOwnable) {
            owner = ((IEntityOwnable)this.entity).getOwner();
        } else if (Familiars.canBeFamiliar(this.entity) && (familiar = Familiars.getFamiliarInstance(this.entity)) != null) {
            owner = familiar.getOwner();
            this.familiar = familiar;
        }
        if (owner == null) {
            return false;
        }
        if (this.isSitting()) {
            return false;
        }
        if (((Entity)this.entity).dimension != owner.dimension || this.entity.getDistanceSq(owner) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    private boolean isSitting() {
        if (this.familiar != null) {
            return this.familiar.isFamiliarSitting();
        }
        return this.entity instanceof EntityTameable && ((EntityTameable)this.entity).isSitting();
    }

    public boolean shouldContinueExecuting() {
        return this.entity.getDistanceSq(this.owner) > (double)(this.maxDist * this.maxDist) && !this.isSitting();
    }

    public void startExecuting() {
        this.timeToRecalcPath = 0;
    }

    public void resetTask() {
        this.owner = null;
    }

    public void updateTask() {
        if (!this.isSitting() && --this.timeToRecalcPath <= 0) {
            float n;
            this.timeToRecalcPath = 10;
            if (((Entity)this.entity).dimension != this.owner.dimension || this.entity.getDistanceSq(this.owner) >= 256.0) {
                int x = MathHelper.floor((double)this.owner.posX) - 2;
                int z = MathHelper.floor((double)this.owner.posZ) - 2;
                int y = MathHelper.floor((double)this.owner.getEntityBoundingBox().minY) - 2;
                for (int dx = 0; dx <= 4; ++dx) {
                    for (int dz = 0; dz <= 4; ++dz) {
                        for (int dy = 0; dy <= 4; ++dy) {
                            int newX = x + dz;
                            int newY = y + dy;
                            int newZ = z + dz;
                            BlockPos pos = new BlockPos(newX, newY, newZ);
                            if (!this.owner.world.getBlockState(pos.down()).isSideSolid((IBlockAccess)this.owner.world, pos.down(), EnumFacing.UP) || this.owner.world.getBlockState(pos).isNormalCube() || this.owner.world.getBlockState(pos.up()).isNormalCube()) continue;
                            WitcheryIngredientItem.teleportToLocation(pos, this.owner.dimension, this.entity, true);
                            return;
                        }
                    }
                }
            } else {
                double d0 = this.owner.posX - ((Entity)this.entity).posX;
                double d2 = this.owner.posY - ((Entity)this.entity).posY;
                double d3 = this.owner.posZ - ((Entity)this.entity).posZ;
                double d4 = d0 * d0 + d2 * d2 + d3 * d3;
                if (this.isCourseTraversable(this.owner.posX, this.owner.posY, this.owner.posZ, d4 = (double)MathHelper.sqrt((double)d4))) {
                    ((Entity)this.entity).motionX += d0 / d4 * 0.1;
                    ((Entity)this.entity).motionY = ((Entity)this.entity).posY < this.owner.posY + 2.0 ? (((Entity)this.entity).motionY += d2 / d4 * 0.1 + 0.1) : (((Entity)this.entity).motionY += d2 / d4 * 0.1);
                } else {
                    double newX2 = ((Entity)this.entity).posX + (double)((((Entity)this.entity).world.rand.nextFloat() * 8.0f - 4.0f) * 6.0f);
                    double newY2 = ((Entity)this.entity).posY + (double)((((Entity)this.entity).world.rand.nextFloat() * 2.0f - 1.0f) * 6.0f);
                    double newZ2 = ((Entity)this.entity).posZ + (double)((((Entity)this.entity).world.rand.nextFloat() * 8.0f - 4.0f) * 6.0f);
                    d0 = newX2 - ((Entity)this.entity).posX;
                    d2 = newY2 - ((Entity)this.entity).posY;
                    d3 = newZ2 - ((Entity)this.entity).posZ;
                    d4 = d0 * d0 + d2 * d2 + d3 * d3;
                    d4 = MathHelper.sqrt((double)d4);
                    ((Entity)this.entity).motionX += d0 / d4 * 0.1;
                    ((Entity)this.entity).motionY += d2 / d4 * 0.1 + 0.1;
                }
                ((Entity)this.entity).motionZ += d3 / d4 * 0.1;
            }
            ((Entity)this.entity).rotationYaw = n = -((float)Math.atan2(((Entity)this.entity).motionX, ((Entity)this.entity).motionZ)) * 180.0f / (float)Math.PI;
            this.entity.setRenderYawOffset(n);
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - ((Entity)this.entity).posX) / par7;
        double d5 = (par3 - ((Entity)this.entity).posY) / par7;
        double d6 = (par5 - ((Entity)this.entity).posZ) / par7;
        AxisAlignedBB axisalignedbb = this.entity.getEntityBoundingBox();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!((Entity)this.entity).world.getCollisionBoxes(this.entity, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

