/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.msrandom.witchery.block.BlockVoidBramble;
import net.msrandom.witchery.entity.EntityFlyingTameable;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.entity.item.EntityBrew;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.util.Waypoint;

public class EntityAIFlyerFlyToWaypoint
extends EntityAIBase {
    private static final double HIT_RADIUS = 1.0;
    private static final double HIT_RADIUS_SQ = 1.0;
    private final EntityFlyingTameable flyer;
    private final CarryRequirement carryRequirement;
    int courseTimer = 0;

    public EntityAIFlyerFlyToWaypoint(EntityFlyingTameable flyer, CarryRequirement carryRestrictions) {
        this.flyer = flyer;
        this.carryRequirement = carryRestrictions;
        this.setMutexBits(7);
    }

    public boolean shouldExecute() {
        return !this.flyer.waypoint.isEmpty() && (!this.flyer.getHeldItemMainhand().isEmpty() || this.carryRequirement != CarryRequirement.HELD_ITEM);
    }

    public boolean shouldContinueExecuting() {
        boolean heldItem = !this.flyer.getHeldItemMainhand().isEmpty();
        boolean awayFromHome = this.flyer.getDistanceSq(this.flyer.homeX, this.flyer.posY, this.flyer.homeZ) > 1.0 || Math.abs(this.flyer.posY - this.flyer.homeY) > 1.0;
        return heldItem && this.carryRequirement == CarryRequirement.HELD_ITEM || this.flyer.waypoint != null || awayFromHome;
    }

    public void startExecuting() {
    }

    public void resetTask() {
        this.flyer.waypoint = ItemStack.EMPTY;
        this.flyer.setSitting(true);
        if (!this.flyer.getPassengers().isEmpty()) {
            ((Entity)this.flyer.getPassengers().get(0)).dismountRidingEntity();
        }
        this.courseTimer = 0;
    }

    public void updateTask() {
        if (!this.flyer.isSitting()) {
            float n;
            Waypoint waypoint = this.flyer.getWaypoint();
            if (this.carryRequirement == CarryRequirement.ENTITY_LIVING) {
                List entities;
                if (this.flyer.getDistanceSq(waypoint.X, waypoint.Y, waypoint.Z) <= 1.0 && (entities = this.flyer.world.getEntitiesWithinAABB(EntityLivingBase.class, this.flyer.getEntityBoundingBox().expand(1.0, 1.0, 1.0))).size() > 1) {
                    if (!this.flyer.world.isRemote) {
                        for (EntityLivingBase entity : entities) {
                            if (entity == this.flyer) continue;
                            entity.startRiding((Entity)this.flyer);
                        }
                    }
                    this.flyer.waypoint = ItemStack.EMPTY;
                    waypoint = this.flyer.getWaypoint();
                }
            } else if (!this.flyer.getHeldItemMainhand().isEmpty() && this.flyer.getDistanceSq(waypoint.X, waypoint.Y, waypoint.Z) <= 1.0) {
                if (!this.flyer.world.isRemote) {
                    ItemStack stack = this.flyer.getHeldItemMainhand();
                    this.flyer.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    if (WitcheryIngredientItem.isBrew(stack)) {
                        this.flyer.world.playSound(null, this.flyer.getPosition(), SoundEvents.ENTITY_ARROW_SHOOT, this.flyer.getSoundCategory(), 0.5f, 0.4f / (this.flyer.world.rand.nextFloat() * 0.4f + 0.8f));
                        EntityWitchProjectile projectile = new EntityWitchProjectile(this.flyer.world, (EntityLivingBase)this.flyer, stack);
                        projectile.shoot((Entity)this.flyer, this.flyer.rotationPitch, this.flyer.rotationYaw, -20.0f, 0.5f, 1.0f);
                        projectile.motionX = 0.0;
                        projectile.motionZ = 0.0;
                        this.flyer.world.spawnEntity((Entity)projectile);
                    } else if (stack.getItem() == WitcheryGeneralItems.SPLASH_BREW_BOTTLE || stack.getItem() == WitcheryGeneralItems.LINGERING_BREW_BOTTLE) {
                        this.flyer.world.playSound(null, this.flyer.getPosition(), SoundEvents.ENTITY_ARROW_SHOOT, this.flyer.getSoundCategory(), 0.5f, 0.4f / (this.flyer.world.rand.nextFloat() * 0.4f + 0.8f));
                        EntityBrew projectile = new EntityBrew(this.flyer.world, (EntityLivingBase)this.flyer, stack, false);
                        projectile.shoot((Entity)this.flyer, this.flyer.rotationPitch, this.flyer.rotationYaw, -20.0f, 0.75f, 1.0f);
                        projectile.motionX = 0.0;
                        projectile.motionZ = 0.0;
                        this.flyer.world.spawnEntity((Entity)projectile);
                    } else if (stack.getItem() == Items.SPLASH_POTION || stack.getItem() == Items.LINGERING_POTION) {
                        this.flyer.world.playSound(null, this.flyer.getPosition(), SoundEvents.ENTITY_ARROW_SHOOT, this.flyer.getSoundCategory(), 0.5f, 0.4f / (this.flyer.world.rand.nextFloat() * 0.4f + 0.8f));
                        EntityPotion projectile = new EntityPotion(this.flyer.world, (EntityLivingBase)this.flyer, stack);
                        projectile.shoot((Entity)this.flyer, this.flyer.rotationPitch, this.flyer.rotationYaw, -20.0f, 0.5f, 1.0f);
                        projectile.motionX = 0.0;
                        projectile.motionZ = 0.0;
                        this.flyer.world.spawnEntity((Entity)projectile);
                    } else {
                        EntityItem item = new EntityItem(this.flyer.world, this.flyer.posX, this.flyer.posY, this.flyer.posZ, stack);
                        if (stack.getItem() == Item.getItemFromBlock((Block)WitcheryBlocks.MINDRAKE)) {
                            item.lifespan = 60;
                        }
                        this.flyer.world.spawnEntity((Entity)item);
                    }
                }
                this.flyer.waypoint = ItemStack.EMPTY;
                waypoint = this.flyer.getWaypoint();
            }
            double dX = waypoint.X - this.flyer.posX;
            double dY = waypoint.Y - this.flyer.posY;
            double dZ = waypoint.Z - this.flyer.posZ;
            double trajectory = dX * dX + dY * dY + dZ * dZ;
            if ((trajectory = (double)MathHelper.sqrt((double)trajectory)) >= 128.0 && this.carryRequirement == CarryRequirement.HELD_ITEM) {
                BlockVoidBramble.teleportRandomly(this.flyer.world, new BlockPos(waypoint.X, waypoint.Y, waypoint.Z), (Entity)this.flyer, 16);
            }
            if (--this.courseTimer < 0) {
                this.courseTimer = 0;
            }
            if (this.courseTimer == 0) {
                if (!this.isCourseTraversable(waypoint.X, waypoint.Y, waypoint.Z, trajectory)) {
                    double newX = this.flyer.posX + (this.flyer.world.rand.nextDouble() * 4.0 - 2.0) * 6.0;
                    double newY = this.flyer.posY + (this.flyer.world.rand.nextDouble() * 2.0 - 1.0) * 4.0;
                    double newZ = this.flyer.posZ + (this.flyer.world.rand.nextDouble() * 4.0 - 2.0) * 6.0;
                    if (this.flyer.world.rand.nextInt(2) != 0) {
                        dX = newX - this.flyer.posX;
                        dZ = newZ - this.flyer.posZ;
                    }
                    dY = this.flyer.getDistanceSq(waypoint.X, waypoint.Y, waypoint.Z) <= 1.0 ? (this.flyer.posY > waypoint.Y && newY > 0.0 ? -newY : newY) - this.flyer.posY : newY - this.flyer.posY;
                    trajectory = dX * dX + dY * dY + dZ * dZ;
                    trajectory = MathHelper.sqrt((double)trajectory);
                }
                double ACCELERATION = 0.2;
                EntityFlyingTameable flyer = this.flyer;
                flyer.motionX += dX / trajectory * ACCELERATION;
                EntityFlyingTameable flyer2 = this.flyer;
                flyer2.motionZ += dZ / trajectory * ACCELERATION;
                EntityFlyingTameable flyer3 = this.flyer;
                flyer3.motionY = flyer3.motionY + (dY / trajectory * ACCELERATION + (this.flyer.posY < Math.min(waypoint.Y + (double)(this.carryRequirement == CarryRequirement.HELD_ITEM ? 32 : 32), 255.0) ? 0.1 : 0.0));
                this.courseTimer = 10;
            }
            this.flyer.rotationYaw = n = -((float)Math.atan2(this.flyer.motionX, this.flyer.motionZ)) * 180.0f / (float)Math.PI;
            this.flyer.renderYawOffset = n;
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.flyer.posX) / par7;
        double d5 = (par3 - this.flyer.posY) / par7;
        double d6 = (par5 - this.flyer.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.flyer.getEntityBoundingBox();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.flyer.world.getCollisionBoxes((Entity)this.flyer, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static enum CarryRequirement {
        NONE,
        HELD_ITEM,
        ENTITY_LIVING;

    }
}

