/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFlyerAttackOnCollide
extends EntityAIBase {
    final World world;
    final EntityCreature attacker;
    final double speedTowardsTarget;
    final boolean longMemory;
    int attackTick;
    Path entityPath;
    Class<? extends EntityLivingBase> classTarget;
    private int delayCounter;
    private int failedPathFindingPenalty;

    public EntityAIFlyerAttackOnCollide(EntityCreature par1EntityCreature, Class<? extends EntityLivingBase> par2Class, double par3, boolean par5) {
        this(par1EntityCreature, par3, par5);
        this.classTarget = par2Class;
    }

    public EntityAIFlyerAttackOnCollide(EntityCreature par1EntityCreature, double par2, boolean par4) {
        this.attacker = par1EntityCreature;
        this.world = par1EntityCreature.world;
        this.speedTowardsTarget = par2;
        this.longMemory = par4;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        EntityLivingBase entitylivingbase = this.attacker.getAttackTarget();
        return entitylivingbase != null && entitylivingbase.isEntityAlive() && (this.classTarget == null || this.classTarget.isAssignableFrom(entitylivingbase.getClass()));
    }

    public boolean shouldContinueExecuting() {
        EntityLivingBase entitylivingbase = this.attacker.getAttackTarget();
        return entitylivingbase != null && entitylivingbase.isEntityAlive() && (this.longMemory ? this.attacker.isWithinHomeDistanceFromPosition(entitylivingbase.getPosition()) : !this.attacker.getNavigator().noPath());
    }

    public void startExecuting() {
        this.attacker.getNavigator().setPath(this.entityPath, this.speedTowardsTarget);
        this.delayCounter = 0;
    }

    public void resetTask() {
        this.attacker.getNavigator().clearPath();
    }

    public void updateTask() {
        double d0;
        EntityLivingBase entitylivingbase = this.attacker.getAttackTarget();
        this.attacker.getLookHelper().setLookPositionWithEntity((Entity)entitylivingbase, 30.0f, 30.0f);
        if ((this.longMemory || this.attacker.getEntitySenses().canSee((Entity)entitylivingbase)) && --this.delayCounter <= 0) {
            float n;
            this.delayCounter = this.failedPathFindingPenalty + 4 + this.attacker.getRNG().nextInt(7);
            d0 = entitylivingbase.posX - this.attacker.posX;
            double d2 = entitylivingbase.posY - this.attacker.posY;
            double d3 = entitylivingbase.posZ - this.attacker.posZ;
            double d4 = d0 * d0 + d2 * d2 + d3 * d3;
            if (this.isCourseTraversable(entitylivingbase.posX, entitylivingbase.posY, entitylivingbase.posZ, d4 = (double)MathHelper.sqrt((double)d4))) {
                EntityCreature attacker = this.attacker;
                attacker.motionX += d0 / d4 * 0.15;
                EntityCreature attacker2 = this.attacker;
                attacker2.motionY += d2 / d4 * 0.15;
                EntityCreature attacker3 = this.attacker;
                attacker3.motionZ += d3 / d4 * 0.15;
                this.failedPathFindingPenalty = 0;
            } else {
                this.failedPathFindingPenalty += 10;
            }
            this.attacker.rotationYaw = n = -((float)Math.atan2(this.attacker.motionX, this.attacker.motionZ)) * 180.0f / (float)Math.PI;
            this.attacker.renderYawOffset = n;
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        d0 = this.attacker.width * 2.0f * this.attacker.width * 2.0f + entitylivingbase.width;
        if (this.attacker.getDistanceSq(entitylivingbase.posX, entitylivingbase.getEntityBoundingBox().minY, entitylivingbase.posZ) <= d0 && this.attackTick <= 0) {
            this.attackTick = 20;
            if (!this.attacker.getHeldItemMainhand().isEmpty()) {
                this.attacker.swingArm(EnumHand.MAIN_HAND);
            }
            this.attacker.attackEntityAsMob((Entity)entitylivingbase);
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.attacker.posX) / par7;
        double d5 = (par3 - this.attacker.posY) / par7;
        double d6 = (par5 - this.attacker.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.attacker.getEntityBoundingBox();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.attacker.world.getCollisionBoxes((Entity)this.attacker, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

