/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class EntityAIFlyerArrowAttack
extends EntityAIBase {
    private final EntityLiving entityHost;
    private final IRangedAttackMob rangedAttackEntityHost;
    private EntityLivingBase attackTarget;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;
    private int delayCounter;
    private int failedPathFindingPenalty;

    public EntityAIFlyerArrowAttack(IRangedAttackMob par1IRangedAttackMob, double par2, int par4, float par5) {
        this(par1IRangedAttackMob, par2, par4, par4, par5);
    }

    public EntityAIFlyerArrowAttack(IRangedAttackMob par1IRangedAttackMob, double par2, int par4, int par5, float par6) {
        if (!(par1IRangedAttackMob instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = par1IRangedAttackMob;
        this.entityHost = (EntityLiving)par1IRangedAttackMob;
        this.entityMoveSpeed = par2;
        this.attackIntervalMin = par4;
        this.maxRangedAttackTime = par5;
        this.attackRadius = par6;
        this.maxAttackDistance = par6 * par6;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        EntityLivingBase entitylivingbase = this.entityHost.getAttackTarget();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean shouldContinueExecuting() {
        return this.shouldExecute() || !this.entityHost.getNavigator().noPath();
    }

    public void resetTask() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
        this.delayCounter = 0;
    }

    public void updateTask() {
        double d0 = this.entityHost.getDistanceSq(this.attackTarget.posX, this.attackTarget.getEntityBoundingBox().minY, this.attackTarget.posZ);
        boolean flag = this.entityHost.getEntitySenses().canSee((Entity)this.attackTarget);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (d0 > (double)this.maxAttackDistance && --this.delayCounter <= 0) {
            float n;
            this.delayCounter = this.failedPathFindingPenalty + 4 + this.entityHost.getRNG().nextInt(7);
            double d2 = this.attackTarget.posX - this.entityHost.posX;
            double d3 = this.attackTarget.posY - this.entityHost.posY;
            double d4 = this.attackTarget.posZ - this.entityHost.posZ;
            double d5 = d2 * d2 + d3 * d3 + d4 * d4;
            if (this.isCourseTraversable(this.attackTarget.posX, this.attackTarget.posY, this.attackTarget.posZ, d5 = (double)MathHelper.sqrt((double)d5))) {
                EntityLiving entityHost = this.entityHost;
                entityHost.motionX += d2 / d5 * 0.15;
                EntityLiving entityHost2 = this.entityHost;
                entityHost2.motionY += d3 / d5 * 0.15;
                EntityLiving entityHost3 = this.entityHost;
                entityHost3.motionZ += d4 / d5 * 0.15;
                this.failedPathFindingPenalty = 0;
            } else {
                this.failedPathFindingPenalty += 10;
            }
            this.entityHost.rotationYaw = n = -((float)Math.atan2(this.entityHost.motionX, this.entityHost.motionZ)) * 180.0f / (float)Math.PI;
            this.entityHost.renderYawOffset = n;
            this.entityHost.getNavigator().tryMoveToEntityLiving((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.getLookHelper().setLookPositionWithEntity((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            if (d0 > (double)this.maxAttackDistance || !flag) {
                return;
            }
            float f2 = MathHelper.sqrt((double)d0) / this.attackRadius;
            float f = f2;
            if (f < 0.1f) {
                f2 = 0.1f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.rangedAttackEntityHost.attackEntityWithRangedAttack(this.attackTarget, f2);
            this.rangedAttackTime = MathHelper.floor((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0) {
            float f = MathHelper.sqrt((double)d0) / this.attackRadius;
            this.rangedAttackTime = MathHelper.floor((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.attackTarget.posX) / par7;
        double d5 = (par3 - this.attackTarget.posY) / par7;
        double d6 = (par5 - this.attackTarget.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.attackTarget.getEntityBoundingBox();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.attackTarget.world.getCollisionBoxes((Entity)this.attackTarget, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

