/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntitySpectralFamiliar;

public class EntityAIFamiliarFindDiamonds
extends EntityAIBase {
    private final EntitySpectralFamiliar theFamiliar;
    private final double speed;
    private int currentTick;
    private int distance;
    private int maxSittingTicks;
    private int sitableBlockX;
    private int sitableBlockY;
    private int sitableBlockZ;

    public EntityAIFamiliarFindDiamonds(EntitySpectralFamiliar familiarEntity, double par2) {
        this.theFamiliar = familiarEntity;
        this.speed = par2;
        this.setMutexBits(5);
    }

    public boolean shouldExecute() {
        EntityLivingBase entitylivingbase = this.theFamiliar.getOwner();
        return this.theFamiliar.isTamed() && !this.theFamiliar.isSitting() && this.theFamiliar.getBlockIDToFind() != null && entitylivingbase != null && this.theFamiliar.getDistanceSq((Entity)entitylivingbase) < 100.0 && this.theFamiliar.getRNG().nextDouble() <= 0.1 && this.getNearbySitableBlockDistance();
    }

    public boolean shouldContinueExecuting() {
        EntityLivingBase entitylivingbase = this.theFamiliar.getOwner();
        return this.currentTick <= this.maxSittingTicks && this.distance <= 60 && entitylivingbase != null && this.theFamiliar.getDistanceSq((Entity)entitylivingbase) < 100.0 && this.isSittableBlock(this.theFamiliar.world, this.sitableBlockX, this.sitableBlockY, this.sitableBlockZ);
    }

    public void startExecuting() {
        if (!this.theFamiliar.getNavigator().tryMoveToXYZ((double)this.sitableBlockX + 0.5, (double)(this.sitableBlockY + 1), (double)this.sitableBlockZ + 0.5, this.speed)) {
            this.theFamiliar.getNavigator().tryMoveToXYZ((double)this.sitableBlockX + 0.5, this.theFamiliar.posY + 1.0, (double)this.sitableBlockZ + 0.5, this.speed);
        }
        this.currentTick = 0;
        this.distance = 0;
        this.maxSittingTicks = this.theFamiliar.getRNG().nextInt(this.theFamiliar.getRNG().nextInt(1200) + 1200) + 1200;
        this.theFamiliar.getAISit().setSitting(false);
    }

    public void resetTask() {
        this.theFamiliar.setSitting(false);
    }

    public void updateTask() {
        ++this.currentTick;
        this.theFamiliar.getAISit().setSitting(false);
        if (this.theFamiliar.getDistanceSq(this.sitableBlockX, this.theFamiliar.posY, this.sitableBlockZ) > 2.0) {
            this.theFamiliar.setSitting(false);
            if (!this.theFamiliar.getNavigator().tryMoveToXYZ((double)this.sitableBlockX + 0.5, (double)(this.sitableBlockY + 1), (double)this.sitableBlockZ + 0.5, this.speed)) {
                this.theFamiliar.getNavigator().tryMoveToXYZ((double)this.sitableBlockX + 0.5, this.theFamiliar.posY, (double)this.sitableBlockZ + 0.5, this.speed);
            }
            ++this.distance;
        } else if (!this.theFamiliar.isSitting()) {
            EntityLivingBase living = this.theFamiliar.getOwner();
            if (living instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)living;
                this.theFamiliar.world.playSound(null, player.getPosition(), SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, this.theFamiliar.getSoundCategory(), 0.5f, 0.4f / (this.theFamiliar.getRNG().nextFloat() * 0.4f + 0.8f));
                player.sendMessage(new TextComponentTranslation("entity.witchery.spectral_familiar.found_something", new Object[]{MathHelper.floor((double)this.theFamiliar.posX), MathHelper.floor((double)this.theFamiliar.posY), MathHelper.floor((double)this.theFamiliar.posZ)}).setStyle(new Style().setColor(TextFormatting.LIGHT_PURPLE)));
            }
            this.theFamiliar.clearItemToFind();
            this.theFamiliar.setAISitting(true);
        } else {
            --this.distance;
        }
    }

    protected boolean getNearbySitableBlockDistance() {
        int MAX_WIDTH = 4;
        int DEPTH = this.theFamiliar.getDepthToFind();
        int i = 1;
        while ((double)i < (double)DEPTH) {
            int j = (int)this.theFamiliar.posX - MAX_WIDTH;
            while ((double)j < this.theFamiliar.posX + (double)MAX_WIDTH) {
                int k = (int)this.theFamiliar.posZ - MAX_WIDTH;
                while ((double)k < this.theFamiliar.posZ + (double)MAX_WIDTH) {
                    if (this.isSittableBlock(this.theFamiliar.world, j, i, k)) {
                        this.sitableBlockX = j;
                        this.sitableBlockY = i;
                        this.sitableBlockZ = k;
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSittableBlock(World par1World, int par2, int par3, int par4) {
        Block blockID = this.theFamiliar.getBlockIDToFind();
        Block foundBlockID = par1World.getBlockState(new BlockPos(par2, par3, par4)).getBlock();
        if (blockID == Blocks.DIAMOND_ORE) {
            return foundBlockID == blockID || foundBlockID == Blocks.EMERALD_ORE;
        }
        if (blockID == Blocks.EMERALD_ORE) {
            return foundBlockID == blockID || foundBlockID == Blocks.DIAMOND_ORE;
        }
        return foundBlockID == blockID;
    }
}

