/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.player.EntityPlayer;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityAIEnslaverHurtByTarget
extends EntityAITarget {
    final EntityCreature enslavedEntity;
    EntityLivingBase enslaversAttacker;
    private int enslaversRevengeTimer;

    public EntityAIEnslaverHurtByTarget(EntityCreature enslavedCreature) {
        super(enslavedCreature, false);
        this.enslavedEntity = enslavedCreature;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        if (!this.enslavedEntity.isPotionActive(WitcheryPotionEffects.ENSLAVED)) {
            return false;
        }
        UUID owner = PotionEnslaved.getMobEnslaverId((EntityLiving)this.enslavedEntity);
        if (owner == null) {
            return false;
        }
        EntityPlayer enslaver = WitcheryUtils.getPlayer(this.enslavedEntity.world, owner);
        if (enslaver == null) {
            return false;
        }
        this.enslaversAttacker = enslaver.getRevengeTarget();
        int revengeTimer = enslaver.getRevengeTimer();
        return revengeTimer != this.enslaversRevengeTimer && this.enslaversAttacker != null && this.isSuitableTarget(this.enslaversAttacker, false);
    }

    public void startExecuting() {
        EntityUtil.setTarget((EntityLiving)this.taskOwner, this.enslaversAttacker);
        UUID enslaverId = PotionEnslaved.getMobEnslaverId((EntityLiving)this.enslavedEntity);
        EntityPlayer enslaver = WitcheryUtils.getPlayer(this.enslavedEntity.world, enslaverId);
        if (enslaver != null) {
            this.enslaversRevengeTimer = enslaver.getRevengeTimer();
        }
        super.startExecuting();
    }
}

