/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.ArrayList;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ReportedException;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.msrandom.witchery.entity.EntityGoblin;

public class EntityAIDropOffBlocks
extends EntityAIBase {
    protected final EntityGoblin entity;
    protected final double range;
    private TileEntity targetTile = null;

    public EntityAIDropOffBlocks(EntityGoblin entity, double range) {
        this.entity = entity;
        this.range = range;
        this.setMutexBits(7);
    }

    public boolean shouldExecute() {
        if (this.entity != null && !this.entity.isWorshipping() && this.entity.getHeldItemMainhand().isEmpty() || !this.entity.getLeashed() || this.entity.getHeldItemMainhand().getItem() instanceof ItemTool) {
            return false;
        }
        if (this.targetTile != null && !this.targetTile.isInvalid() && this.entity.getNavigator().getPathToPos(this.targetTile.getPos()) != null) {
            return true;
        }
        this.targetTile = null;
        if (this.entity.world.rand.nextInt(60) != 0) {
            return false;
        }
        this.setTargetTile();
        return this.targetTile != null;
    }

    public void startExecuting() {
    }

    private void setTargetTile() {
        this.targetTile = null;
        ArrayList chests = new ArrayList();
        double bestDist = Double.MAX_VALUE;
        double RANGE_SQ = this.range * this.range;
        for (int i = 0; i < this.entity.world.loadedTileEntityList.size(); ++i) {
            try {
                double distSq;
                TileEntity tile = (TileEntity)this.entity.world.loadedTileEntityList.get(i);
                if (!(tile instanceof IInventory) || tile.isInvalid() || ((IInventory)tile).getSizeInventory() < 27 || !((distSq = this.entity.getDistanceSq(tile.getPos().getX(), tile.getPos().getY(), tile.getPos().getZ())) <= RANGE_SQ) || this.entity.getNavigator().getPathToXYZ((double)tile.getPos().getX(), (double)tile.getPos().getY(), (double)tile.getPos().getZ()) == null || !(distSq < bestDist)) continue;
                bestDist = distSq;
                this.targetTile = tile;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean shouldContinueExecuting() {
        return this.entity != null && !this.entity.isWorshipping() && !this.entity.getHeldItemMainhand().isEmpty() && this.entity.getLeashed() && this.targetTile != null;
    }

    public void updateTask() {
        if (this.entity.getNavigator().noPath()) {
            this.setTargetTile();
            if (this.targetTile != null) {
                this.entity.getNavigator().tryMoveToXYZ((double)this.targetTile.getPos().getX(), (double)this.targetTile.getPos().getY(), (double)this.targetTile.getPos().getZ(), 0.6);
            }
        }
        if (!this.entity.world.isRemote && this.targetTile != null && this.entity.getDistanceSq(this.targetTile.getPos()) <= 6.25) {
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.entity.world));
            IInventory inventory = (IInventory)this.targetTile;
            inventory.openInventory((EntityPlayer)fakePlayer);
            this.addItemStackToInventory(this.entity.getHeldItemMainhand(), inventory);
            inventory.closeInventory((EntityPlayer)fakePlayer);
        }
    }

    public void addItemStackToInventory(ItemStack par1ItemStack, IInventory inventory) {
        if (par1ItemStack != null && par1ItemStack.getCount() != 0 && par1ItemStack.getItem() != Items.AIR) {
            try {
                if (!par1ItemStack.isItemDamaged()) {
                    int i;
                    do {
                        i = par1ItemStack.getCount();
                        par1ItemStack.setCount(this.storePartialItemStack(par1ItemStack, inventory));
                    } while (par1ItemStack.getCount() > 0 && par1ItemStack.getCount() < i);
                    return;
                }
                int i = this.getFirstEmptyStack(inventory);
                if (i >= 0) {
                    inventory.setInventorySlotContents(i, par1ItemStack.copy());
                    par1ItemStack.setCount(0);
                    par1ItemStack.setAnimationsToGo(5);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport((Throwable)throwable, (String)"Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Item being added");
                crashreportcategory.addCrashSection("Item ID", (Object)Item.getIdFromItem((Item)par1ItemStack.getItem()));
                crashreportcategory.addCrashSection("Item data", (Object)par1ItemStack.getItemDamage());
                crashreportcategory.addDetail("Item name", () -> ((ItemStack)par1ItemStack).getDisplayName());
                throw new ReportedException(crashreport);
            }
        }
    }

    public int getFirstEmptyStack(IInventory inventory) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            if (!inventory.getStackInSlot(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack par1ItemStack, IInventory inventory) {
        int k;
        Item item = par1ItemStack.getItem();
        int i = par1ItemStack.getCount();
        if (par1ItemStack.getMaxStackSize() == 1) {
            int j = this.getFirstEmptyStack(inventory);
            if (j < 0) {
                return i;
            }
            if (inventory.getStackInSlot(j).isEmpty()) {
                inventory.setInventorySlotContents(j, par1ItemStack.copy());
            }
            return 0;
        }
        int j = this.storeItemStack(par1ItemStack, inventory);
        if (j < 0) {
            j = this.getFirstEmptyStack(inventory);
        }
        if (j < 0) {
            return i;
        }
        if (inventory.getStackInSlot(j).isEmpty()) {
            inventory.setInventorySlotContents(j, new ItemStack(item, 0, par1ItemStack.getItemDamage()));
            if (par1ItemStack.hasTagCompound()) {
                inventory.getStackInSlot(j).setTagCompound(par1ItemStack.getTagCompound().copy());
            }
        }
        if ((k = i) > inventory.getStackInSlot(j).getMaxStackSize() - inventory.getStackInSlot(j).getCount()) {
            k = inventory.getStackInSlot(j).getMaxStackSize() - inventory.getStackInSlot(j).getCount();
        }
        if (k > 64 - inventory.getStackInSlot(j).getCount()) {
            k = 64 - inventory.getStackInSlot(j).getCount();
        }
        if (k == 0) {
            return i;
        }
        ItemStack stackInSlot = inventory.getStackInSlot(j);
        stackInSlot.grow(k);
        inventory.getStackInSlot(j).setAnimationsToGo(5);
        return i -= k;
    }

    private int storeItemStack(ItemStack par1ItemStack, IInventory inventory) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            if (inventory.getStackInSlot(i).isEmpty() || inventory.getStackInSlot(i).getItem() != par1ItemStack.getItem() || !inventory.getStackInSlot(i).isStackable() || inventory.getStackInSlot(i).getCount() >= inventory.getStackInSlot(i).getMaxStackSize() || inventory.getStackInSlot(i).getCount() >= 64 || inventory.getStackInSlot(i).getHasSubtypes() && inventory.getStackInSlot(i).getItemDamage() != par1ItemStack.getItemDamage() || !ItemStack.areItemStackTagsEqual((ItemStack)inventory.getStackInSlot(i), (ItemStack)par1ItemStack)) continue;
            return i;
        }
        return -1;
    }
}

