/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityAIDimensionalFollowOwner
extends EntityAIBase {
    final World theWorld;
    final float maxDist;
    final float minDist;
    private final EntityTameable thePet;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private EntityLivingBase theOwner;
    private int timeToRecalcPath;
    private boolean avoidWater;
    public boolean removeTask;
    public boolean resetTask;

    public EntityAIDimensionalFollowOwner(EntityTameable par1EntityTameable, double par2, float par4, float par5) {
        this.thePet = par1EntityTameable;
        this.theWorld = par1EntityTameable.world;
        this.followSpeed = par2;
        this.petPathfinder = par1EntityTameable.getNavigator();
        this.minDist = par4;
        this.maxDist = par5;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        EntityLivingBase entitylivingbase = this.thePet.getOwner();
        if (entitylivingbase == null) {
            return false;
        }
        if (this.thePet.isSitting()) {
            return false;
        }
        if (this.thePet.dimension != entitylivingbase.dimension || this.thePet.getDistanceSq((Entity)entitylivingbase) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.theOwner = entitylivingbase;
        return true;
    }

    public boolean shouldContinueExecuting() {
        return !this.petPathfinder.noPath() && this.thePet.getDistanceSq((Entity)this.theOwner) > (double)(this.maxDist * this.maxDist) && !this.thePet.isSitting();
    }

    public void startExecuting() {
        this.timeToRecalcPath = 0;
        this.resetTask = false;
    }

    public void resetTask() {
        this.theOwner = null;
        this.petPathfinder.clearPath();
        this.resetTask = true;
    }

    public void updateTask() {
        this.thePet.getLookHelper().setLookPositionWithEntity((Entity)this.theOwner, 10.0f, (float)this.thePet.getVerticalFaceSpeed());
        if (!this.thePet.isSitting() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!(this.petPathfinder.tryMoveToEntityLiving((Entity)this.theOwner, this.followSpeed) || this.thePet.getLeashed() || this.thePet.dimension == this.theOwner.dimension && !(this.thePet.getDistanceSq((Entity)this.theOwner) >= 144.0))) {
                int i = MathHelper.floor((double)this.theOwner.posX) - 2;
                int j = MathHelper.floor((double)this.theOwner.posZ) - 2;
                int k = MathHelper.floor((double)this.theOwner.getEntityBoundingBox().minY);
                for (int l = 0; l <= 4; ++l) {
                    for (int i2 = 0; i2 <= 4; ++i2) {
                        BlockPos pos = new BlockPos(i + l, k, j + i2);
                        if (l >= 1 && i2 >= 1 && l <= 3 && i2 <= 3 || !this.theOwner.world.getBlockState(pos.down()).isSideSolid((IBlockAccess)this.theOwner.world, pos.down(), EnumFacing.UP) || this.theOwner.world.getBlockState(pos).isNormalCube() || this.theOwner.world.getBlockState(pos.up()).isNormalCube()) continue;
                        if (this.thePet.dimension == this.theOwner.dimension) {
                            this.thePet.setLocationAndAngles((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i2) + 0.5f), this.thePet.rotationYaw, this.thePet.rotationPitch);
                        }
                        this.petPathfinder.clearPath();
                        return;
                    }
                }
            }
        }
    }
}

