/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.BlockUtil;

public class EntityAIDigBlocks
extends EntityAIBase {
    public static final GameProfile NORMAL_MINER_PROFILE = new GameProfile(UUID.fromString("AB06ACB0-0CDB-11E4-9191-0800200C9A66"), "[Minecraft]");
    public static final GameProfile KOBOLDITE_MINER_PROFILE = new GameProfile(UUID.fromString("24818AE0-0CDE-11E4-9191-0800200C9A66"), "[Minecraft]");
    protected final EntityGoblin entity;
    protected final double range;
    protected final double kobolditeChance;
    RayTraceResult mop = null;
    int failedChecks = 0;
    private int waitTimer = 60;

    public EntityAIDigBlocks(EntityGoblin entity, double range, double kobolditeChance) {
        this.entity = entity;
        this.range = range;
        this.kobolditeChance = kobolditeChance;
        this.setMutexBits(7);
    }

    private static RayTraceResult raytraceBlocks(World world, EntityLiving player, double reachDistance, boolean down) {
        float rotationYaw;
        Vec3d playerPosition = player.getPositionEyes(1.0f);
        player.rotationYaw = rotationYaw = (float)world.rand.nextInt(360);
        float rotationPitch = down ? 90.0f : 0.0f;
        float f1 = MathHelper.cos((float)(-rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.sin((float)(-rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.cos((float)(-rotationPitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.sin((float)(-rotationPitch * ((float)Math.PI / 180)));
        Vec3d playerLook = new Vec3d((double)(f2 * f3), (double)f4, (double)(f1 * f3));
        Vec3d playerViewOffset = new Vec3d(playerPosition.x + playerLook.x * reachDistance, playerPosition.y + playerLook.y * reachDistance, playerPosition.z + playerLook.z * reachDistance);
        return world.rayTraceBlocks(playerPosition, playerViewOffset, true, false, false);
    }

    private static boolean isHoldingKobolditePick(EntityLivingBase entity) {
        return entity.getHeldItemMainhand().getItem() == WitcheryGeneralItems.KOBOLDITE_PICKAXE;
    }

    public static boolean tryHarvestBlock(World world, BlockPos pos, EntityLivingBase harvester) {
        boolean kobolditePick = EntityAIDigBlocks.isHoldingKobolditePick(harvester);
        FakePlayer minerPlayer = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)(kobolditePick ? KOBOLDITE_MINER_PROFILE : NORMAL_MINER_PROFILE));
        return EntityAIDigBlocks.tryHarvestBlock(world, pos, harvester, (EntityPlayer)minerPlayer);
    }

    public static boolean tryHarvestBlock(World world, BlockPos pos, EntityLivingBase harvester, EntityPlayer minerPlayer) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, minerPlayer);
        event.setCanceled(false);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        ItemStack stack = harvester.getHeldItemMainhand();
        if (!stack.isEmpty() && stack.getItem().onBlockStartBreak(stack, pos, minerPlayer)) {
            return false;
        }
        world.playEvent(2001, pos, Block.getStateId((IBlockState)state));
        boolean canHarvest = false;
        if (state.getBlockHardness(world, pos) >= 0.0f) {
            String tool;
            if (state.getMaterial().isToolNotRequired()) {
                canHarvest = true;
            }
            if ((tool = block.getHarvestTool(state)) != null) {
                int toolLevel;
                int n = toolLevel = !stack.isEmpty() ? stack.getItem().getHarvestLevel(stack, tool, minerPlayer, state) : 0;
                if (toolLevel < 0) {
                    canHarvest = true;
                }
                if (toolLevel >= block.getHarvestLevel(state)) {
                    canHarvest = true;
                }
            }
        }
        if (canHarvest && (canHarvest = EntityAIDigBlocks.removeBlock(world, pos, minerPlayer))) {
            block.harvestBlock(world, minerPlayer, pos, state, world.getTileEntity(pos), stack);
        }
        return canHarvest;
    }

    private static boolean removeBlock(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        block.onBlockHarvested(world, pos, state, player);
        boolean flag = block.removedByPlayer(state, world, pos, player, true);
        if (flag) {
            block.onPlayerDestroy(world, pos, state);
        }
        return flag;
    }

    public static void onHarvestDrops(EntityPlayer harvester, BlockEvent.HarvestDropsEvent event) {
        if (harvester != null && !harvester.world.isRemote && !event.isCanceled() && (EntityAIDigBlocks.isEqual(harvester.getGameProfile(), KOBOLDITE_MINER_PROFILE) || EntityAIDigBlocks.isEqual(harvester.getGameProfile(), NORMAL_MINER_PROFILE))) {
            boolean hasKobolditePick = EntityAIDigBlocks.isEqual(harvester.getGameProfile(), KOBOLDITE_MINER_PROFILE);
            ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
            double kobolditeChance = hasKobolditePick ? 0.02 : 0.01;
            for (ItemStack drop : event.getDrops()) {
                String oreName;
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)drop);
                boolean addOriginal = true;
                if (oreIDs.length > 0 && (oreName = OreDictionary.getOreName((int)oreIDs[0])) != null && oreName.startsWith("ore")) {
                    ItemStack smeltedDrop = FurnaceRecipes.instance().getSmeltingResult(drop);
                    if (hasKobolditePick && harvester.world.rand.nextDouble() < 0.5) {
                        addOriginal = false;
                        newDrops.add(smeltedDrop.copy());
                        newDrops.add(smeltedDrop.copy());
                        if (harvester.world.rand.nextDouble() < 0.25) {
                            newDrops.add(smeltedDrop.copy());
                        }
                    }
                    double d = kobolditeChance = hasKobolditePick ? 0.08 : 0.05;
                }
                if (!addOriginal) continue;
                newDrops.add(drop);
            }
            event.getDrops().clear();
            for (ItemStack newDrop : newDrops) {
                event.getDrops().add(newDrop);
            }
            if (harvester.world.rand.nextDouble() < kobolditeChance) {
                event.getDrops().add(new ItemStack(WitcheryIngredientItems.KOBOLDITE_DUST));
            }
        }
    }

    private static boolean isEqual(GameProfile a, GameProfile b) {
        return a != null && b != null && a.getId() != null && b.getId() != null && a.getId().equals(b.getId());
    }

    public boolean shouldExecute() {
        if (this.entity == null || this.entity.isWorshipping() || this.entity.getHeldItemMainhand().isEmpty() || !(this.entity.getHeldItemMainhand().getItem() instanceof ItemPickaxe) || !this.entity.getLeashed() || this.entity.world.rand.nextInt(2) != 0) {
            return false;
        }
        RayTraceResult mop = EntityAIDigBlocks.raytraceBlocks(this.entity.world, (EntityLiving)this.entity, this.failedChecks == 15 ? 1.0 : 4.0, this.failedChecks == 15);
        if (mop == null || mop.typeOfHit != RayTraceResult.Type.BLOCK) {
            ++this.failedChecks;
            return false;
        }
        IBlockState block = BlockUtil.getBlock(this.entity.world, mop);
        if (this.isMineable(block, this.entity.world, mop.getBlockPos())) {
            this.failedChecks = 0;
            this.mop = mop;
            return true;
        }
        this.mop = null;
        ++this.failedChecks;
        return false;
    }

    private boolean isMineable(IBlockState block, World world, BlockPos pos) {
        return (block.getMaterial() == Material.ROCK || block.getMaterial() == Material.SAND || block.getMaterial() == Material.GRASS || block.getMaterial() == Material.SNOW || block.getMaterial() == Material.GROUND) && block.getBlockHardness(world, pos) >= 0.0f;
    }

    public void startExecuting() {
        double SPEED = 0.6;
        this.entity.getNavigator().tryMoveToXYZ((double)this.mop.getBlockPos().getX(), (double)this.mop.getBlockPos().getY(), (double)this.mop.getBlockPos().getZ(), SPEED);
    }

    public boolean shouldContinueExecuting() {
        return this.entity != null && !this.entity.isWorshipping() && !this.entity.getHeldItemMainhand().isEmpty() && this.entity.getHeldItemMainhand().getItem() instanceof ItemPickaxe && this.entity.getLeashed() && this.mop != null;
    }

    public void resetTask() {
        if (this.entity.isWorking()) {
            this.entity.setWorking(false);
        }
    }

    public void updateTask() {
        IBlockState block;
        RayTraceResult mop;
        double DROP_RANGE = 2.5;
        double DROP_RANGE_SQ = 6.25;
        double dist = this.entity.getDistanceSq(this.mop.getBlockPos());
        boolean retry = true;
        if (dist <= DROP_RANGE_SQ) {
            if (!this.entity.isWorking()) {
                this.entity.setWorking(true);
            }
            if (--this.waitTimer == 0) {
                if (!EntityAIDigBlocks.tryHarvestBlock(this.entity.world, this.mop.getBlockPos(), (EntityLivingBase)this.entity)) {
                    retry = false;
                }
                this.mop = null;
                this.waitTimer = this.getNextHarvestDelay();
            }
        } else if (this.entity.getNavigator().noPath()) {
            this.mop = null;
            this.waitTimer = this.getNextHarvestDelay();
            if (this.entity.isWorking()) {
                this.entity.setWorking(false);
            }
        } else if (!this.entity.isWorking()) {
            this.entity.setWorking(true);
        }
        if (this.mop == null && retry && this.entity.world.rand.nextInt(20) != 0 && (mop = EntityAIDigBlocks.raytraceBlocks(this.entity.world, (EntityLiving)this.entity, 4.0, false)) != null && mop.typeOfHit == RayTraceResult.Type.BLOCK && this.isMineable(block = BlockUtil.getBlock(this.entity.world, mop), this.entity.world, mop.getBlockPos())) {
            this.mop = mop;
            this.waitTimer = this.getNextHarvestDelay();
        }
    }

    private int getNextHarvestDelay() {
        return EntityAIDigBlocks.isHoldingKobolditePick((EntityLivingBase)this.entity) ? 4 : 60;
    }
}

