/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.village.Village;

public class EntityAIDefendVillageGeneric
extends EntityAITarget {
    final IVillageGuard defender;
    EntityLivingBase villageAgressorTarget;

    public EntityAIDefendVillageGeneric(IVillageGuard guard) {
        super(guard.getCreature(), false, true);
        this.defender = guard;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        Village village = this.defender.getVillage();
        if (village == null) {
            return false;
        }
        this.villageAgressorTarget = village.findNearestVillageAggressor((EntityLivingBase)this.defender.getCreature());
        if (this.isSuitableTarget(this.villageAgressorTarget, false)) {
            return true;
        }
        if (this.taskOwner.getRNG().nextInt(20) == 0) {
            this.villageAgressorTarget = village.getNearestTargetPlayer((EntityLivingBase)this.defender.getCreature());
            return this.isSuitableTarget(this.villageAgressorTarget, false);
        }
        return false;
    }

    public void startExecuting() {
        this.defender.getCreature().setAttackTarget(this.villageAgressorTarget);
        super.startExecuting();
    }

    public static interface IVillageGuard {
        public Village getVillage();

        public EntityCreature getCreature();
    }
}

