/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class EntityAIAttackCloseTargetOnCollide
extends EntityAIAttackMelee {
    final EntityCreature attacker;
    final double maxDistance;
    Class<? extends EntityLivingBase> classTarget;

    public EntityAIAttackCloseTargetOnCollide(EntityCreature par1EntityLiving, Class<? extends EntityLivingBase> par2Class, double par3, boolean par4, double maxDistance) {
        this(par1EntityLiving, par3, par4, maxDistance);
        this.classTarget = par2Class;
    }

    public EntityAIAttackCloseTargetOnCollide(EntityCreature par1EntityLiving, double par2, boolean par3, double maxDistance) {
        super(par1EntityLiving, par2, par3);
        this.attacker = par1EntityLiving;
        this.maxDistance = maxDistance;
    }

    public boolean shouldExecute() {
        boolean execute = super.shouldExecute();
        if (execute && this.isTargetNearby()) {
            execute = false;
        }
        return execute;
    }

    protected boolean isTargetNearby() {
        EntityLivingBase entityTarget = this.attacker != null ? this.attacker.getAttackTarget() : null;
        return entityTarget == null || !(this.attacker.getDistanceSq((Entity)entityTarget) <= this.maxDistance * this.maxDistance) || this.attacker.getNavigator().getPathToEntityLiving((Entity)entityTarget) == null || entityTarget.getHeldItemMainhand().getItem() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM || entityTarget.getHeldItemOffhand().getItem() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM;
    }

    public boolean shouldContinueExecuting() {
        boolean execute = super.shouldContinueExecuting();
        if (execute && this.isTargetNearby()) {
            execute = false;
        }
        return execute;
    }
}

