/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockCircle;
import net.msrandom.witchery.block.BlockCircleGlyph;
import net.msrandom.witchery.block.WitcheryBlockLeaves;
import net.msrandom.witchery.block.WitcheryBlockLog;
import net.msrandom.witchery.block.WitcheryBlockPlanks;
import net.msrandom.witchery.block.WitcheryBlockSapling;
import net.msrandom.witchery.block.WitcheryWoodType;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.entity.EntityEnt;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityWitchProjectile
extends EntityThrowable {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.createKey(EntityWitchProjectile.class, (DataSerializer)DataSerializers.ITEM_STACK);

    public EntityWitchProjectile(World world) {
        super(world);
    }

    public EntityWitchProjectile(World world, EntityLivingBase entityLiving, ItemStack item) {
        super(world, entityLiving);
        this.setStack(item);
    }

    public EntityWitchProjectile(World world, double posX, double posY, double posZ, ItemStack item) {
        super(world, posX, posY, posZ);
        this.setStack(item);
    }

    public static void explodeIceBlock(World world, BlockPos pos, Entity entity) {
        boolean resistent;
        pos = pos.down();
        Block block = Blocks.ICE;
        boolean bl = resistent = entity instanceof EntityDemon || entity instanceof EntityBlaze || entity instanceof EntityDragon || entity instanceof EntityHornedHuntsman || entity instanceof EntityEnt || entity instanceof EntityWither || entity instanceof EntityIronGolem;
        if (resistent) {
            EntityWitchProjectile.setBlockIfNotSolid(world, pos.up(), (Block)Blocks.FLOWING_WATER);
        } else {
            int HEIGHT = 4;
            for (int i = 0; i < HEIGHT; ++i) {
                BlockPos up = pos.up(i);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.add(-2, 0, -1), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.west(2), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.add(-1, 0, 1), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.south(), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.east(), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.add(1, 0, -1), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.north(2), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.add(-1, 0, -2), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.add(-2, 0, -2), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.add(-2, 0, 1), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.add(1, 0, 1), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.add(1, 0, -2), block);
            }
            EntityWitchProjectile.setBlockIfNotSolid(world, pos, block);
            BlockPos up = pos.up(HEIGHT - 1);
            EntityWitchProjectile.setBlockIfNotSolid(world, up, block);
            EntityWitchProjectile.setBlockIfNotSolid(world, up.add(-1, 0, -1), block);
            EntityWitchProjectile.setBlockIfNotSolid(world, up.west(), block);
            EntityWitchProjectile.setBlockIfNotSolid(world, up.north(), block);
            if (entity instanceof EntityCreeper) {
                EntityCreeper creeper = (EntityCreeper)entity;
                boolean flag = world.getGameRules().getBoolean("mobGriefing");
                if (creeper.getPowered()) {
                    world.createExplosion((Entity)creeper, creeper.posX, creeper.posY, creeper.posZ, 6.0f, flag);
                } else {
                    world.createExplosion((Entity)creeper, creeper.posX, creeper.posY, creeper.posZ, 3.0f, flag);
                }
                creeper.setDead();
            }
        }
    }

    public static void explodeIceShield(World world, EntityLivingBase player, BlockPos pos, int height2) {
        double f1 = player != null ? (double)MathHelper.cos((float)(-player.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI)) : 0.0;
        double f2 = player != null ? (double)MathHelper.sin((float)(-player.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI)) : 0.0;
        Vec3d loc = new Vec3d(f2, 0.0, f1);
        if (!world.getBlockState(pos).getMaterial().isSolid()) {
            pos = pos.down();
        }
        EntityWitchProjectile.explodeIceColumn(world, pos.up(), height2);
        loc = loc.rotateYaw((float)Math.toRadians(90.0));
        EntityWitchProjectile.explodeIceColumn(world, pos.add(loc.x + 0.5, 1.0, loc.z + 0.5), height2);
        loc = loc.rotateYaw((float)Math.toRadians(180.0));
        EntityWitchProjectile.explodeIceColumn(world, pos.add(loc.x + 0.5, 1.0, loc.z + 0.5), height2);
    }

    public static void explodeIceColumn(World world, BlockPos pos, int height2) {
        for (int offsetPosY = 0; offsetPosY < height2; ++offsetPosY) {
            EntityWitchProjectile.setBlockIfNotSolid(world, pos.up(height2), Blocks.ICE);
        }
    }

    public static void raiseDead(BlockPos pos, World world, EntityLivingBase raiser) {
        int y0 = world.getBlockState(pos).getMaterial().isSolid() ? pos.getY() : pos.getY() - 1;
        int MAX_DISTANCE = 3;
        int MAX_DROP = 6;
        EntityPlayer playerThrower = raiser instanceof EntityPlayer ? (EntityPlayer)raiser : null;
        EntityWitchProjectile.raiseUndead(world, new BlockPos(pos.getX(), y0, pos.getZ()), playerThrower);
        int extraCount = 0;
        double chance = world.rand.nextDouble();
        if (chance < 0.1) {
            extraCount = 2;
        } else if (chance < 0.4) {
            extraCount = 1;
        }
        for (int i = 0; i < extraCount; ++i) {
            int x = pos.getX() - MAX_DISTANCE + world.rand.nextInt(MAX_DROP) + 1;
            int z = pos.getZ() - MAX_DISTANCE + world.rand.nextInt(MAX_DROP) + 1;
            int y2 = -1;
            for (int dy = -MAX_DROP; dy < MAX_DROP; ++dy) {
                if (!world.getBlockState(new BlockPos(x, y0 - dy, z)).getMaterial().isSolid()) continue;
                y2 = y0 - dy;
                break;
            }
            if (y2 == -1) continue;
            EntityWitchProjectile.raiseUndead(world, new BlockPos(x, y2, z), playerThrower);
        }
    }

    private static void raiseUndead(World world, BlockPos pos, EntityPlayer thrower) {
        if (!world.isRemote) {
            Block blockID = world.getBlockState(pos).getBlock();
            if (blockID != Blocks.DIRT && blockID != Blocks.STONE && blockID != Blocks.GRASS && blockID != Blocks.NETHERRACK && blockID != Blocks.MYCELIUM && blockID != Blocks.SOUL_SAND && blockID != Blocks.COBBLESTONE && blockID != Blocks.GRAVEL && blockID != Blocks.SAND) {
                pos = pos.up();
            }
            EntityWitchProjectile.spawnParticles(world, EnumParticleTypes.SMOKE_NORMAL, 0.5 + (double)pos.getX(), 0.5 + (double)pos.getY(), 0.5 + (double)pos.getZ());
            world.setBlockToAir(pos);
            world.setBlockToAir(pos.up());
            EntityLiving undeadEntity = EntityWitchProjectile.createUndeadCreature(world);
            undeadEntity.setLocationAndAngles(0.5 + (double)pos.getX(), 0.5 + (double)pos.getY(), 0.5 + (double)pos.getZ(), 1.0f, 0.0f);
            undeadEntity.onInitialSpawn(world.getDifficultyForLocation(undeadEntity.getPosition()), null);
            undeadEntity.enablePersistence();
            if (thrower != null) {
                PotionEnslaved.setEnslaverForMob(undeadEntity, thrower);
            }
            world.spawnEntity((Entity)undeadEntity);
        }
    }

    private static EntityLiving createUndeadCreature(World world) {
        double value = world.rand.nextDouble();
        if (value < 0.6) {
            return new EntityZombie(world);
        }
        if (value < 0.97) {
            return new EntitySkeleton(world);
        }
        return new EntityPigZombie(world);
    }

    public static void growBranch(BlockPos pos, World world, EnumFacing sideHit, int extent, AxisAlignedBB boundingBox) {
        AxisAlignedBB axisalignedbb;
        List list1;
        BlockPos p;
        int i;
        Block logBlock;
        IBlockState state = world.getBlockState(pos);
        Block blockID = state.getBlock();
        int var = world.rand.nextInt(4);
        WitcheryWoodType type = null;
        WitcheryWoodType[] types = new WitcheryWoodType[]{WitcheryWoodTypes.ROWAN, WitcheryWoodTypes.ALDER, WitcheryWoodTypes.HAWTHORN};
        if (blockID == Blocks.LOG || blockID == Blocks.PLANKS || blockID == Blocks.SAPLING || blockID == Blocks.LEAVES) {
            logBlock = Blocks.LOG;
        } else if (blockID instanceof WitcheryBlockLog || blockID instanceof WitcheryBlockPlanks || blockID instanceof WitcheryBlockSapling || blockID instanceof WitcheryBlockLeaves) {
            type = types[world.rand.nextInt(types.length)];
            logBlock = type.getLog();
        } else {
            Block block;
            if (world.rand.nextBoolean()) {
                block = Blocks.LOG;
            } else {
                type = types[world.rand.nextInt(types.length)];
                block = type.getLog();
            }
            logBlock = block;
        }
        BlockLeaves leavesBlock = Blocks.LOG == logBlock ? Blocks.LEAVES : type.getLeaves();
        IBlockState logState = logBlock.getDefaultState().withProperty((IProperty)BlockLog.LOG_AXIS, (Comparable)BlockLog.EnumAxis.fromFacingAxis((EnumFacing.Axis)sideHit.getAxis()));
        boolean isInitialBlockSolid = state.getMaterial().isSolid();
        int n = i = sideHit != EnumFacing.UP || isInitialBlockSolid ? 1 : 0;
        while (i < extent && (p = pos.add(i * sideHit.getDirectionVec().getX(), i * sideHit.getDirectionVec().getY(), i * sideHit.getDirectionVec().getZ())).getY() < 255 && EntityWitchProjectile.setBlockIfNotSolid(world, p, logBlock == Blocks.LOG ? logState.withProperty((IProperty)BlockOldLog.VARIANT, (Comparable)BlockPlanks.EnumType.values()[var]) : logState)) {
            int lz;
            int lx = sideHit.getAxis() != EnumFacing.Axis.X && world.rand.nextInt(4) == 0 ? world.rand.nextInt(3) - 1 : 0;
            int ly = sideHit.getAxis() != EnumFacing.Axis.Y && lx == 0 && world.rand.nextInt(4) == 0 ? world.rand.nextInt(3) - 1 : 0;
            int n2 = lz = sideHit.getAxis() != EnumFacing.Axis.Z && lx == 0 && ly == 0 && world.rand.nextInt(4) == 0 ? world.rand.nextInt(3) - 1 : 0;
            if (lx != 0 || ly != 0 || lz != 0) {
                EntityWitchProjectile.setBlockIfNotSolid(world, p.add(lx, ly, lz), leavesBlock == Blocks.LEAVES ? leavesBlock.getDefaultState().withProperty((IProperty)BlockOldLeaf.VARIANT, (Comparable)BlockPlanks.EnumType.values()[var]) : leavesBlock.getDefaultState());
            }
            ++i;
        }
        if (sideHit == EnumFacing.UP && !(list1 = world.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb = boundingBox.expand(0.0, 2.0, 0.0))).isEmpty()) {
            Iterator iterator = list1.iterator();
            BlockPos p2 = pos.add(i * sideHit.getDirectionVec().getX(), i * sideHit.getDirectionVec().getY() + pos.getY() > 255 ? 255 : i * sideHit.getDirectionVec().getY(), i * sideHit.getDirectionVec().getZ());
            while (iterator.hasNext()) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)iterator.next();
                BlockPos p3 = p2.up();
                if (world.getBlockState(p3).getMaterial().isSolid() || world.getBlockState(p3.up()).getMaterial().isSolid()) continue;
                entitylivingbase.setPosition((double)p3.getX() + 0.5, (double)p3.getY(), (double)p3.getZ() + 0.5);
            }
        }
    }

    public static void explodeWasting(World world, BlockPos pos, Entity livingEntity, AxisAlignedBB boundingBox, boolean enhanced) {
        double r = enhanced ? 5.0 : 4.0;
        AxisAlignedBB axisalignedbb = boundingBox.expand(r, 2.0, r);
        List list1 = world.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        if (!list1.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list1) {
                double d0 = entitylivingbase.getDistanceSq(pos);
                if (!(d0 < r * r)) continue;
                double d2 = 1.0 - Math.sqrt(d0) / r;
                if (entitylivingbase == livingEntity) {
                    d2 = 1.0;
                }
                int j = (int)(d2 * 400.0 + 0.5);
                if (entitylivingbase instanceof EntityPlayer) {
                    int minLevel;
                    EntityPlayer victim = (EntityPlayer)entitylivingbase;
                    int n = minLevel = enhanced ? 6 : 10;
                    if (victim.getFoodStats().getFoodLevel() > minLevel) {
                        victim.getFoodStats().addStats(-minLevel, 0.0f);
                    }
                    victim.addPotionEffect(new PotionEffect(MobEffects.HUNGER, j * 2, enhanced ? 2 : 1));
                    victim.addPotionEffect(new PotionEffect(MobEffects.POISON, Math.max(j / 3, 40), 0));
                    continue;
                }
                entitylivingbase.addPotionEffect(new PotionEffect(MobEffects.WITHER, j * 2, enhanced ? 1 : 0));
                entitylivingbase.addPotionEffect(new PotionEffect(MobEffects.POISON, Math.max(j / 3, 40), 0));
            }
        }
        int blockRadius = (int)r - 1;
        int blockRadiusSq = blockRadius * blockRadius;
        for (BlockPos p : BlockPos.getAllInBox((BlockPos)pos.add(-blockRadius, -blockRadius, -blockRadius), (BlockPos)pos.add(blockRadius, blockRadius, blockRadius))) {
            Block blockID;
            IBlockState state;
            Material material;
            if (!(pos.distanceSq((Vec3i)p) <= (double)blockRadiusSq) || (material = (state = world.getBlockState(p)).getMaterial()) != Material.LEAVES && (material != Material.PLANTS && material != Material.VINE || !material.isReplaceable()) || (blockID = state.getBlock()) instanceof BlockCircle || blockID instanceof BlockCircleGlyph) continue;
            blockID.dropBlockAsItem(world, p, state, 0);
            world.setBlockToAir(p);
        }
    }

    private static void spawnParticles(World world, EnumParticleTypes effect, double posX, double posY, double posZ) {
        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(posX, posY, posZ, 1.0f, 1.0f, effect), world, posX, posY, posZ, 8.0);
    }

    public static void explodeWeb(World world, BlockPos pos, EnumFacing side, boolean enhanced) {
        BlockPos p = side == null ? pos : pos.offset(side);
        EntityWitchProjectile.setBlockIfNotSolid(world, p, Blocks.WEB);
        EntityWitchProjectile.setBlockIfNotSolid(world, p.east(), Blocks.WEB);
        EntityWitchProjectile.setBlockIfNotSolid(world, p.west(), Blocks.WEB);
        EntityWitchProjectile.setBlockIfNotSolid(world, p.south(), Blocks.WEB);
        EntityWitchProjectile.setBlockIfNotSolid(world, p.north(), Blocks.WEB);
        if (enhanced) {
            EntityWitchProjectile.setBlockIfNotSolid(world, p.add(1, 0, 1), Blocks.WEB);
            EntityWitchProjectile.setBlockIfNotSolid(world, p.add(-1, 0, -1), Blocks.WEB);
            EntityWitchProjectile.setBlockIfNotSolid(world, p.add(-1, 0, 1), Blocks.WEB);
            EntityWitchProjectile.setBlockIfNotSolid(world, p.add(1, 0, -1), Blocks.WEB);
        }
        EntityWitchProjectile.setBlockIfNotSolid(world, p.up(), Blocks.WEB);
        EntityWitchProjectile.setBlockIfNotSolid(world, p.down(), Blocks.WEB);
    }

    public static boolean plantCactus(World world, BlockPos pos, int CACTUS_HEIGHT) {
        Material material;
        if (!world.getBlockState(pos).getMaterial().isSolid()) {
            pos = pos.down();
        }
        if ((material = world.getBlockState(pos).getMaterial()) != Material.CLAY && material != Material.CRAFTED_SNOW && material != Material.GRASS && material != Material.GROUND && material != Material.ROCK && material != Material.SAND && material != Material.SNOW && material != Material.SPONGE && material != Material.CACTUS) {
            return false;
        }
        IBlockState blockID = world.getBlockState(pos);
        if (!WitcheryUtils.canBreak(blockID)) {
            return false;
        }
        if (material != Material.CACTUS) {
            world.setBlockState(pos, Blocks.SAND.getDefaultState());
        } else {
            while (world.getBlockState(pos).getBlock() == Blocks.CACTUS) {
                pos = pos.up();
            }
            pos = pos.down();
        }
        for (int i = 1; i <= CACTUS_HEIGHT && pos.getY() + i < 256 && EntityWitchProjectile.setBlockIfNotSolid(world, pos.up(), (Block)Blocks.CACTUS); ++i) {
        }
        return true;
    }

    private static boolean setBlockIfNotSolid(World world, BlockPos pos, Block block) {
        return EntityWitchProjectile.setBlockIfNotSolid(world, pos, block.getDefaultState());
    }

    private static boolean setBlockIfNotSolid(World world, BlockPos pos, IBlockState state) {
        IBlockState original = world.getBlockState(pos);
        if (!original.getMaterial().isSolid() || state.getBlock() == Blocks.WEB && original.getBlock() == Blocks.SNOW) {
            world.setBlockState(pos, state, 3);
            EntityWitchProjectile.spawnParticles(world, EnumParticleTypes.EXPLOSION_NORMAL, 0.5 + (double)pos.getX(), 0.5 + (double)pos.getY(), 0.5 + (double)pos.getZ());
            return true;
        }
        return false;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(ITEM, (Object)ItemStack.EMPTY);
    }

    public ItemStack getStack() {
        return (ItemStack)this.dataManager.get(ITEM);
    }

    public void setStack(ItemStack item) {
        this.dataManager.set(ITEM, (Object)item);
    }

    protected float getGravityVelocity() {
        return this.getStack().getItem() instanceof ItemKettleBrew ? 0.05f : super.getGravityVelocity();
    }

    protected void onImpact(RayTraceResult mop) {
        if (!this.world.isRemote) {
            boolean enhanced = false;
            EntityLivingBase thrower = this.getThrower();
            if (thrower instanceof EntityPlayer) {
                enhanced = Familiars.hasFamiliarPower((EntityPlayer)thrower, WitcheryFamiliars.BREW_MASTERY);
            }
            boolean hasEffect = false;
            Item item = this.getStack().getItem();
            if (item instanceof ItemKettleBrew) {
                hasEffect = ((ItemKettleBrew)item).impact(this.world, this, thrower, mop, enhanced);
            } else if (WitcheryIngredientItems.WEB == item) {
                this.impactWebSmall(mop);
            } else if (WitcheryIngredientItems.ROCK == item) {
                this.impactRock(mop);
            }
            if (hasEffect) {
                this.world.playEvent(2002, this.getPosition(), 2);
            }
            this.setDead();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    private void impactRock(RayTraceResult mop) {
        if (mop.entityHit != null) {
            float DAMAGE = 6.0f;
            mop.entityHit.attackEntityFrom(DamageSource.causeThrownDamage((Entity)this, (Entity)this.getThrower()), DAMAGE);
        }
        EntityWitchProjectile.spawnParticles(this.world, EnumParticleTypes.EXPLOSION_NORMAL, this.posX, this.posY, this.posZ);
    }

    private void impactWebSmall(RayTraceResult mop) {
        switch (mop.typeOfHit) {
            case ENTITY: {
                this.world.setBlockState(mop.entityHit.getPosition(), Blocks.WEB.getDefaultState());
                break;
            }
            case BLOCK: {
                BlockPos pos = mop.getBlockPos();
                if (this.world.getBlockState(pos).getBlock() == Blocks.SNOW) {
                    pos = pos.down();
                    mop.sideHit = EnumFacing.UP;
                }
                EntityWitchProjectile.setBlockIfNotSolid(this.world, pos.offset(mop.sideHit), Blocks.WEB);
                break;
            }
        }
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        if (compound.hasKey("Item")) {
            this.setStack(new ItemStack(compound.getCompoundTag("Item")));
        }
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        ItemStack item = this.getStack();
        if (!item.isEmpty()) {
            compound.setTag("Item", (NBTBase)item.writeToNBT(new NBTTagCompound()));
        }
    }
}

