/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.items.WitcheryBoltItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ItemCrossbowPistol;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityWitchHunter
extends EntityCreature
implements IRangedAttackMob {
    private static final DataParameter<Integer> TYPE = EntityDataManager.createKey(EntityWitchHunter.class, (DataSerializer)DataSerializers.VARINT);
    private static final double HUNTER_NOTICE_CHANCE = 0.1;
    private static final long HUNTER_DELAY = 2400L;
    private static final double HUNTER_TRIGGER_CHANCE = 0.01;
    private final EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 20, 15.0f);
    private final EntityAINearestAttackableTarget<EntityLivingBase> aiAttackOnCollide = new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, false);
    private String targetPlayerName;

    public EntityWitchHunter(World par1World) {
        super(par1World);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, entity -> CreatureUtil.isUndead((Entity)entity) || CreatureUtil.isDemonic((Entity)entity) || entity instanceof EntityWitch || CreatureUtil.isWerewolf((Entity)entity) || entity instanceof EntityPlayer && (CreatureUtil.isWitch((Entity)entity) || CreatureUtil.isWerewolf((Entity)entity) || CreatureUtil.isVampire((Entity)entity) || this.targetPlayerName != null && !this.targetPlayerName.isEmpty() && entity.getName().equals(this.targetPlayerName))));
        this.experienceValue = 5;
        this.targetPlayerName = "";
        if (!par1World.isRemote) {
            this.setCombatTask();
        }
    }

    public static void blackMagicPerformed(EntityPlayer player) {
        NBTTagCompound nbtPlayer;
        if (player != null && player.world != null && !player.world.isRemote && (nbtPlayer = player.getEntityData()) != null && nbtPlayer.getLong("WitcheryHunterTrigger") <= 0L && player.world.rand.nextDouble() < 0.1) {
            long totalWorldTicks = MinecraftServer.getCurrentTimeMillis() / 50L;
            nbtPlayer.setLong("WitcheryHunterTrigger", totalWorldTicks);
        }
    }

    public static void handleWitchHunterEffects(EntityPlayer player) {
        NBTTagCompound nbtPlayer = player.getEntityData();
        long triggerTimeTicks = nbtPlayer.getLong("WitcheryHunterTrigger");
        if (triggerTimeTicks > 0L && player.world.getTotalWorldTime() >= triggerTimeTicks + 2400L && player.world.rand.nextDouble() < 0.01 || EntityWitchHunter.isVampireActive(player)) {
            nbtPlayer.removeTag("WitcheryHunterTrigger");
            int MAX_SPAWNS = 2;
            int tries = 3;
            int spawned = 0;
            for (int i = 0; i < tries && spawned < MAX_SPAWNS; ++i) {
                EntityWitchHunter creature = (EntityWitchHunter)Infusion.spawnCreature(player.world, EntityWitchHunter.class, player.getPosition(), (EntityLivingBase)player, 3, 8, EnumParticleTypes.SMOKE_NORMAL, null);
                if (creature == null) continue;
                ++spawned;
                creature.targetPlayerName = player.getName();
                creature.onInitialSpawn(player.world.getDifficultyForLocation(creature.getPosition()), null);
                EntityUtil.setTarget((EntityLiving)creature, (EntityLivingBase)player);
            }
            if (spawned > 0) {
                WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_HUNTER_COMING, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    private static boolean isVampireActive(EntityPlayer player) {
        Village village;
        if (WitcheryConfigOptions.vampireHunterSpawnChance <= 0.0 || player.capabilities.isCreativeMode) {
            return false;
        }
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        if (playerEx.getTransformation(WitcheryTransformations.VAMPIRE).getLevel() < 10) {
            return false;
        }
        if (player.world.rand.nextDouble() * 100.0 < WitcheryConfigOptions.vampireHunterSpawnChance && (village = player.world.villageCollection.getNearestVillage(player.getPosition(), 128)) != null && village.getPlayerReputation(player.getUniqueID()) < -1) {
            List hunters = player.world.getEntitiesWithinAABB(EntityWitchHunter.class, player.getEntityBoundingBox().expand(64.0, 16.0, 64.0));
            return hunters.size() == 0;
        }
        return false;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(30.0);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(TYPE, (Object)0);
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_VILLAGER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_VILLAGER_DEATH;
    }

    protected void playStepSound(BlockPos pos, Block block) {
        this.playSound(SoundEvents.BLOCK_GRASS_STEP, 0.15f, 1.0f);
    }

    public boolean attackEntityAsMob(Entity targetEntity) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue();
        int i = 0;
        if (targetEntity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getModifierForCreature((ItemStack)this.getHeldItemMainhand(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).getCreatureAttribute());
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this);
        }
        if (flag = targetEntity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                targetEntity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                targetEntity.setFire(j * 4);
            }
            if (targetEntity instanceof EntityLivingBase) {
                EnchantmentHelper.applyThornEnchantments((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
            }
            EnchantmentHelper.applyArthropodEnchantments((EntityLivingBase)this, (Entity)targetEntity);
        }
        return flag;
    }

    public void onLivingUpdate() {
        this.updateArmSwingProgress();
        float f = this.getBrightness();
        if (f > 0.5f) {
            this.idleTime += 2;
        }
        if (!this.world.isRemote && this.ticksExisted % 20 == 2 && this.isPotionActive(MobEffects.POISON)) {
            this.removePotionEffect(MobEffects.POISON);
        }
        super.onLivingUpdate();
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.ENTITY_HOSTILE_SWIM;
    }

    protected SoundEvent getSplashSound() {
        return SoundEvents.ENTITY_HOSTILE_SPLASH;
    }

    public void updateRidden() {
        super.updateRidden();
        if (this.getRidingEntity() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.getRidingEntity();
            this.renderYawOffset = entitycreature.renderYawOffset;
        }
    }

    public boolean attackEntityFrom(DamageSource damageSource, float damage) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, damageSource, damage)) {
            return super.attackEntityFrom(damageSource, damage);
        }
        if (damageSource.getTrueSource() != null && (damageSource.getTrueSource() instanceof EntityVillageGuard || damageSource.getTrueSource() instanceof EntityWitchHunter)) {
            return false;
        }
        if (this.isEntityInvulnerable(damageSource)) {
            return false;
        }
        if (!super.attackEntityFrom(damageSource, Math.min(damage, 9.0f))) {
            return false;
        }
        Entity entity = damageSource.getTrueSource();
        if (!this.getPassengers().isEmpty() && this.getPassengers().get(0) != entity && this.getRidingEntity() != entity) {
            if (entity != this && entity instanceof EntityLivingBase) {
                this.setAttackTarget((EntityLivingBase)entity);
            }
            return true;
        }
        return true;
    }

    protected SoundEvent getFallSound(int distance) {
        return distance > 4 ? SoundEvents.ENTITY_HOSTILE_BIG_FALL : SoundEvents.ENTITY_HOSTILE_SMALL_FALL;
    }

    protected void dropFewItems(boolean par1, int par2) {
        int j = this.rand.nextInt(3 + par2);
        for (int k = 0; k < j; ++k) {
            this.entityDropItem(new ItemStack((Item)WitcheryBoltItems.WOODEN_BOLT), 0.0f);
        }
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.onInitialSpawn(difficulty, livingdata);
        this.setHunterType(this.world.rand.nextInt(3));
        this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)WitcheryGeneralItems.CROSSBOW_PISTOL));
        this.setEnchantmentBasedOnDifficulty(difficulty);
        return livingdata;
    }

    public void setCombatTask() {
        this.tasks.removeTask(this.aiAttackOnCollide);
        this.tasks.removeTask((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.getHeldItemMainhand();
        if (!itemstack.isEmpty() && itemstack.getItem() == WitcheryGeneralItems.CROSSBOW_PISTOL) {
            this.tasks.addTask(4, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.tasks.addTask(4, this.aiAttackOnCollide);
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float par2) {
        ItemCrossbowPistol.Companion.launchNPCBolt(this.getHeldItemMainhand(), this.world, (EntityLiving)this, par2);
    }

    public void setSwingingArms(boolean b) {
    }

    public int getHunterType() {
        return (Integer)this.dataManager.get(TYPE);
    }

    public void setHunterType(int par1) {
        this.dataManager.set(TYPE, (Object)par1);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("HunterType")) {
            byte b0 = nbtRoot.getByte("HunterType");
            this.setHunterType(b0);
        }
        this.targetPlayerName = nbtRoot.getString("HunterTarget");
        this.setCombatTask();
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setByte("HunterType", (byte)this.getHunterType());
        nbtRoot.setString("HunterTarget", this.targetPlayerName);
    }

    public void setItemStackToSlot(EntityEquipmentSlot slot, ItemStack stack) {
        super.setItemStackToSlot(slot, stack);
        if (!this.world.isRemote && slot == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public double getYOffset() {
        return super.getYOffset() - 0.5;
    }

    public float getBlockPathWeight(BlockPos pos) {
        return 0.5f - this.world.getLightBrightness(pos);
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.floor((double)this.posX);
        BlockPos pos = new BlockPos(i, j = MathHelper.floor((double)this.getEntityBoundingBox().minY), k = MathHelper.floor((double)this.posZ));
        if (this.world.getLightFor(EnumSkyBlock.SKY, pos) > this.rand.nextInt(32)) {
            return false;
        }
        int l = this.world.getLight(pos);
        if (this.world.isThundering()) {
            int i2 = this.world.getSkylightSubtracted();
            this.world.setSkylightSubtracted(10);
            l = this.world.getLight(pos);
            this.world.setSkylightSubtracted(i2);
        }
        return l <= this.rand.nextInt(8);
    }

    public boolean getCanSpawnHere() {
        return this.world.getDifficulty() != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && super.getCanSpawnHere();
    }

    protected boolean canDropLoot() {
        return true;
    }
}

