/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityFlyingTameable;
import net.msrandom.witchery.entity.ai.EntityAIFlyerAttackOnCollide;
import net.msrandom.witchery.entity.ai.EntityAIFlyerFlyToWaypoint;
import net.msrandom.witchery.entity.ai.EntityAIFlyerFollowOwner;
import net.msrandom.witchery.entity.ai.EntityAIFlyerLand;
import net.msrandom.witchery.entity.ai.EntityAIFlyerMate;
import net.msrandom.witchery.entity.ai.EntityAIFlyerWander;
import net.msrandom.witchery.entity.ai.EntityAIFlyingTempt;
import net.msrandom.witchery.entity.ai.EntityAISitAndStay;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.util.Waypoint;

public class EntityWingedMonkey
extends EntityFlyingTameable {
    private static final DataParameter<Integer> TAME_SKIN = EntityDataManager.createKey(EntityWingedMonkey.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Integer> FEATHER_COLOR = EntityDataManager.createKey(EntityWingedMonkey.class, (DataSerializer)DataSerializers.VARINT);
    private static final Ingredient TEMPTATIONS = Ingredient.fromItems((Item[])new Item[]{Items.PORKCHOP, Items.BEEF});
    public final EntityAIFlyingTempt aiTempt;
    private int attackTimer;
    private int timeToLive = -1;

    public EntityWingedMonkey(World world) {
        super(world);
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISitAndStay(this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIFlyerFlyToWaypoint(this, EntityAIFlyerFlyToWaypoint.CarryRequirement.ENTITY_LIVING));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFlyerAttackOnCollide((EntityCreature)this, 1.0, true));
        this.aiTempt = new EntityAIFlyingTempt((EntityCreature)this, TEMPTATIONS, true);
        this.tasks.addTask(4, (EntityAIBase)this.aiTempt);
        this.tasks.addTask(5, new EntityAIFlyerFollowOwner<EntityWingedMonkey>(this, 14.0f, 5.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIFlyerMate((EntityAnimal)this, 0.8));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, true));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIFlyerWander((EntityLiving)this, 10.0));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 0.2f));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + 5;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setByte("FeatherColor", (byte)this.getFeatherColor());
        nbtRoot.setInteger("SuicideIn", this.timeToLive);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("FeatherColor")) {
            this.setFeatherColor(nbtRoot.getByte("FeatherColor"));
        }
        this.timeToLive = nbtRoot.hasKey("SuicideIn") ? nbtRoot.getInteger("SuicideIn") : -1;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(TAME_SKIN, (Object)0);
        this.dataManager.register(FEATHER_COLOR, (Object)(this.world.rand.nextInt(100) == 0 ? 0 : this.world.rand.nextInt(15) + 1));
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue((double)0.3f);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
    }

    protected boolean canDespawn() {
        return false;
    }

    public void updateAITasks() {
        this.getNavigator().clearPath();
        super.updateAITasks();
        if (this.world != null && !this.isDead && !this.world.isRemote && this.timeToLive != -1) {
            int timeToLive;
            this.timeToLive = timeToLive = this.timeToLive - 1;
            if (timeToLive == 0 || this.getAttackTarget() == null || this.getAttackTarget().isDead) {
                this.world.setEntityState((Entity)this, (byte)5);
                this.setDead();
            }
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
        } else if (par1 == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (par1 == 6) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.SPELL_INSTANT, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (!this.isTemp()) {
            int var3 = this.rand.nextInt(3) + this.rand.nextInt(1 + par2);
            for (int var4 = 0; var4 < var3; ++var4) {
                this.entityDropItem(new ItemStack(Items.FEATHER), 0.0f);
            }
        }
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_MONKEY_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_MONKEY_HURT;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_MONKEY_DEATH;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        this.world.setEntityState((Entity)this, (byte)4);
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), 2.0f);
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.isEntityInvulnerable(par1DamageSource)) {
            return false;
        }
        this.setSitting(false);
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    public double getMountedYOffset() {
        return !this.getPassengers().isEmpty() ? (double)(-((Entity)this.getPassengers().get((int)0)).height) * 0.6 : 0.0;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean processInteract(EntityPlayer player, EnumHand hand) {
        if (this.isTemp()) {
            return true;
        }
        ItemStack itemstack = player.getHeldItem(hand);
        if (this.isTamed()) {
            if (this.isOwner((EntityLivingBase)player) && !this.isBreedingItem(itemstack)) {
                if (!itemstack.isEmpty() && itemstack.getItem() == Items.DYE) {
                    if (!this.world.isRemote) {
                        int i = EnumDyeColor.byDyeDamage((int)itemstack.getItemDamage()).getMetadata();
                        this.setFeatherColor(i);
                        if (!player.capabilities.isCreativeMode) {
                            itemstack.shrink(1);
                        }
                    }
                } else {
                    if (!(itemstack.isEmpty() || itemstack.getItem() != Items.NAME_TAG && itemstack.getItem() != WitcheryGeneralItems.POLYNESIA_CHARM && itemstack.getItem() != WitcheryGeneralItems.DEVILS_TONGUE_CHARM)) {
                        return false;
                    }
                    if (itemstack.getItem() == WitcheryIngredientItems.PLAYER_BOUND_WAYSTONE || itemstack.getItem() == WitcheryIngredientItems.BOUND_WAYSTONE) {
                        this.waypoint = itemstack.copy();
                        this.homeX = 0.0;
                        this.homeY = 0.0;
                        this.homeZ = 0.0;
                        Waypoint wp = this.getWaypoint();
                        this.homeX = wp.X;
                        this.homeY = wp.Y;
                        this.homeZ = wp.Z;
                        WitcheryIngredientItem.bindToLocation(this.getPosition(), this.world.provider.getDimension(), this.waypoint);
                        if (!this.world.isRemote && this.isSitting()) {
                            this.setSitting(false);
                        }
                        player.startRiding((Entity)this);
                        this.playSound(SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                        this.world.setEntityState((Entity)this, (byte)6);
                    } else if (!itemstack.isEmpty() && ItemTaglockKit.isTaglockPresent(itemstack, 0)) {
                        this.waypoint = itemstack.copy();
                        this.homeX = this.posX;
                        this.homeY = this.posY;
                        this.homeZ = this.posZ;
                        this.playSound(SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                        this.world.setEntityState((Entity)this, (byte)6);
                        if (!player.capabilities.isCreativeMode) {
                            itemstack.shrink(1);
                        }
                    } else if (this.getDistanceSq((Entity)player) < 9.0 && !this.world.isRemote) {
                        this.setSitting(!this.isSitting());
                    }
                }
                return true;
            }
            if (this.isOwner((EntityLivingBase)player) && this.isBreedingItem(itemstack) && this.getHealth() < this.getMaxHealth()) {
                if (!this.world.isRemote) {
                    this.heal(10.0f);
                    if (!player.capabilities.isCreativeMode) {
                        itemstack.shrink(1);
                    }
                }
                return true;
            }
            return super.processInteract(player, hand);
        }
        if (!itemstack.isEmpty() && (itemstack.getItem() == Items.PORKCHOP || itemstack.getItem() == Items.BEEF) && player.getDistanceSq((Entity)this) < 9.0) {
            if (!player.capabilities.isCreativeMode) {
                itemstack.shrink(1);
            }
            if (!this.world.isRemote) {
                if (this.rand.nextInt(3) == 0) {
                    this.setTameSkin(1 + this.world.rand.nextInt(3));
                    this.setTamedBy(player);
                    this.enablePersistence();
                    this.playTameEffect(true);
                    this.setSitting(true);
                    this.world.setEntityState((Entity)this, (byte)7);
                } else {
                    this.playTameEffect(false);
                    this.world.setEntityState((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return !this.isBreedingItem(itemstack) && super.processInteract(player, hand);
    }

    public EntityWingedMonkey spawnBabyAnimal() {
        EntityWingedMonkey entityocelot = new EntityWingedMonkey(this.world);
        if (this.isTamed()) {
            entityocelot.enablePersistence();
            entityocelot.setTameSkin(this.getTameSkin());
            entityocelot.setFeatherColor(this.getFeatherColor());
        }
        return entityocelot;
    }

    public boolean isBreedingItem(ItemStack itemstack) {
        return !itemstack.isEmpty() && (itemstack.getItem() == Items.PORKCHOP || itemstack.getItem() == Items.BEEF);
    }

    public boolean canMateWith(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        if (!(par1EntityAnimal instanceof EntityWingedMonkey)) {
            return false;
        }
        EntityWingedMonkey entityocelot = (EntityWingedMonkey)par1EntityAnimal;
        return entityocelot.isTamed() && this.isInLove() && entityocelot.isInLove();
    }

    public int getFeatherColor() {
        return (Integer)this.dataManager.get(FEATHER_COLOR) & 0xF;
    }

    public void setFeatherColor(int par1) {
        this.dataManager.set(FEATHER_COLOR, (Object)((this.isTamed() ? 1 : 0) & 0xF0 | par1 & 0xF));
    }

    public int getTameSkin() {
        return (Integer)this.dataManager.get(TAME_SKIN);
    }

    public void setTameSkin(int par1) {
        this.dataManager.set(TAME_SKIN, (Object)par1);
    }

    public boolean getCanSpawnHere() {
        if (this.world.rand.nextInt(3) == 0) {
            return false;
        }
        if (this.world.checkNoEntityCollision(this.getEntityBoundingBox()) && this.world.getCollisionBoxes((Entity)this, this.getEntityBoundingBox()).isEmpty() && !this.world.containsAnyLiquid(this.getEntityBoundingBox())) {
            int i = MathHelper.floor((double)this.posX);
            int j = MathHelper.floor((double)this.getEntityBoundingBox().minY);
            int k = MathHelper.floor((double)this.posZ);
            if (j < 63) {
                return false;
            }
            BlockPos pos = new BlockPos(i, j - 1, k);
            IBlockState state = this.world.getBlockState(pos);
            if (state.getBlock() == Blocks.GRASS) {
                return true;
            }
            state.getBlock();
            return state.getBlock().isLeaves(state, (IBlockAccess)this.world, pos);
        }
        return false;
    }

    public EntityAgeable createChild(EntityAgeable par1EntityAgeable) {
        return this.spawnBabyAnimal();
    }

    public void setTimeToLive(int i) {
        this.timeToLive = i;
    }

    public boolean isTemp() {
        return this.timeToLive != -1;
    }
}

