/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.entity.EntityWereVillager;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityWerewolf
extends EntityMob {
    public EnumHand activeHand;
    boolean isSitting;
    private int attackTimer;
    @Nullable
    private NBTTagCompound villagerData;
    private boolean infectious;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation skinOverride;

    public EntityWerewolf(World world) {
        super(world);
        ((PathNavigateGround)this.getNavigator()).setBreakDoors(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.8, false));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, target -> !ShapeShift.INSTANCE.isAnimalForm((EntityPlayer)target)));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, false, false, null));
        this.targetTasks.addTask(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWitchHunter.class, true));
        this.experienceValue = 20;
    }

    public static void convertToVillager(EntityLiving target, NBTTagCompound data, boolean infectious) {
        if (target != null && !target.world.isRemote) {
            EntityWereVillager entity = new EntityWereVillager(target.world, data, infectious);
            entity.setLookingForHome();
            EntityWerewolf.setProperties((EntityLiving)entity, target);
        }
    }

    public static void convertToCuredVillager(EntityLiving target, NBTTagCompound data) {
        if (target != null && !target.world.isRemote) {
            EntityVillager entity = new EntityVillager(target.world);
            entity.readEntityFromNBT(data);
            entity.setLookingForHome();
            EntityWerewolf.setProperties((EntityLiving)entity, target);
        }
    }

    public static void setProperties(EntityLiving entity, EntityLiving original) {
        entity.copyLocationAndAnglesFrom((Entity)original);
        entity.enablePersistence();
        original.world.removeEntity((Entity)original);
        original.world.spawnEntity((Entity)entity);
        original.world.playEvent(1017, original.getPosition(), 0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.4);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(5.0);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(80.0);
    }

    public boolean isSitting() {
        return this.isSitting;
    }

    public void setSitting(boolean p_70904_1_) {
        this.isSitting = p_70904_1_;
    }

    public int getTotalArmorValue() {
        int i = super.getTotalArmorValue() + 10;
        if (i > 20) {
            i = 20;
        }
        return i;
    }

    public void onLivingUpdate() {
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.world.isRemote) {
            if (this.villagerData != null && this.ticksExisted % 100 == 3 && !CreatureUtil.isFullMoon(this.world) && !this.isPotionActive(WitcheryPotionEffects.WOLFSBANE)) {
                EntityWerewolf.convertToVillager((EntityLiving)this, this.villagerData, this.infectious);
            } else if (this.ticksExisted % 40 == 4 && this.isPotionActive(MobEffects.POISON)) {
                this.removePotionEffect(MobEffects.POISON);
            }
        }
        super.onLivingUpdate();
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, source, damage)) {
            return super.attackEntityFrom(source, damage);
        }
        if (CreatureUtil.isSilverDamage(source)) {
            return super.attackEntityFrom(source, Math.min(damage * 1.5f, 15.0f));
        }
        return super.attackEntityFrom(source, Math.min(damage, 1.0f));
    }

    public boolean attackEntityAsMob(Entity targetEntity) {
        this.attackTimer = 10;
        this.world.setEntityState((Entity)this, (byte)4);
        return super.attackEntityAsMob(targetEntity);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
        } else {
            super.handleStatusUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 4;
    }

    protected SoundEvent getAmbientSound() {
        return this.world.rand.nextInt(20) == 0 ? WitcherySounds.ENTITY_WEREWOLF_HOWL : WitcherySounds.ENTITY_WEREWOLF_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_WEREWOLF_HURT;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_WEREWOLF_DEATH;
    }

    protected void dropFewItems(boolean p_70628_1_, int fortune) {
        super.dropFewItems(p_70628_1_, fortune);
    }

    protected Item getDropItem() {
        return Items.BONE;
    }

    public NBTTagCompound getVillagerData() {
        return this.villagerData;
    }

    public void setVillagerData(NBTTagCompound data) {
        this.villagerData = data;
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        if (this.villagerData != null) {
            nbtRoot.setTag("VillagerData", (NBTBase)this.villagerData);
        }
        nbtRoot.setBoolean("Infectious", this.infectious);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("VillagerData")) {
            this.villagerData = nbtRoot.getCompoundTag("VillagerData");
        }
        this.infectious = nbtRoot.getBoolean("Infectious");
    }

    public void setInfectious() {
        this.infectious = true;
    }

    public boolean isInfectious() {
        return this.infectious;
    }

    public void onKillEntity(EntityLivingBase targetEntity) {
        super.onKillEntity(targetEntity);
    }

    protected boolean canDespawn() {
        return false;
    }

    public void setActiveHand(EnumHand hand) {
        this.activeHand = hand;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSkinResource() {
        return this.skinOverride;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSkinResource(ResourceLocation skinOverride) {
        this.skinOverride = skinOverride;
    }
}

