/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWerewolf;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.util.CreatureUtil;

public class EntityWereVillager
extends EntityVillager {
    private NBTTagCompound oldData;
    private boolean infectious;

    public EntityWereVillager(World world) {
        this(world, new NBTTagCompound(), false);
    }

    public EntityWereVillager(World world, NBTTagCompound data, boolean infectious) {
        super(world);
        if (!world.isRemote) {
            super.readEntityFromNBT(data);
            this.oldData = data;
        }
        this.infectious = infectious;
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        if (!this.world.isRemote) {
            nbtRoot.setTag("VillagerData", (NBTBase)this.getVillagerData());
        }
        nbtRoot.setBoolean("Infectious", this.infectious);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (!this.world.isRemote && nbtRoot.hasKey("VillagerData")) {
            this.oldData = nbtRoot.getCompoundTag("VillagerData");
            super.readEntityFromNBT(this.oldData);
        }
        this.infectious = nbtRoot.getBoolean("Infectious");
    }

    public NBTTagCompound getVillagerData() {
        super.writeEntityToNBT(this.oldData);
        return this.oldData;
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (!this.world.isRemote && this.ticksExisted % 100 == 3 && !this.isChild() && CreatureUtil.isFullMoon(this.world) && !this.isPotionActive(WitcheryPotionEffects.WOLFSBANE)) {
            this.convertToWolfman();
        }
    }

    protected void convertToWolfman() {
        EntityWerewolf entity = new EntityWerewolf(this.world);
        if (this.infectious) {
            entity.setInfectious();
        }
        entity.setVillagerData(this.getVillagerData());
        entity.onInitialSpawn(this.world.getDifficultyForLocation(entity.getPosition()), null);
        EntityWerewolf.setProperties((EntityLiving)entity, (EntityLiving)this);
        this.playSound(SoundEvents.ENTITY_PLAYER_SPLASH, 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
    }
}

