/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.entity.ai.EntityAIDefendVillageGeneric;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityVillageGuard
extends EntityCreature
implements IRangedAttackMob,
EntityAIDefendVillageGeneric.IVillageGuard {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.createKey(EntityVillageGuard.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static final DataParameter<Integer> BLOOD = EntityDataManager.createKey(EntityVillageGuard.class, (DataSerializer)DataSerializers.VARINT);
    private final EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged(this, 1.0, 20, 15.0f){

        public void startExecuting() {
            super.startExecuting();
            EntityVillageGuard.this.setSwingingArms(true);
        }

        public void resetTask() {
            super.resetTask();
            EntityVillageGuard.this.setSwingingArms(false);
        }
    };
    private final EntityAINearestAttackableTarget<EntityPlayer> aiAttackOnCollide = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false);
    Village village;
    private int homeCheckTimer;

    public EntityVillageGuard(World world) {
        super(world);
        ((PathNavigateGround)this.getNavigator()).setBreakDoors(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIDefendVillageGeneric(this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, entity -> {
            if (entity instanceof IMob && !(entity instanceof EntityWitchHunter) || entity instanceof EntityGoblin) {
                return true;
            }
            if (this.village != null && entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                EntityLivingBase target = player.getRevengeTarget();
                return target instanceof EntityPlayer && this.village.getPlayerReputation(target.getUniqueID()) == 10;
            }
            return false;
        }));
        if (!world.isRemote) {
            this.setCombatTask();
        }
        this.experienceValue = 5;
    }

    public static void createFrom(EntityVillager villager) {
        World world = villager.world;
        EntityVillageGuard entity = new EntityVillageGuard(world);
        entity.enablePersistence();
        entity.copyLocationAndAnglesFrom((Entity)villager);
        entity.onInitialSpawn(world.getDifficultyForLocation(entity.getPosition()), null);
        world.removeEntity((Entity)villager);
        world.spawnEntity((Entity)entity);
        world.setEntityState((Entity)entity, (byte)5);
    }

    public void handleStatusUpdate(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.SPELL_INSTANT, this.posX + this.rand.nextDouble() * 1.2 - 0.6, this.posY + this.rand.nextDouble() * 1.8, this.posZ + this.rand.nextDouble() * 1.2 - 0.6, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    public boolean canAttackClass(Class p_70686_1_) {
        return EntityCreeper.class != p_70686_1_ && this.getClass() != p_70686_1_;
    }

    public int getBlood() {
        return (Integer)this.dataManager.get(BLOOD);
    }

    public void setBlood(int blood) {
        this.dataManager.set(BLOOD, (Object)MathHelper.clamp((int)blood, (int)0, (int)500));
    }

    public int takeBlood(int quantity, EntityLivingBase player) {
        PotionEffect effect = this.getActivePotionEffect(WitcheryPotionEffects.PARALYSED);
        boolean transfixed = effect != null && effect.getAmplifier() >= 4;
        int blood = this.getBlood();
        quantity = (int)Math.ceil(0.66f * (float)quantity);
        int remainder = Math.max(blood - quantity, 0);
        int taken = blood - remainder;
        this.setBlood(remainder);
        if (blood < (int)Math.ceil(250.0)) {
            this.attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.MAGIC.getDamageType(), (Entity)player), 2.0f);
        } else if (!transfixed) {
            this.attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.MAGIC.getDamageType(), (Entity)player), 0.5f);
        }
        return taken;
    }

    public void giveBlood(int quantity) {
        int blood = this.getBlood();
        if (blood < 500) {
            this.setBlood(blood + quantity);
        }
    }

    @Override
    public Village getVillage() {
        return this.village;
    }

    @Override
    public EntityCreature getCreature() {
        return this;
    }

    protected void updateAITasks() {
        int homeCheckTimer;
        this.homeCheckTimer = homeCheckTimer = this.homeCheckTimer - 1;
        if (homeCheckTimer <= 0) {
            this.homeCheckTimer = 70 + this.rand.nextInt(50);
            this.village = this.world.villageCollection.getNearestVillage(this.getPosition(), 32);
            if (this.village == null) {
                this.detachHome();
            } else {
                BlockPos chunkcoordinates = this.village.getCenter();
                this.setHomePosAndDistance(chunkcoordinates, (int)((float)this.village.getVillageRadius() * 1.5f));
                if (this.getAttackTarget() == null) {
                    this.heal(1.0f);
                    if (this.world.rand.nextInt(4) == 0) {
                        this.giveBlood(1);
                    }
                }
            }
        }
        super.updateAITasks();
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.ENTITY_HOSTILE_SWIM;
    }

    protected SoundEvent getSplashSound() {
        return SoundEvents.ENTITY_HOSTILE_SPLASH;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.3);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(SWINGING_ARMS, (Object)false);
        this.dataManager.register(BLOOD, (Object)500);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_VILLAGER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_VILLAGER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_VILLAGER_DEATH;
    }

    protected float getSoundPitch() {
        return 0.8f;
    }

    public void onLivingUpdate() {
        this.updateArmSwingProgress();
        float f = this.getBrightness();
        if (f > 0.5f) {
            this.idleTime += 2;
        }
        super.onLivingUpdate();
    }

    public boolean attackEntityFrom(DamageSource damageSource, float damage) {
        return (WitcheryUtils.isInstantKill((EntityLivingBase)this, damageSource, damage) || damageSource.getTrueSource() == null || !(damageSource.getTrueSource() instanceof EntityVillageGuard) && !(damageSource.getTrueSource() instanceof EntityWitchHunter)) && super.attackEntityFrom(damageSource, damage);
    }

    public boolean attackEntityAsMob(Entity p_70652_1_) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue();
        int i = 0;
        if (p_70652_1_ instanceof EntityLivingBase) {
            f += EnchantmentHelper.getModifierForCreature((ItemStack)this.getHeldItemMainhand(), (EnumCreatureAttribute)((EntityLivingBase)p_70652_1_).getCreatureAttribute());
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this);
        }
        if (flag = p_70652_1_.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                p_70652_1_.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                p_70652_1_.setFire(j * 4);
            }
            if (p_70652_1_ instanceof EntityLivingBase) {
                EnchantmentHelper.applyThornEnchantments((EntityLivingBase)((EntityLivingBase)p_70652_1_), (Entity)this);
            }
            EnchantmentHelper.applyArthropodEnchantments((EntityLivingBase)this, (Entity)p_70652_1_);
        }
        return flag;
    }

    protected void playStepSound(BlockPos pos, Block block) {
    }

    public void updateRidden() {
        super.updateRidden();
        if (this.getRidingEntity() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.getRidingEntity();
            this.renderYawOffset = entitycreature.renderYawOffset;
        }
    }

    protected SoundEvent getFallSound(int p_146067_1_) {
        return p_146067_1_ > 4 ? SoundEvents.ENTITY_HOSTILE_BIG_FALL : SoundEvents.ENTITY_HOSTILE_SMALL_FALL;
    }

    public void onDeath(DamageSource p_70645_1_) {
        if (this.attackingPlayer != null && this.village != null) {
            this.village.modifyPlayerReputation(this.attackingPlayer.getUniqueID(), -5);
        }
        super.onDeath(p_70645_1_);
    }

    protected Item getDropItem() {
        return Items.ARROW;
    }

    protected void addRandomArmor() {
        this.setHeldItem(EnumHand.MAIN_HAND, new ItemStack((Item)Items.BOW));
        this.setItemStackToSlot(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.LEATHER_BOOTS));
        this.setItemStackToSlot(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.LEATHER_LEGGINGS));
        this.setItemStackToSlot(EntityEquipmentSlot.CHEST, new ItemStack((Item)(this.rand.nextInt(5) == 0 ? Items.IRON_CHESTPLATE : Items.LEATHER_CHESTPLATE)));
        this.setItemStackToSlot(EntityEquipmentSlot.HEAD, new ItemStack((Item)(this.rand.nextInt(5) == 0 ? Items.IRON_HELMET : Items.LEATHER_HELMET)));
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.onInitialSpawn(difficulty, p_110161_1_);
        this.addRandomArmor();
        return p_110161_1_;
    }

    public void setCombatTask() {
        this.tasks.removeTask(this.aiAttackOnCollide);
        this.tasks.removeTask((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.getHeldItemMainhand();
        if (!itemstack.isEmpty() && itemstack.getItem() == Items.BOW) {
            this.tasks.addTask(4, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.tasks.addTask(4, this.aiAttackOnCollide);
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float p_82196_2_) {
        PotionEffect effect = this.getActivePotionEffect(WitcheryPotionEffects.PARALYSED);
        if (effect != null && effect.getAmplifier() >= 4) {
            return;
        }
        EntityArrow entityarrow = ((ItemArrow)Items.ARROW).createArrow(this.world, new ItemStack(Items.ARROW), (EntityLivingBase)this);
        double d0 = target.posX - this.posX;
        double d1 = target.getEntityBoundingBox().minY + (double)(target.height / 3.0f) - entityarrow.posY;
        double d2 = target.posZ - this.posZ;
        double d3 = MathHelper.sqrt((double)(d0 * d0 + d2 * d2));
        int difficulty = target instanceof EntityPlayer ? this.world.getDifficulty().getId() : 4 - this.world.getDifficulty().getId();
        entityarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(16 - difficulty * 4));
        int i = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.POWER, (ItemStack)this.getHeldItemMainhand());
        int j = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.PUNCH, (ItemStack)this.getHeldItemMainhand());
        entityarrow.setDamage((double)(p_82196_2_ * 2.0f) + this.rand.nextGaussian() * 0.25 + (double)((float)difficulty * 0.11f));
        if (i > 0) {
            entityarrow.setDamage(entityarrow.getDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.setKnockbackStrength(j);
        }
        if (EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.FLAME, (ItemStack)this.getHeldItemMainhand()) > 0) {
            entityarrow.setFire(100);
        }
        this.playSound(SoundEvents.ENTITY_ARROW_SHOOT, 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
        this.world.spawnEntity((Entity)entityarrow);
    }

    public void setSwingingArms(boolean b) {
        this.dataManager.set(SWINGING_ARMS, (Object)b);
    }

    public boolean isSwingingArms() {
        return (Boolean)this.dataManager.get(SWINGING_ARMS);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.setCombatTask();
        if (nbtRoot.hasKey("BloodLevel")) {
            this.setBlood(nbtRoot.getInteger("BloodLevel"));
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setInteger("BloodLevel", this.getBlood());
    }

    public void setItemStackToSlot(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.setItemStackToSlot(slotIn, stack);
        if (!this.world.isRemote && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public double getYOffset() {
        return super.getYOffset() - 0.5;
    }
}

