/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityBloodCrucible;
import net.msrandom.witchery.extensions.VillagerExtendedData;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.IHandleDeathTouch;

public class EntityVampire
extends EntityCreature
implements IHandleDeathTouch {
    private static final DataParameter<Integer> TYPE = EntityDataManager.createKey(EntityVampire.class, (DataSerializer)DataSerializers.VARINT);
    float damageDone = 0.0f;
    private Village village;
    private BlockPos coffinPos = BlockPos.ORIGIN;

    public EntityVampire(World world) {
        super(world);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.getNavigator()).setBreakDoors(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(8, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, false));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCreature.class, 0, false, true, entity -> entity instanceof EntityVillager && this.village != null));
        this.experienceValue = 20;
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (!this.world.isRemote) {
            if (this.world.isDaytime()) {
                if (this.getRevengeTarget() == null) {
                    this.setAttackTarget(null);
                }
                if (this.ticksExisted % 100 == 2) {
                    this.village = null;
                    this.damageDone = 0.0f;
                    if (this.getDistanceSq(this.coffinPos) > 16.0) {
                        this.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
                        this.world.setEntityState((Entity)this, (byte)5);
                        EntityUtil.moveToBlockPositionAndUpdate((EntityLiving)this, this.coffinPos, 8);
                        this.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
                        this.world.setEntityState((Entity)this, (byte)5);
                        this.setHomePosAndDistance(this.coffinPos, 4);
                    }
                }
                if (this.ticksExisted % 20 == 2 && CreatureUtil.isInSunlight((EntityLivingBase)this)) {
                    this.setFire(2);
                }
            } else if (this.damageDone >= 20.0f) {
                if (this.village != null) {
                    this.setAttackTarget(null);
                    this.setRevengeTarget(null);
                    this.village = null;
                    this.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)5);
                    EntityUtil.moveToBlockPositionAndUpdate((EntityLiving)this, this.coffinPos, 8);
                    this.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)5);
                    this.setHomePosAndDistance(this.coffinPos, 4);
                    this.tryFillBloodCrucible();
                }
            } else if (this.village == null && this.ticksExisted % 500 == 2) {
                this.village = this.world.villageCollection.getNearestVillage(this.getPosition(), 128);
                if (this.village != null) {
                    BlockPos townPos = this.village.getCenter();
                    this.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)5);
                    EntityUtil.moveToBlockPositionAndUpdate((EntityLiving)this, townPos, 8);
                    this.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)5);
                    this.setHomePosAndDistance(townPos, this.village.getVillageRadius());
                }
            }
        }
    }

    public void handleStatusUpdate(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, this.posX + this.rand.nextDouble() * 1.6 - 0.8, this.posY + this.rand.nextDouble() * 1.5, this.posZ + this.rand.nextDouble() * 1.6 - 0.8, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    public void tryFillBloodCrucible() {
        int r = 6;
        for (int x = this.coffinPos.getX() - r; x <= this.coffinPos.getX() + r; ++x) {
            for (int z = this.coffinPos.getZ() - r; z <= this.coffinPos.getZ() + r; ++z) {
                for (int y = this.coffinPos.getY() - r; y <= this.coffinPos.getY() + r; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.world.getBlockState(pos).getBlock() != WitcheryBlocks.BLOOD_CRUCIBLE) continue;
                    TileEntityBloodCrucible crucible = WitcheryTileEntities.BLOOD_CRUCIBLE.getAt((IBlockAccess)this.world, pos);
                    if (crucible != null) {
                        crucible.increaseBloodLevel();
                    }
                    return;
                }
            }
        }
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void setStalkingArea(int p_110171_1_, int p_110171_2_, int p_110171_3_) {
        this.coffinPos = new BlockPos(p_110171_1_, p_110171_2_, p_110171_3_);
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.ENTITY_HOSTILE_SWIM;
    }

    protected SoundEvent getSplashSound() {
        return SoundEvents.ENTITY_HOSTILE_SPLASH;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.4);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(5.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(TYPE, (Object)0);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_VILLAGER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_VILLAGER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_VILLAGER_DEATH;
    }

    protected float getSoundPitch() {
        return 0.6f;
    }

    public void onLivingUpdate() {
        this.updateArmSwingProgress();
        float f = this.getBrightness();
        if (f > 0.5f) {
            this.idleTime += 2;
        }
        super.onLivingUpdate();
    }

    public boolean attackEntityAsMob(Entity entity) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue();
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getModifierForCreature((ItemStack)this.getHeldItemMainhand(), (EnumCreatureAttribute)((EntityLivingBase)entity).getCreatureAttribute());
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this);
        }
        if (entity instanceof EntityVillager) {
            VillagerExtendedData villagerEx = WitcheryDataExtensions.VILLAGER.get((EntityVillager)entity);
            if (this.rand.nextInt(10) == 0) {
                this.damageDone += 4.0f;
                int taken = villagerEx.takeBlood(30, (EntityLivingBase)this);
                if (taken > 0) {
                    this.heal(4.0f);
                    this.world.playSound(null, entity.posX, entity.posY + (double)entity.height * 0.8, entity.posZ, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, this.getSoundCategory(), 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY + (double)entity.height * 0.8, entity.posZ, 0.5f, 0.2f, EnumParticleTypes.REDSTONE), entity);
                }
            }
            flag = true;
        } else {
            boolean needsBlood = this.damageDone < 20.0f;
            flag = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f);
            if (flag) {
                int j;
                if (i > 0) {
                    entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                    this.motionX *= 0.6;
                    this.motionZ *= 0.6;
                }
                if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                    entity.setFire(j * 4);
                }
                if (entity instanceof EntityLivingBase) {
                    EnchantmentHelper.applyThornEnchantments((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
                }
                EnchantmentHelper.applyArthropodEnchantments((EntityLivingBase)this, (Entity)entity);
            }
        }
        return flag;
    }

    protected void playStepSound(BlockPos pos, Block block) {
    }

    public void updateRidden() {
        super.updateRidden();
        if (this.getRidingEntity() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.getRidingEntity();
            this.renderYawOffset = entitycreature.renderYawOffset;
        }
    }

    protected SoundEvent getFallSound(int p_146067_1_) {
        return p_146067_1_ > 4 ? SoundEvents.ENTITY_HOSTILE_BIG_FALL : SoundEvents.ENTITY_HOSTILE_SMALL_FALL;
    }

    @Override
    public float getCapDT(DamageSource source) {
        return 0.0f;
    }

    public void onDeath(DamageSource source) {
        if (CreatureUtil.checkForVampireDeath((EntityLivingBase)this, source)) {
            return;
        }
        super.onDeath(source);
    }

    protected Item getDropItem() {
        return Items.SHEARS;
    }

    protected boolean canDespawn() {
        return false;
    }

    protected void addRandomArmor() {
        boolean male = this.rand.nextBoolean();
        if (male) {
            this.setItemStackToSlot(EntityEquipmentSlot.FEET, new ItemStack((Item)(this.rand.nextInt(4) == 0 ? WitcheryEquipmentItems.VAMPIRE_HEELS : WitcheryEquipmentItems.VAMPIRE_SHOES)));
            this.setItemStackToSlot(EntityEquipmentSlot.LEGS, new ItemStack((Item)(this.rand.nextInt(3) == 0 ? WitcheryEquipmentItems.VAMPIRE_SKIRT : WitcheryEquipmentItems.VAMPIRE_TROUSERS)));
            this.setItemStackToSlot(EntityEquipmentSlot.CHEST, new ItemStack((Item)(this.rand.nextInt(3) == 0 ? WitcheryEquipmentItems.VAMPIRE_CHESTPLATE : WitcheryEquipmentItems.VAMPIRE_WAIST_COAT)));
        } else {
            this.setItemStackToSlot(EntityEquipmentSlot.FEET, new ItemStack((Item)(this.rand.nextInt(3) == 0 ? WitcheryEquipmentItems.VAMPIRE_SHOES : WitcheryEquipmentItems.VAMPIRE_HEELS)));
            this.setItemStackToSlot(EntityEquipmentSlot.LEGS, new ItemStack((Item)(this.rand.nextInt(4) == 0 ? WitcheryEquipmentItems.VAMPIRE_TROUSERS : WitcheryEquipmentItems.VAMPIRE_SKIRT)));
            this.setItemStackToSlot(EntityEquipmentSlot.CHEST, new ItemStack((Item)(this.rand.nextInt(3) == 0 ? WitcheryEquipmentItems.VAMPIRE_CHESTPLATE : WitcheryEquipmentItems.VAMPIRE_CORSET)));
        }
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.onInitialSpawn(difficulty, p_110161_1_);
        this.addRandomArmor();
        this.coffinPos = this.getPosition();
        return p_110161_1_;
    }

    public int getGuardType() {
        return (Integer)this.dataManager.get(TYPE);
    }

    public void setGuardType(int p_82201_1_) {
        this.dataManager.set(TYPE, (Object)p_82201_1_);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("GuardType", 99)) {
            byte b0 = nbtRoot.getByte("GuardType");
            this.setGuardType(b0);
        }
        this.coffinPos = new BlockPos(nbtRoot.getInteger("BaseX"), nbtRoot.getInteger("BaseY"), nbtRoot.getInteger("BaseZ"));
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setByte("GuardType", (byte)this.getGuardType());
        BlockPos home = this.getHomePosition();
        nbtRoot.setInteger("BaseX", this.coffinPos.getX());
        nbtRoot.setInteger("BaseY", this.coffinPos.getY());
        nbtRoot.setInteger("BaseZ", this.coffinPos.getZ());
    }

    public double getYOffset() {
        return super.getYOffset() - 0.5;
    }
}

