/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.msrandom.witchery.entity.EntityEnt;
import net.msrandom.witchery.entity.EntityFlyingTameable;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntitySleepingBody;
import net.msrandom.witchery.entity.ai.EntityAITreefydWander;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class EntityTreefyd
extends EntityMob
implements IEntityOwnable {
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.createKey(EntityTreefyd.class, (DataSerializer)DataSerializers.OPTIONAL_UNIQUE_ID);
    private static final DataParameter<Boolean> SENTINAL = EntityDataManager.createKey(EntityTreefyd.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static Set<Class<? extends Entity>> groupables;
    private final Set<UUID> knownPlayers = new LinkedHashSet<UUID>();
    private final Set<Class<? extends Entity>> knownCreatureTypes = new LinkedHashSet<Class<? extends Entity>>();
    private final Set<UUID> knownCreatures = new LinkedHashSet<UUID>();

    public EntityTreefyd(World par1World) {
        super(par1World);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.tasks.addTask(5, (EntityAIBase)new EntityAITreefydWander(this, 0.8));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, entity -> {
            if (entity.getClass() == ((Object)((Object)this)).getClass() || entity instanceof EntityHornedHuntsman || entity instanceof EntityEnt || entity instanceof EntityFlying || entity instanceof EntityFlyingTameable || entity instanceof EntityAmbientCreature || entity instanceof EntityWaterMob || this.isFamiliar((Entity)entity) || entity instanceof EntityCovenWitch || entity instanceof EntitySleepingBody) {
                return false;
            }
            if (entity instanceof EntityPlayer && (entity.getUniqueID().equals(this.getOwnerId()) || this.knownPlayers.contains(entity.getUniqueID()))) {
                return false;
            }
            if (this.knownCreatures.contains(entity.getUniqueID())) {
                return false;
            }
            if (entity instanceof EntityLiving) {
                EntityLiving creature = (EntityLiving)entity;
                return !this.knownCreatureTypes.contains(creature.getClass());
            }
            return true;
        }));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean processInteract(EntityPlayer player, EnumHand hand) {
        block31: {
            block33: {
                ItemStack stack;
                block32: {
                    if (this.world.isRemote || hand != EnumHand.MAIN_HAND || !player.getUniqueID().equals(this.getOwnerId())) break block31;
                    stack = player.getHeldItem(hand);
                    if (stack.getItem() != WitcheryGeneralItems.BOUND_TAGLOCK_KIT) break block32;
                    this.setAttackTarget(null);
                    Class<? extends Entity> boundEntityType = ItemTaglockKit.getBoundEntityType(stack, 0);
                    UUID id = ItemTaglockKit.getBoundCreatureID(stack, 0);
                    if (boundEntityType == EntityPlayer.class) {
                        if (!player.getUniqueID().equals(id)) {
                            if (!player.isSneaking() && !this.knownPlayers.contains(id)) {
                                this.knownPlayers.add(id);
                            } else {
                                if (!player.isSneaking() || !this.knownPlayers.contains(id)) {
                                    this.showCurrentKnownEntities(player);
                                    return super.processInteract(player, hand);
                                }
                                this.knownPlayers.remove(id);
                            }
                            if (!player.capabilities.isCreativeMode) {
                                stack.shrink(1);
                            }
                            this.showCurrentKnownEntities(player);
                            return true;
                        }
                        break block33;
                    } else {
                        if (!id.equals(this.getUniqueID())) {
                            if (this.isGroupableCreature(boundEntityType)) {
                                if (!player.isSneaking() && !this.knownCreatureTypes.contains(boundEntityType)) {
                                    this.knownCreatureTypes.add(boundEntityType);
                                } else {
                                    if (!player.isSneaking() || !this.knownCreatureTypes.contains(boundEntityType)) {
                                        this.showCurrentKnownEntities(player);
                                        return super.processInteract(player, hand);
                                    }
                                    this.knownCreatureTypes.remove(boundEntityType);
                                }
                            } else if (!player.isSneaking() && !this.knownCreatures.contains(id)) {
                                this.knownCreatures.add(id);
                            } else {
                                if (!player.isSneaking() || !this.knownCreatures.contains(id)) {
                                    this.showCurrentKnownEntities(player);
                                    return super.processInteract(player, hand);
                                }
                                this.knownCreatures.remove(id);
                            }
                            if (!player.capabilities.isCreativeMode) {
                                stack.shrink(1);
                            }
                        }
                        this.showCurrentKnownEntities(player);
                        return true;
                    }
                }
                if (stack.getItem() == WitcheryIngredientItems.TREEFYD_SEEDS) {
                    if (!this.world.isRemote) {
                        EntityTreefyd entity = new EntityTreefyd(this.world);
                        entity.setLocationAndAngles(0.5 + this.posX, this.posY, 0.5 + this.posZ, 0.0f, 0.0f);
                        entity.onInitialSpawn(this.world.getDifficultyForLocation(entity.getPosition()), null);
                        entity.setOwnerId(player.getUniqueID());
                        entity.enablePersistence();
                        entity.knownPlayers.addAll(this.knownPlayers);
                        entity.knownCreatureTypes.addAll(this.knownCreatureTypes);
                        entity.knownCreatures.addAll(this.knownCreatures);
                        this.world.spawnEntity((Entity)entity);
                        this.playSound(SoundEvents.ENTITY_SILVERFISH_DEATH, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                        this.world.setEntityState((Entity)this, (byte)4);
                    }
                    if (!player.capabilities.isCreativeMode) {
                        stack.shrink(1);
                    }
                } else if (stack.getItem() == WitcheryIngredientItems.CREEPER_HEART) {
                    if (!this.world.isRemote) {
                        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(100.0);
                        this.setHealth(this.getMaxHealth());
                        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
                        this.playSound(SoundEvents.ENTITY_SILVERFISH_DEATH, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                        this.world.setEntityState((Entity)this, (byte)5);
                    }
                    if (!player.capabilities.isCreativeMode) {
                        stack.shrink(1);
                    }
                } else if (stack.getItem() == Item.getItemFromBlock((Block)WitcheryBlocks.DEMON_HEART)) {
                    if (!this.world.isRemote) {
                        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(150.0);
                        this.setHealth(this.getMaxHealth());
                        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(5.0);
                        this.playSound(SoundEvents.ENTITY_ENDERDRAGON_GROWL, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                        this.world.setEntityState((Entity)this, (byte)6);
                    }
                    if (!player.capabilities.isCreativeMode) {
                        stack.shrink(1);
                    }
                } else if (stack.getItem() == WitcheryGeneralItems.BOLINE && !this.world.isRemote) {
                    this.setSentinal(!this.isSentinal());
                }
            }
            this.showCurrentKnownEntities(player);
        }
        return super.processInteract(player, hand);
    }

    public void handleStatusUpdate(byte id) {
        switch (id) {
            case 4: {
                for (int i = 0; i < 20; ++i) {
                    this.world.spawnParticle(EnumParticleTypes.SLIME, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                    this.world.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < 20; ++i) {
                    this.world.spawnParticle(EnumParticleTypes.SLIME, this.posX + this.rand.nextDouble() - 0.5, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < 20; ++i) {
                    this.world.spawnParticle(EnumParticleTypes.FLAME, this.posX + this.rand.nextDouble() - 0.5, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            default: {
                super.handleStatusUpdate(id);
            }
        }
    }

    private void showCurrentKnownEntities(EntityPlayer player) {
        ITextComponent text2 = this.getDisplayName().appendText(" (");
        WorldServer serverWorld = (WorldServer)this.world;
        PlayerProfileCache playerCache = serverWorld.getMinecraftServer().getPlayerProfileCache();
        UUID ownerId = this.getOwnerId();
        int names = 0;
        if (ownerId != null) {
            Entity owner = this.getOwner();
            if (owner != null) {
                text2.appendSibling(owner.getDisplayName());
                ++names;
            } else {
                GameProfile gameProfile = playerCache.getProfileByUUID(ownerId);
                if (gameProfile != null) {
                    text2.appendText(gameProfile.getName());
                    ++names;
                }
            }
        }
        for (UUID uUID : this.knownPlayers) {
            String name2;
            ITextComponent displayName;
            Entity otherPlayer = serverWorld.getEntityFromUuid(uUID);
            if (otherPlayer == null) {
                GameProfile profile = playerCache.getProfileByUUID(uUID);
                String name3 = profile == null ? null : profile.getName();
                displayName = null;
            } else {
                name2 = null;
                displayName = otherPlayer.getDisplayName();
            }
            if (displayName == null && name2 == null) continue;
            if (names > 0) {
                text2.appendText(", ");
            }
            if (displayName == null) {
                text2.appendText(name2);
            } else {
                text2.appendSibling(displayName);
            }
            ++names;
        }
        for (Class clazz : this.knownCreatureTypes) {
            EntityEntry entry2 = EntityRegistry.getEntry((Class)clazz);
            if (entry2 == null) continue;
            if (names > 0) {
                text2.appendText(", ");
            }
            text2.appendText("#");
            text2.appendSibling((ITextComponent)new TextComponentTranslation("entity." + entry2.getName() + ".name", new Object[0]));
            ++names;
        }
        for (UUID uUID : this.knownCreatures) {
            Entity entity = serverWorld.getEntityFromUuid(uUID);
            if (entity == null) continue;
            if (names > 0) {
                text2.appendText(", ");
            }
            text2.appendSibling(entity.getDisplayName());
            ++names;
        }
        text2.appendText(")");
        player.sendMessage(text2);
    }

    private boolean isFamiliar(Entity entity) {
        if (Familiars.canBeFamiliar(entity)) {
            return Familiars.getFamiliarInstance(entity).isFamiliar();
        }
        return false;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(3.0);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(50.0);
    }

    public boolean attackEntityAsMob(Entity entity) {
        EntityPlayer player;
        if (!this.world.isRemote && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).isPotionActive(MobEffects.BLINDNESS)) {
            player.addPotionEffect(new PotionEffect(MobEffects.BLINDNESS, 100, 0));
        }
        return super.attackEntityAsMob(entity);
    }

    public int getMaxFallHeight() {
        return this.getAttackTarget() == null ? 3 : 3 + (int)(this.getHealth() - 1.0f);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(OWNER, (Object)Optional.absent());
        this.dataManager.register(SENTINAL, (Object)false);
    }

    public boolean isSentinal() {
        return (Boolean)this.dataManager.get(SENTINAL);
    }

    protected void setSentinal(boolean screaming) {
        this.dataManager.set(SENTINAL, (Object)screaming);
    }

    public void writeEntityToNBT(NBTTagCompound tag) {
        super.writeEntityToNBT(tag);
        UUID ownerId = this.getOwnerId();
        if (ownerId != null) {
            tag.setUniqueId("Owner", ownerId);
        }
        if (!this.knownPlayers.isEmpty()) {
            NBTTagList players = new NBTTagList();
            for (UUID uUID : this.knownPlayers) {
                players.appendTag((NBTBase)new NBTTagString(uUID.toString()));
            }
            tag.setTag("KnownPlayers", (NBTBase)players);
        }
        if (!this.knownCreatureTypes.isEmpty()) {
            NBTTagList creatureTypes = new NBTTagList();
            for (Class clazz : this.knownCreatureTypes) {
                creatureTypes.appendTag((NBTBase)new NBTTagString(EntityList.getKey((Class)clazz).toString()));
            }
            tag.setTag("KnownCreatureTypes", (NBTBase)creatureTypes);
        }
        if (!this.knownCreatures.isEmpty()) {
            NBTTagList creatures = new NBTTagList();
            for (UUID uUID : this.knownCreatures) {
                creatures.appendTag((NBTBase)new NBTTagString(uUID.toString()));
            }
            tag.setTag("KnownCreatures", (NBTBase)creatures);
        }
        tag.setBoolean("Sentinal", this.isSentinal());
    }

    public void readEntityFromNBT(NBTTagCompound tag) {
        int i;
        super.readEntityFromNBT(tag);
        if (tag.hasUniqueId("Owner")) {
            this.setOwnerId(tag.getUniqueId("Owner"));
        }
        if (tag.hasKey("KnownPlayers")) {
            NBTTagList players = tag.getTagList("KnownPlayers", 10);
            this.knownPlayers.clear();
            for (i = 0; i < players.tagCount(); ++i) {
                this.knownPlayers.add(UUID.fromString(players.getStringTagAt(i)));
            }
        }
        if (tag.hasKey("KnownCreatureTypes")) {
            NBTTagList creatureTypes = tag.getTagList("KnownCreatureTypes", 10);
            this.knownCreatureTypes.clear();
            for (i = 0; i < creatureTypes.tagCount(); ++i) {
                this.knownCreatureTypes.add(EntityList.getClass((ResourceLocation)new ResourceLocation(creatureTypes.getStringTagAt(i))));
            }
        }
        if (tag.hasKey("KnownCreatures")) {
            NBTTagList creatures = tag.getTagList("KnownCreatures", 10);
            this.knownCreatures.clear();
            for (i = 0; i < creatures.tagCount(); ++i) {
                this.knownCreatures.add(UUID.fromString(creatures.getStringTagAt(i)));
            }
        }
        this.setSentinal(tag.getBoolean("Sentinal"));
    }

    private boolean isGroupableCreature(Class<? extends Entity> entity) {
        if (groupables == null) {
            groupables = new HashSet<Class<? extends Entity>>();
            this.addGroupableType(EntityVillager.class);
            this.addGroupableType(EntityGoblin.class);
            this.addGroupableType(EntitySheep.class);
            this.addGroupableType(EntityCow.class);
            this.addGroupableType(EntityMooshroom.class);
            this.addGroupableType(EntityChicken.class);
            this.addGroupableType(EntityPig.class);
            this.addGroupableType(EntityHorse.class);
        }
        return groupables.contains(entity);
    }

    private void addGroupableType(Class<? extends Entity> entity) {
        groupables.add(entity);
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.dataManager.get(OWNER)).orNull();
    }

    @Nullable
    public Entity getOwner() {
        return WitcheryUtils.getPlayer(this.world, this.getOwnerId());
    }

    public void setOwnerId(UUID owner) {
        this.enablePersistence();
        this.dataManager.set(OWNER, (Object)Optional.fromNullable((Object)owner));
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_SILVERFISH_HURT;
    }

    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_TREEFYD_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_CREEPER_DEATH;
    }

    protected Item getDropItem() {
        return Item.getItemFromBlock((Block)Blocks.RED_FLOWER);
    }

    protected boolean canDespawn() {
        return false;
    }
}

