/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntitySummonedUndead
extends EntityMob
implements IEntityOwnable {
    private static final DataParameter<Optional<UUID>> SUMMONER = EntityDataManager.createKey(EntitySummonedUndead.class, (DataSerializer)DataSerializers.OPTIONAL_UNIQUE_ID);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.createKey(EntitySummonedUndead.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static final DataParameter<Boolean> OBSCURED = EntityDataManager.createKey(EntitySummonedUndead.class, (DataSerializer)DataSerializers.BOOLEAN);
    private int timeToLive = -1;
    private EntityPlayer summoner;

    public EntitySummonedUndead(World world) {
        super(world);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(SUMMONER, (Object)Optional.absent());
        this.dataManager.register(SCREAMING, (Object)false);
        this.dataManager.register(OBSCURED, (Object)false);
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        UUID summonerId = this.getOwnerId();
        if (summonerId != null) {
            nbtRoot.setUniqueId("Summoner", summonerId);
        }
        nbtRoot.setBoolean("Obscured", this.isObscured());
        nbtRoot.setInteger("SuicideIn", this.timeToLive);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasUniqueId("Summoner")) {
            this.setSummoner(nbtRoot.getUniqueId("Summoner"));
        }
        this.setObscured(nbtRoot.getBoolean("Obscured"));
        this.timeToLive = nbtRoot.hasKey("SuicideIn") ? nbtRoot.getInteger("SuicideIn") : -1;
    }

    public void setTimeToLive(int i) {
        this.timeToLive = i;
    }

    public boolean isTemp() {
        return this.timeToLive != -1;
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    public UUID getOwnerId() {
        return (UUID)((Optional)this.dataManager.get(SUMMONER)).orNull();
    }

    public EntityPlayer getOwner() {
        if (this.summoner == null) {
            this.summoner = WitcheryUtils.getPlayer(this.world, this.getOwnerId());
        }
        return this.summoner;
    }

    public void setSummoner(UUID id) {
        this.enablePersistence();
        this.dataManager.set(SUMMONER, (Object)Optional.fromNullable((Object)id));
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (!this.isTemp()) {
            int quantity;
            int chance = this.rand.nextInt(Math.max(4 - par2, 2));
            int n = quantity = chance == 0 ? 1 : 0;
            if (quantity > 0) {
                this.entityDropItem(new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST, quantity), 0.0f);
            }
        }
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (this.world != null && !this.isDead && !this.world.isRemote && this.timeToLive != -1) {
            int timeToLive;
            this.timeToLive = timeToLive = this.timeToLive - 1;
            if (timeToLive == 0 || this.getAttackTarget() == null || this.getAttackTarget().isDead) {
                this.world.setEntityState((Entity)this, (byte)5);
                this.setDead();
            }
        }
    }

    public void handleStatusUpdate(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 3;
    }

    public boolean isScreaming() {
        return (Boolean)this.dataManager.get(SCREAMING);
    }

    protected void setScreaming(boolean screaming) {
        this.dataManager.set(SCREAMING, (Object)screaming);
    }

    public boolean isObscured() {
        return (Boolean)this.dataManager.get(OBSCURED);
    }

    public void setObscured(boolean obscured) {
        this.dataManager.set(OBSCURED, (Object)obscured);
    }

    public boolean attackEntityFrom(DamageSource damageSource, float damage) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, damageSource, damage)) {
            return super.attackEntityFrom(damageSource, damage);
        }
        return super.attackEntityFrom(damageSource, Math.min(damage, 15.0f));
    }
}

