/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.util.BlockUtil;

public class EntitySplatter
extends Entity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.createKey(EntitySplatter.class, (DataSerializer)DataSerializers.VARINT);
    public int throwableShake;
    protected boolean inGround;
    private BlockPos pos = BlockPos.ORIGIN;
    private Block tile;
    private int ticksInGround;
    private int ticksInAir;
    private int effectID;
    private int color;
    private int level;

    public EntitySplatter(World world) {
        super(world);
    }

    public EntitySplatter(World world, double x, double y, double z, int effectID, int color2, int level) {
        super(world);
        this.ticksInGround = 0;
        this.setPosition(x, y, z);
        this.effectID = effectID;
        this.level = level;
        this.setColor(color2);
        if (effectID == 1) {
            this.setFire(1000);
        }
    }

    public static void splatter(World world, BlockPos coord, int level) {
        if (!world.isRemote) {
            for (int i = 0; i < 3 + level; ++i) {
                EntitySplatter splatter = new EntitySplatter(world, 0.5 + (double)coord.getX(), 0.5 + (double)coord.getY(), 0.5 + (double)coord.getZ(), 1, 0x990000, level);
                double maxSpeed = 0.1;
                double doubleSpeed = 0.2;
                splatter.setVelocity(world.rand.nextDouble() * doubleSpeed - maxSpeed, world.rand.nextDouble() * 0.05 + 0.3, world.rand.nextDouble() * doubleSpeed - maxSpeed);
                world.spawnEntity((Entity)splatter);
            }
        }
    }

    protected void entityInit() {
        this.dataManager.register(COLOR, (Object)0);
    }

    public int getColor() {
        return (Integer)this.dataManager.get(COLOR);
    }

    protected void setColor(int color2) {
        this.dataManager.set(COLOR, (Object)color2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double distSq) {
        double d1 = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        return distSq < (d1 *= 64.0) * d1;
    }

    public void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        float n2;
        float n;
        float f2 = MathHelper.sqrt((double)(p_70186_1_ * p_70186_1_ + p_70186_3_ * p_70186_3_ + p_70186_5_ * p_70186_5_));
        p_70186_1_ /= (double)f2;
        p_70186_3_ /= (double)f2;
        p_70186_5_ /= (double)f2;
        p_70186_1_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        p_70186_3_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        p_70186_5_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        this.motionX = p_70186_1_ *= (double)p_70186_7_;
        this.motionY = p_70186_3_ *= (double)p_70186_7_;
        this.motionZ = p_70186_5_ *= (double)p_70186_7_;
        float f3 = MathHelper.sqrt((double)(p_70186_1_ * p_70186_1_ + p_70186_5_ * p_70186_5_));
        this.rotationYaw = n = (float)(Math.atan2(p_70186_1_, p_70186_5_) * 180.0 / Math.PI);
        this.prevRotationYaw = n;
        this.rotationPitch = n2 = (float)(Math.atan2(p_70186_3_, f3) * 180.0 / Math.PI);
        this.prevRotationPitch = n2;
        this.ticksInGround = 0;
    }

    public void setVelocity(double motionX, double motionY, double motionZ) {
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float n2;
            float n;
            float f = MathHelper.sqrt((double)(motionX * motionX + motionZ * motionZ));
            this.rotationYaw = n = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
            this.prevRotationYaw = n;
            this.rotationPitch = n2 = (float)(Math.atan2(motionY, f) * 180.0 / Math.PI);
            this.prevRotationPitch = n2;
        }
    }

    public void onUpdate() {
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        super.onUpdate();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            if (this.world.getBlockState(this.pos).getBlock() == this.tile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.setDead();
                }
                return;
            }
            this.inGround = false;
            this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vec3d vec3 = this.getPositionVector();
        Vec3d vec4 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        RayTraceResult movingobjectposition = this.world.rayTraceBlocks(vec3, vec4);
        vec3 = this.getPositionVector();
        vec4 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (movingobjectposition != null) {
            vec4 = new Vec3d(movingobjectposition.hitVec.x, movingobjectposition.hitVec.y, movingobjectposition.hitVec.z);
        }
        if (!this.world.isRemote) {
            Entity entity = null;
            List list2 = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.getEntityBoundingBox().expand(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (Entity entity2 : list2) {
                double d2;
                if (!entity2.canBeCollidedWith() || this.ticksInAir < 5 || entity instanceof EntitySplatter) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity2.getEntityBoundingBox().expand((double)f, (double)f, (double)f);
                RayTraceResult movingobjectposition2 = axisalignedbb.calculateIntercept(vec3, vec4);
                if (movingobjectposition2 == null || !((d2 = vec3.distanceTo(movingobjectposition2.hitVec)) < d0) && d0 != 0.0) continue;
                entity = entity2;
                d0 = d2;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.typeOfHit == RayTraceResult.Type.BLOCK && this.world.getBlockState(new BlockPos(movingobjectposition.getBlockPos().getX(), movingobjectposition.getBlockPos().getY(), movingobjectposition.getBlockPos().getZ())).getBlock() == Blocks.PORTAL) {
                this.setPortal(this.getPosition());
            } else {
                this.onImpact(movingobjectposition);
            }
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f2 = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f2) * 180.0 / Math.PI);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f3 = 0.99f;
        float f4 = this.getGravityVelocity();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float f5 = 0.25f;
                this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * (double)f5, this.posY - this.motionY * (double)f5, this.posZ - this.motionZ * (double)f5, this.motionX, this.motionY, this.motionZ, new int[0]);
            }
            f3 = 0.8f;
        }
        this.motionX *= (double)f3;
        this.motionY *= (double)f3;
        this.motionZ *= (double)f3;
        this.motionY -= (double)f4;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected void onImpact(RayTraceResult mop) {
        if (!this.world.isRemote && mop != null) {
            BlockPos coord;
            switch (mop.typeOfHit) {
                case BLOCK: {
                    coord = mop.getBlockPos().offset(mop.sideHit);
                    break;
                }
                case ENTITY: {
                    coord = mop.entityHit.getPosition();
                    break;
                }
                default: {
                    coord = this.getPosition();
                }
            }
            switch (mop.typeOfHit) {
                case BLOCK: {
                    BlockPos pos = mop.getBlockPos().offset(mop.sideHit);
                    if (BlockUtil.isReplaceableBlock(this.world, pos.getX(), pos.getY(), pos.getZ(), (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.world)))) {
                        this.world.setBlockState(pos, Blocks.FIRE.getDefaultState());
                    }
                    if (this.level - 1 > 0) {
                        EntitySplatter.splatter(this.world, coord, this.level - 1);
                    }
                    this.setDead();
                    break;
                }
                case ENTITY: {
                    if (!(mop.entityHit instanceof EntityLivingBase)) break;
                    mop.entityHit.setFire(5);
                    break;
                }
                case MISS: {
                    this.setDead();
                }
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.setInteger("xTile", this.pos.getX());
        nbtRoot.setInteger("yTile", this.pos.getY());
        nbtRoot.setInteger("zTile", this.pos.getZ());
        nbtRoot.setByte("inTile", (byte)Block.getIdFromBlock((Block)this.tile));
        nbtRoot.setByte("shake", (byte)this.throwableShake);
        nbtRoot.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        nbtRoot.setInteger("Color", this.color);
        nbtRoot.setInteger("Level", this.level);
        nbtRoot.setInteger("Effect", this.effectID);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        this.pos = new BlockPos(nbtRoot.getInteger("xTile"), nbtRoot.getInteger("yTile"), nbtRoot.getInteger("zTile"));
        this.tile = Block.getBlockById((int)(nbtRoot.getByte("inTile") & 0xFF));
        this.throwableShake = nbtRoot.getByte("shake") & 0xFF;
        this.inGround = nbtRoot.getByte("inGround") == 1;
        this.effectID = nbtRoot.getInteger("Effect");
        this.level = nbtRoot.getInteger("Level");
        this.setColor(nbtRoot.getInteger("Color"));
    }
}

