/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrectedClient;
import net.msrandom.witchery.entity.EntityFlyingTameable;
import net.msrandom.witchery.entity.ai.EntityAIFlyerFlyToWaypoint;
import net.msrandom.witchery.entity.ai.EntityAIFlyerFollowOwner;
import net.msrandom.witchery.entity.ai.EntityAIFlyerLand;
import net.msrandom.witchery.entity.ai.EntityAIFlyerWander;
import net.msrandom.witchery.entity.ai.EntityAIFlyingTempt;
import net.msrandom.witchery.entity.ai.EntityAISitAndStay;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class EntitySpirit
extends EntityFlyingTameable {
    private static final DataParameter<Integer> FEATHER_COLOR = EntityDataManager.createKey(EntitySpirit.class, (DataSerializer)DataSerializers.VARINT);
    private static final Ingredient TEMPTATIONS = Ingredient.fromItem((Item)WitcheryFumeItems.FOCUSED_WILL);
    public final EntityAIFlyingTempt aiTempt;
    private int timeToLive = -1;
    private int spiritType = 0;

    public EntitySpirit(World world) {
        super(world);
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISitAndStay(this));
        this.aiTempt = new EntityAIFlyingTempt((EntityCreature)this, TEMPTATIONS, true);
        this.tasks.addTask(3, (EntityAIBase)this.aiTempt);
        this.tasks.addTask(5, new EntityAIFlyerFollowOwner<EntitySpirit>(this, 14.0f, 5.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIFlyerFlyToWaypoint(this, EntityAIFlyerFlyToWaypoint.CarryRequirement.NONE));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, true));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIFlyerWander((EntityLiving)this, 10.0));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 0.2f));
    }

    protected boolean canDespawn() {
        return true;
    }

    public void setTarget(int type) {
        BlockPos pos;
        IChunkGenerator cp;
        this.timeToLive = 200;
        this.spiritType = type;
        IChunkGenerator iChunkGenerator = cp = this.world.getChunkProvider() instanceof ChunkProviderServer ? ((ChunkProviderServer)this.world.getChunkProvider()).chunkGenerator : null;
        if (cp != null && (pos = cp.getNearestStructurePos(this.world, this.world.provider.getDimensionType() == DimensionType.NETHER ? "Fortress" : "Village", this.getPosition(), false)) != null) {
            this.homeX = pos.getX();
            this.homeY = pos.getY();
            this.homeZ = pos.getZ();
            this.waypoint = new ItemStack(WitcheryIngredientItems.WAYSTONE);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setInteger("SuicideIn", this.timeToLive);
        nbtRoot.setInteger("SpiritType", this.spiritType);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.timeToLive = nbtRoot.hasKey("SuicideIn") ? nbtRoot.getInteger("SuicideIn") : -1;
        this.spiritType = nbtRoot.hasKey("SpiritType") ? nbtRoot.getInteger("SpiritType") : 0;
    }

    protected void updateAITasks() {
        this.getNavigator().clearPath();
        super.updateAITasks();
        if (this.world != null && !this.isDead && !this.world.isRemote && this.timeToLive != -1 && --this.timeToLive == 0) {
            this.world.setEntityState((Entity)this, (byte)5);
            this.setDead();
            if (!this.world.isRemote) {
                this.dropFewItems(false, 0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(FEATHER_COLOR, (Object)0);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(4.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.4);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (this.spiritType == 2) {
            return;
        }
        ItemStack stack = this.spiritType == 1 ? new ItemStack(WitcheryIngredientItems.SUBDUED_SPIRIT_VILLAGE) : new ItemStack(WitcheryIngredientItems.SUBDUED_SPIRIT);
        this.entityDropItem(stack, 0.0f);
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.world.isRemote) {
            this.addParticle();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addParticle() {
        int featherColor = this.getFeatherColor();
        int color2 = featherColor > 0 ? featherColor : 0xFFCC00;
        float red = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float green = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color2 & 0xFF) / 255.0f;
        WitcheryResurrectedClient.INSTANCE.addNaturePowerParticle(this.world, this.posX - (double)this.width * 0.5 + this.world.rand.nextDouble() * (double)this.width, 0.1 + this.posY + this.world.rand.nextDouble() * 0.2, this.posZ - (double)this.width * 0.5 + this.world.rand.nextDouble() * (double)this.width, red, green, blue, 10, -0.1f);
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent getDeathSound() {
        return null;
    }

    public boolean processInteract(EntityPlayer par1EntityPlayer, EnumHand hand) {
        return false;
    }

    public EntitySpirit spawnBabyAnimal() {
        return null;
    }

    public boolean isBreedingItem(ItemStack itemstack) {
        return !itemstack.isEmpty() && itemstack.getItem() == Items.BONE;
    }

    public boolean canMateWith(EntityAnimal par1EntityAnimal) {
        return false;
    }

    public int getFeatherColor() {
        return (Integer)this.dataManager.get(FEATHER_COLOR);
    }

    public void setFeatherColor(int par1) {
        this.dataManager.set(FEATHER_COLOR, (Object)par1);
    }

    public boolean getCanSpawnHere() {
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
            boolean superGetCanSpawnHere = this.world.checkNoEntityCollision(this.getEntityBoundingBox()) && this.world.getCollisionBoxes((Entity)this, this.getEntityBoundingBox()).isEmpty() && !this.world.containsAnyLiquid(this.getEntityBoundingBox());
            int i = MathHelper.floor((double)this.posX);
            int j = MathHelper.floor((double)this.getEntityBoundingBox().minY);
            int k = MathHelper.floor((double)this.posZ);
            BlockPos pos = new BlockPos(i, j, k);
            superGetCanSpawnHere = superGetCanSpawnHere && this.getBlockPathWeight(pos) >= 0.0f && j >= 60;
            Block blockID = this.world.getBlockState(pos.down()).getBlock();
            return superGetCanSpawnHere && this.world.rand.nextInt(10) == 0 && (blockID == Blocks.GRASS || blockID == Blocks.SAND) && this.world.getLight(pos) > 8;
        }
        return false;
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.onInitialSpawn(difficulty, par1EntityLivingData);
        return par1EntityLivingData;
    }

    public EntityAgeable createChild(EntityAgeable par1EntityAgeable) {
        return null;
    }
}

