/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class EntitySpellEffect
extends Entity {
    private static final DataParameter<Integer> EFFECT = EntityDataManager.createKey(EntitySpellEffect.class, (DataSerializer)DataSerializers.VARINT);
    public EntityLivingBase shootingEntity;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private boolean inGround;
    private int ticksAlive;
    private int ticksInAir;
    private int lifetime = -1;
    private int effectLevel;

    public EntitySpellEffect(World world) {
        super(world);
        this.noClip = true;
    }

    public EntitySpellEffect(World world, EntityLivingBase thrower, double x, double y, double z, ProjectileSymbolEffect effect, int effectLevel) {
        super(world);
        this.shootingEntity = thrower;
        this.effectLevel = effectLevel;
        this.setLocationAndAngles(thrower.posX, thrower.posY, thrower.posZ, thrower.rotationYaw, thrower.rotationPitch);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        double d3 = MathHelper.sqrt((double)((x += this.rand.nextGaussian() * 0.4) * x + (y += this.rand.nextGaussian() * 0.4) * y + (z += this.rand.nextGaussian() * 0.4) * z));
        this.accelerationX = x / d3 * 0.1;
        this.accelerationY = y / d3 * 0.1;
        this.accelerationZ = z / d3 * 0.1;
        this.setEffectID(SymbolEffect.REGISTRY.getId(effect));
    }

    public void setLifeTime(int ticks) {
        this.lifetime = ticks;
    }

    protected void entityInit() {
        this.dataManager.register(EFFECT, (Object)0);
    }

    public int getEffectID() {
        return (Integer)this.dataManager.get(EFFECT);
    }

    public void setEffectID(int effectID) {
        this.dataManager.set(EFFECT, (Object)effectID);
    }

    public int getEffectLevel() {
        return this.effectLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double par1) {
        double d1 = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public void onUpdate() {
        if (!this.world.isRemote && (this.shootingEntity != null && this.shootingEntity.isDead || !this.world.isBlockLoaded(this.getPosition()))) {
            this.setDead();
        } else {
            SymbolEffect effect;
            super.onUpdate();
            if (this.inGround) {
                Block i = this.world.getBlockState(new BlockPos(this.xTile, this.yTile, this.zTile)).getBlock();
                if (i == this.inTile) {
                    ++this.ticksAlive;
                    if (this.ticksAlive == 600) {
                        this.setDead();
                    }
                    return;
                }
                this.inGround = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                this.ticksAlive = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
                if (this.ticksInAir == 200) {
                    this.setDead();
                }
            }
            if (!this.world.isRemote) {
                Vec3d vec4;
                Vec3d vec3 = this.getPositionVector();
                RayTraceResult movingobjectposition = this.world.rayTraceBlocks(vec3, vec4 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ));
                if (movingobjectposition != null) {
                    vec4 = new Vec3d(movingobjectposition.hitVec.x, movingobjectposition.hitVec.y, movingobjectposition.hitVec.z);
                }
                Entity entity = null;
                List list2 = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.getEntityBoundingBox().expand(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
                double d0 = 0.0;
                for (Entity entity2 : list2) {
                    double d2;
                    if (!entity2.canBeCollidedWith() || entity2 == this.shootingEntity && this.ticksInAir < 25) continue;
                    float f = 0.3f;
                    AxisAlignedBB axisalignedbb = entity2.getEntityBoundingBox().expand((double)f, (double)f, (double)f);
                    RayTraceResult movingobjectposition2 = axisalignedbb.calculateIntercept(vec3, vec4);
                    if (movingobjectposition2 == null || !((d2 = vec3.distanceTo(movingobjectposition2.hitVec)) < d0) && d0 != 0.0) continue;
                    entity = entity2;
                    d0 = d2;
                }
                if (entity != null) {
                    movingobjectposition = new RayTraceResult(entity);
                }
                if (movingobjectposition != null || this.lifetime != -1 && this.lifetime-- <= 0) {
                    this.onImpact(movingobjectposition);
                }
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            float f2 = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.rotationYaw = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) + 90.0f;
            this.rotationPitch = (float)(Math.atan2(f2, this.motionY) * 180.0 / Math.PI) - 90.0f;
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float f3 = this.getMotionFactor();
            if (this.isInWater()) {
                for (int k = 0; k < 4; ++k) {
                    float f4 = 0.25f;
                    this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * (double)f4, this.posY - this.motionY * (double)f4, this.posZ - this.motionZ * (double)f4, this.motionX, this.motionY, this.motionZ, new int[0]);
                }
                f3 = 0.8f;
            }
            if ((effect = SymbolEffect.REGISTRY.get(this.getEffectID())) == null) {
                this.setDead();
            } else {
                if (effect.fallsToEarth() && this.getEffectLevel() == 1) {
                    this.accelerationX *= 0.8;
                    this.accelerationY *= 0.8;
                    this.accelerationZ *= 0.8;
                    this.motionX += this.accelerationX;
                    this.motionY += this.accelerationY;
                    this.motionZ += this.accelerationZ;
                    this.motionY -= 0.05;
                } else {
                    this.motionX += this.accelerationX;
                    this.motionY += this.accelerationY;
                    this.motionZ += this.accelerationZ;
                    this.motionX *= (double)f3;
                    this.motionY *= (double)f3;
                    this.motionZ *= (double)f3;
                }
                this.world.spawnParticle(effect.isCurse() ? EnumParticleTypes.SPELL_MOB : EnumParticleTypes.SLIME, this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0, new int[0]);
                if (effect.isCurse()) {
                    this.world.spawnParticle(EnumParticleTypes.FLAME, this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0, new int[0]);
                }
                this.setPosition(this.posX, this.posY, this.posZ);
            }
        }
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected void onImpact(RayTraceResult mop) {
        SymbolEffect effect;
        if (!this.world.isRemote && (effect = SymbolEffect.REGISTRY.get(this.getEffectID())) instanceof ProjectileSymbolEffect) {
            if (effect.isCurse()) {
                this.playSound(SoundEvents.ENTITY_ENDERDRAGON_HURT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                this.world.setEntityState((Entity)this, (byte)4);
            } else {
                this.playSound(SoundEvents.ENTITY_SMALL_SLIME_JUMP, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                this.world.setEntityState((Entity)this, (byte)5);
            }
            if (mop != null) {
                ((ProjectileSymbolEffect)effect).onCollision(this.world, this.shootingEntity, mop, this);
            }
        }
        this.setDead();
    }

    public void handleStatusUpdate(byte id) {
        if (id == 4) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.SLIME, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.setShort("xTile", (short)this.xTile);
        nbtRoot.setShort("yTile", (short)this.yTile);
        nbtRoot.setShort("zTile", (short)this.zTile);
        nbtRoot.setByte("inTile", (byte)Block.getIdFromBlock((Block)this.inTile));
        nbtRoot.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        nbtRoot.setTag("direction", (NBTBase)this.newDoubleNBTList(new double[]{this.motionX, this.motionY, this.motionZ}));
        nbtRoot.setString("Effect", SymbolEffect.REGISTRY.getKey(this.getEffectID()).toString());
        nbtRoot.setInteger("lifetime", this.lifetime);
        nbtRoot.setInteger("effectLevel", this.effectLevel);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        this.xTile = nbtRoot.getShort("xTile");
        this.yTile = nbtRoot.getShort("yTile");
        this.zTile = nbtRoot.getShort("zTile");
        this.inTile = Block.getBlockById((int)(nbtRoot.getByte("inTile") & 0xFF));
        this.inGround = nbtRoot.getByte("inGround") == 1;
        this.lifetime = nbtRoot.hasKey("lifetime") ? nbtRoot.getInteger("lifetime") : -1;
        if (nbtRoot.hasKey("direction") && nbtRoot.hasKey("EffectID")) {
            this.setEffectID(SymbolEffect.REGISTRY.getIdByKey(new ResourceLocation(nbtRoot.getString("Effect"))));
            NBTTagList nbttaglist = nbtRoot.getTagList("direction", 6);
            this.motionX = nbttaglist.getDoubleAt(0);
            this.motionY = nbttaglist.getDoubleAt(1);
            this.motionZ = nbttaglist.getDoubleAt(2);
        } else {
            this.setDead();
        }
        this.effectLevel = Math.max(nbtRoot.getInteger("effectLevel"), 1);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public float getCollisionBorderSize() {
        return 1.0f;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        boolean canDeflect;
        if (par1DamageSource == DamageSource.OUT_OF_WORLD) {
            return super.attackEntityFrom(par1DamageSource, par2);
        }
        if (this.isEntityInvulnerable(par1DamageSource)) {
            return false;
        }
        this.markVelocityChanged();
        Entity entity = par1DamageSource.getTrueSource();
        boolean bl = canDeflect = entity != null && SymbolEffect.REGISTRY.get(this.getEffectID()).getCanDeflect() && entity instanceof EntityPlayer && (((EntityPlayer)entity).getHeldItemMainhand().getItem() == WitcheryGeneralItems.MYSTIC_BRANCH || ((EntityPlayer)entity).getHeldItemOffhand().getItem() == WitcheryGeneralItems.MYSTIC_BRANCH);
        if (canDeflect) {
            Vec3d vec3 = par1DamageSource.getTrueSource().getLookVec();
            this.motionX = vec3.x;
            this.motionY = vec3.y;
            this.motionZ = vec3.z;
            this.accelerationX = this.motionX * 0.1;
            this.accelerationY = this.motionY * 0.1;
            this.accelerationZ = this.motionZ * 0.1;
            if (par1DamageSource.getTrueSource() instanceof EntityLivingBase) {
                this.shootingEntity = (EntityLivingBase)par1DamageSource.getTrueSource();
            }
            return true;
        }
        return false;
    }

    public float getBrightness() {
        return 1.0f;
    }

    public int getBrightnessForRender() {
        return 0xF000F0;
    }

    public ITextComponent getDisplayName() {
        ResourceLocation key = SymbolEffect.REGISTRY.getKey(this.getEffectID());
        return new TextComponentTranslation("spell." + key.getNamespace() + "." + key.getPath(), new Object[0]);
    }
}

