/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.ai.EntityAIFamiliarFindDiamonds;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class EntitySpectralFamiliar
extends EntityOcelot {
    private static final DataParameter<Byte> ITEM_ID = EntityDataManager.createKey(EntitySpectralFamiliar.class, (DataSerializer)DataSerializers.BYTE);
    private static final Item[] ITEMS = new Item[]{Items.DIAMOND, Items.EMERALD, Items.GOLD_INGOT, Items.IRON_INGOT, Items.REDSTONE, Items.DYE, Items.COAL};
    private static final Block[] ORES = new Block[]{Blocks.DIAMOND_ORE, Blocks.EMERALD_ORE, Blocks.GOLD_ORE, Blocks.IRON_ORE, Blocks.REDSTONE_ORE, Blocks.LAPIS_ORE, Blocks.COAL_ORE};
    private static final int[] ORE_DEPTH = new int[]{14, 14, 30, 64, 16, 30, 64};
    private int searches = 0;

    public EntitySpectralFamiliar(World world) {
        super(world);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.taskEntries.clear();
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.aiSit = new EntityAISit((EntityTameable)this);
        this.tasks.addTask(2, (EntityAIBase)this.aiSit);
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 5.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIFamiliarFindDiamonds(this, 1.33));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIOcelotAttack((EntityLiving)this));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
    }

    protected void entityInit() {
        super.entityInit();
        this.setTameSkin(1);
        this.dataManager.register(ITEM_ID, (Object)-1);
    }

    public int getItemIDToFind() {
        return ((Byte)this.dataManager.get(ITEM_ID)).byteValue();
    }

    public void setItemIDToFind(int itemID) {
        this.dataManager.set(ITEM_ID, (Object)((byte)itemID));
    }

    public void writeEntityToNBT(NBTTagCompound nbtTag) {
        super.writeEntityToNBT(nbtTag);
        nbtTag.setInteger("ItemToFind", this.getItemIDToFind());
        nbtTag.setInteger("Searches", this.searches);
    }

    public void readEntityFromNBT(NBTTagCompound nbtTag) {
        super.readEntityFromNBT(nbtTag);
        this.setItemIDToFind(nbtTag.getInteger("ItemToFind"));
        this.searches = nbtTag.getInteger("Searches");
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(40.0);
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), 0.5f);
    }

    public boolean processInteract(EntityPlayer player, EnumHand hand) {
        if (this.isTamed() && this.isOwner((EntityLivingBase)player) && !this.world.isRemote) {
            ItemStack item = player.getHeldItemMainhand();
            int itemToFind = this.hasOre(item);
            if (itemToFind != -1) {
                this.setItemIDToFind(itemToFind);
                ++this.searches;
                item.shrink(1);
                double[] probs = new double[]{0.0, 0.6, 0.75, 0.85, 0.95};
                double chance = this.world.rand.nextDouble();
                if (this.searches > 5 || this.searches > 1 && chance < probs[Math.max(this.searches - 1, 1)]) {
                    this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)5);
                    this.setDead();
                } else {
                    player.world.playSound(null, player.getPosition(), SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, this.getSoundCategory(), 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                this.aiSit.setSitting(!this.isSitting());
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    public Block getBlockIDToFind() {
        int idToFind = this.getItemIDToFind();
        if (idToFind != -1) {
            return ORES[idToFind];
        }
        return null;
    }

    public void clearItemToFind() {
        this.setItemIDToFind(-1);
    }

    public int getDepthToFind() {
        int idToFind = this.getItemIDToFind();
        if (idToFind != -1) {
            return ORE_DEPTH[idToFind];
        }
        return 1;
    }

    private int hasOre(ItemStack item) {
        if (item == null) {
            return -1;
        }
        return Arrays.asList(ITEMS).indexOf(item.getItem());
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_PIG_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_PIG_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_PIG_DEATH;
    }

    protected void playStepSound(BlockPos pos, Block block) {
        this.playSound(SoundEvents.ENTITY_PIG_STEP, 0.15f, 1.0f);
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.entityDropItem(new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST), 0.0f);
    }

    public boolean isBreedingItem(ItemStack par1ItemStack) {
        return false;
    }

    public boolean canMateWith(EntityAnimal par1EntityAnimal) {
        return false;
    }

    public EntityOcelot createChild(EntityAgeable par1EntityAgeable) {
        return null;
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData data) {
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).applyModifier(new AttributeModifier("Random spawn bonus", this.rand.nextGaussian() * 0.05, 1));
        return data;
    }

    public void setAISitting(boolean b) {
        this.setSitting(b);
        this.aiSit.setSitting(b);
    }
}

