/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.WorldProviderSpiritWorld;

public class EntitySleepingBody
extends EntityLiving {
    private static final DataParameter<NBTTagCompound> OWNER = EntityDataManager.createKey(EntitySleepingBody.class, (DataSerializer)DataSerializers.COMPOUND_TAG);
    private EntityPlayer player;

    public EntitySleepingBody(World world) {
        super(world);
    }

    public boolean canBePushed() {
        return false;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(OWNER, (Object)new NBTTagCompound());
    }

    protected boolean processInteract(EntityPlayer par1EntityPlayer, EnumHand hand) {
        return true;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.world.isRemote || par1DamageSource == DamageSource.OUT_OF_WORLD) {
            return super.attackEntityFrom(par1DamageSource, par2);
        }
        if (par1DamageSource.getImmediateSource() != null && par1DamageSource.getImmediateSource() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.getImmediateSource()).capabilities.isCreativeMode) {
            return super.attackEntityFrom(par1DamageSource, par2);
        }
        if (this.player != null) {
            return super.attackEntityFrom(par1DamageSource, par2);
        }
        return false;
    }

    public void writeEntityToNBT(NBTTagCompound tag) {
        super.writeEntityToNBT(tag);
        tag.setTag("Owner", (NBTBase)this.dataManager.get(OWNER));
    }

    public void readEntityFromNBT(NBTTagCompound tag) {
        super.readEntityFromNBT(tag);
        if (tag.hasKey("Owner")) {
            this.dataManager.set(OWNER, (Object)tag.getCompoundTag("Owner"));
        }
    }

    public EntityPlayer getOwner() {
        if (this.player == null) {
            this.player = this.world.isRemote ? this.getClientPlayer((NBTTagCompound)this.dataManager.get(OWNER)) : (EntityPlayer)((WorldServer)this.world).getEntityFromUuid(((NBTTagCompound)this.dataManager.get(OWNER)).getUniqueId("UUID"));
        }
        return this.player;
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer(NBTTagCompound tag) {
        NetHandlerPlayClient connection = Minecraft.getMinecraft().getConnection();
        if (connection == null) {
            return null;
        }
        NetworkPlayerInfo playerInfo = connection.getPlayerInfo(tag.getUniqueId("UUID"));
        if (playerInfo == null) {
            return null;
        }
        EntityOtherPlayerMP player = new EntityOtherPlayerMP(this.world, playerInfo.getGameProfile());
        player.readFromNBT(tag);
        return player;
    }

    public void setOwnerData(NBTTagCompound data) {
        this.enablePersistence();
        this.dataManager.set(OWNER, (Object)data);
    }

    public void setOwner(EntityPlayer player) {
        this.setOwnerData(player.writeToNBT(new NBTTagCompound()));
        this.player = player;
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (!this.world.isRemote && this.player != null) {
            if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this.player)) {
                WorldProviderSpiritWorld.returnPlayerToOverworld(this.player);
            }
            if (WitcheryUtils.getExtension(this.player).getSpiritData().isGhost()) {
                WorldProviderSpiritWorld.returnGhostPlayerToSpiritWorld(this.player);
                WorldProviderSpiritWorld.returnPlayerToOverworld(this.player);
            }
        }
    }
}

