/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockCircleGlyph;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.ritual.SmallRitual;
import net.msrandom.witchery.client.particle.ParticleNaturePower;
import net.msrandom.witchery.client.resources.BrewColorsManager;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityRitualItem
extends EntityItem {
    private ActiveRitual currentSetup;
    private boolean locationTested;
    private boolean containsUnfinishedRitual;
    private int color = -1;

    public EntityRitualItem(World world) {
        super(world);
    }

    public EntityRitualItem(EntityItem entityItem) {
        super(entityItem.world, entityItem.posX, entityItem.posY, entityItem.posZ, entityItem.getItem());
        this.setPickupDelay(entityItem.pickupDelay);
        this.motionX = entityItem.motionX;
        this.motionY = entityItem.motionY;
        this.motionZ = entityItem.motionZ;
    }

    public void onCollideWithPlayer(EntityPlayer player) {
        double minPickupRange = 0.75;
        double minPickupRangeSq = minPickupRange * minPickupRange;
        if (this.getDistanceSq((Entity)player) <= minPickupRangeSq) {
            super.onCollideWithPlayer(player);
        }
    }

    public void onUpdate() {
        if (this.age >= 5 && this.world.getBlockState(new BlockPos(this.posX, this.posY - 1.0, this.posZ)).getMaterial().isSolid()) {
            double xDiff = this.posX - this.prevPosX;
            double zDiff = this.posZ - this.prevPosZ;
            if (xDiff * xDiff + zDiff * zDiff > 1.21) {
                this.currentSetup = null;
                this.locationTested = false;
                this.age = 5;
            }
            super.onUpdate();
            if (!this.locationTested && this.currentSetup == null) {
                SmallRitual ritual = SmallRitual.rituals.get(this.getItem().getItem());
                BlockPos circleCenter = null;
                BlockPos currentPosition = this.getPosition();
                int size = ritual.getCircle().getSize();
                for (int x = -size; x <= size; ++x) {
                    for (int z = -size; z <= size; ++z) {
                        BlockPos position = currentPosition.add(x, 0, z);
                        AtomicReference block = new AtomicReference();
                        AtomicBoolean hasActive = new AtomicBoolean();
                        HashSet toReset = new HashSet();
                        WitcheryUtils.findCircleBlocks(position, size, (Function1<? super BlockPos, Boolean>)((Function1)pos -> {
                            IBlockState state = this.world.getBlockState(pos);
                            if (block.get() == null) {
                                if (WitcheryUtils.isAir(state, (IBlockAccess)this.world, pos) || state.getBlock() != ritual.getCircle().getGlyph()) {
                                    return false;
                                }
                                block.set(state.getBlock());
                                if (state.getProperties().containsKey((Object)BlockCircleGlyph.ACTIVE)) {
                                    hasActive.set(true);
                                }
                            } else if (state.getBlock() != block.get()) {
                                block.set(null);
                                for (BlockPos blockPos : toReset) {
                                    this.world.setBlockState(blockPos, this.world.getBlockState(blockPos).withProperty((IProperty)BlockCircleGlyph.ACTIVE, (Comparable)Boolean.valueOf(false)));
                                }
                                return false;
                            }
                            if (hasActive.get()) {
                                toReset.add(pos);
                                this.world.setBlockState(pos, state.withProperty((IProperty)BlockCircleGlyph.ACTIVE, (Comparable)Boolean.valueOf(true)));
                            }
                            return true;
                        }));
                        if (block.get() == null) continue;
                        circleCenter = position;
                        break;
                    }
                    if (circleCenter == null) continue;
                    this.currentSetup = new ActiveRitual(ritual, circleCenter);
                    break;
                }
                this.locationTested = true;
            }
            if (this.currentSetup != null) {
                if (this.world.isRemote) {
                    this.addParticles();
                } else if (this.age >= 80 && this.currentSetup.center != null) {
                    switch (this.currentSetup.ritual.activate(this.world, this, this.getItem(), this.currentSetup.center)) {
                        case DONE: {
                            this.setDead();
                            break;
                        }
                        case EXPLODE: {
                            WitcheryUtils.findCircleBlocks(this.currentSetup.center, this.currentSetup.ritual.getCircle().getSize(), (Function1<? super BlockPos, Boolean>)((Function1)arg_0 -> ((World)this.world).setBlockToAir(arg_0)));
                            this.world.setEntityState((Entity)this, (byte)5);
                            this.currentSetup = null;
                            this.setDead();
                            break;
                        }
                        case NO_POWER: {
                            this.world.setEntityState((Entity)this, (byte)4);
                            this.age = 40;
                        }
                    }
                }
            }
        } else {
            super.onUpdate();
        }
    }

    public void handleStatusUpdate(byte id) {
        switch (id) {
            case 4: {
                this.containsUnfinishedRitual = true;
                for (int i = 0; i < 20; ++i) {
                    this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < 20; ++i) {
                    this.world.spawnParticle(EnumParticleTypes.EXPLOSION_LARGE, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
        }
        super.handleStatusUpdate(id);
    }

    @SideOnly(value=Side.CLIENT)
    private void addParticles() {
        if (this.color == -1) {
            Item item = Item.getItemFromBlock((Block)this.currentSetup.ritual.getCircle().getGlyph());
            this.color = item == Items.AIR ? 59030 : BrewColorsManager.INSTANCE.getColor(ItemKey.get(item));
        }
        int red = this.color >> 16 & 0xFF;
        int green = this.color >> 8 & 0xFF;
        int blue = this.color & 0xFF;
        double distance = this.containsUnfinishedRitual ? 0.0 : (double)(80 - this.age) / 80.0;
        for (int i = 0; i <= (this.containsUnfinishedRitual ? 4 : Math.min(Math.max(this.age / 8, 10), 5)); ++i) {
            float f = this.rand.nextFloat() * 0.6f + 0.4f;
            double xPos = this.rand.nextDouble() * 0.8 - 0.4;
            double zPos = this.rand.nextDouble() * 0.8 - 0.4;
            double d0 = this.posX + xPos;
            double d2 = this.posY + 0.4;
            double d3 = this.posZ + zPos;
            double maxSpeed = 0.04;
            double doubleSpeed = 0.08;
            ParticleNaturePower sparkle2 = new ParticleNaturePower(this.world, d0, d2, d3, this.rand.nextDouble() * doubleSpeed - maxSpeed, this.rand.nextDouble() * 0.05 + 0.08, this.rand.nextDouble() * doubleSpeed - maxSpeed);
            sparkle2.setSpeed(distance + 0.5);
            sparkle2.setCircling(true);
            sparkle2.setScale(this.rand.nextFloat() * 0.2f + 0.5f);
            sparkle2.setGravity(0.25f);
            sparkle2.setCanMove(true);
            sparkle2.setMaxAge(this.containsUnfinishedRitual ? 5 : 10 + this.rand.nextInt(10));
            sparkle2.setRBGColorF(f * ((float)red / 255.0f), f * ((float)green / 255.0f), f * ((float)blue / 255.0f));
            sparkle2.setAlphaF(0.1f);
            Minecraft.getMinecraft().effectRenderer.addEffect((Particle)sparkle2);
        }
    }

    public void setDead() {
        super.setDead();
        this.resetRitual();
    }

    private void resetRitual() {
        if (this.currentSetup != null) {
            WitcheryUtils.findCircleBlocks(this.currentSetup.center, this.currentSetup.ritual.getCircle().getSize(), (Function1<? super BlockPos, Boolean>)((Function1)pos -> {
                IBlockState state = this.world.getBlockState(pos);
                if (!state.getProperties().containsKey((Object)BlockCircleGlyph.ACTIVE)) {
                    return false;
                }
                this.world.setBlockState(pos, state.withProperty((IProperty)BlockCircleGlyph.ACTIVE, (Comparable)Boolean.valueOf(false)));
                return true;
            }));
        }
    }

    private static class ActiveRitual {
        private final SmallRitual ritual;
        private final BlockPos center;

        public ActiveRitual(SmallRitual ritual, BlockPos center) {
            this.ritual = ritual;
            this.center = center;
        }
    }
}

