/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import kotlin.collections.CollectionsKt;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.entity.ReflectiveEntity;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.symbol.ConfudusSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ExpelliarmusSymbolEffect;
import net.msrandom.witchery.infusion.symbol.FlipendoSymbolEffect;
import net.msrandom.witchery.infusion.symbol.IgnianimaSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ImpedimentaSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcherySymbolEffects;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ItemCrossbowPistol;
import net.msrandom.witchery.item.bolts.ItemCrossbowBolt;
import net.msrandom.witchery.potion.PotionIllFitting;
import net.msrandom.witchery.resources.AlternateFormStatManager;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.util.ElementWeight;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WeightedElement;
import net.msrandom.witchery.util.WeightedElementKt;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityReflection
extends EntityMob
implements IRangedAttackMob,
IHandleDeathTouch,
ReflectiveEntity {
    public static final List<WeightedElement<ProjectileSymbolEffect>> SPELLS = WeightedElementKt.toWeightedList(CollectionsKt.listOf((Object[])new ElementWeight[]{new ElementWeight<IgnianimaSymbolEffect>(14, WitcherySymbolEffects.IGNIANIMA), new ElementWeight<ExpelliarmusSymbolEffect>(2, WitcherySymbolEffects.EXPELLIARMUS), new ElementWeight<FlipendoSymbolEffect>(2, WitcherySymbolEffects.FLIPENDO), new ElementWeight<ImpedimentaSymbolEffect>(2, WitcherySymbolEffects.IMPEDIMENTA), new ElementWeight<ConfudusSymbolEffect>(1, WitcherySymbolEffects.CONFUNDUS)}));
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.createKey(EntityReflection.class, (DataSerializer)DataSerializers.OPTIONAL_UNIQUE_ID);
    private static final DataParameter<NBTTagCompound> ENTITY = EntityDataManager.createKey(EntityReflection.class, (DataSerializer)DataSerializers.COMPOUND_TAG);
    private final EntityAIAttackRangedBow<EntityReflection> bowAttack = new EntityAIAttackRangedBow<EntityReflection>(this, 1.0, 20, 15.0f){

        protected boolean isBowInMainhand() {
            return super.isBowInMainhand() || EntityReflection.this.getHeldItemOffhand().getItem() instanceof ItemCrossbowPistol;
        }
    };
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
    private int attackTimer;
    private boolean freeSpawn;
    private int livingTicks = -1;
    private Task task;
    private EntityPlayer reflected;

    public EntityReflection(World world) {
        super(world);
        this.isImmuneToFire = true;
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.experienceValue = 50;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(OWNER, (Object)Optional.absent());
        this.dataManager.register(ENTITY, (Object)new NBTTagCompound());
    }

    public boolean isNonBoss() {
        return false;
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.dataManager.get(OWNER)).orNull();
    }

    public void setOwnerId(UUID par1Str) {
        this.enablePersistence();
        this.dataManager.set(OWNER, (Object)Optional.fromNullable((Object)par1Str));
    }

    public EntityPlayer getOwner() {
        return WitcheryUtils.getPlayer(this.world, this.getOwnerId());
    }

    @Override
    public EntityPlayer getReflected() {
        if (this.world.isRemote && (this.ticksExisted % 30 == 1 || this.reflected == null)) {
            this.reflected = Companion.getClientPlayer(this.world, (NBTTagCompound)this.dataManager.get(ENTITY));
        }
        return this.reflected;
    }

    public void setReflected(EntityPlayer reflected) {
        this.reflected = reflected;
        this.dataManager.set(ENTITY, (Object)reflected.writeToNBT(new NBTTagCompound()));
    }

    public void setLifetime(int ticks) {
        this.livingTicks = ticks;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(100.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(2.0);
    }

    public void setInWeb() {
    }

    public String getName() {
        if (this.hasCustomName()) {
            return this.getCustomNameTag();
        }
        EntityPlayer owner = this.getOwner();
        return owner == null ? super.getName() : owner.getName();
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.ticksExisted % 30 == 1) {
            if (!this.world.isRemote) {
                ItemStack held;
                if (!this.freeSpawn && !WitcheryDimensions.MIRROR.isInDimension((Entity)this)) {
                    this.setDead();
                    return;
                }
                if (this.livingTicks > -1 && --this.livingTicks == 0) {
                    this.setDead();
                    return;
                }
                double R = 10.0;
                double RY = 8.0;
                AxisAlignedBB bounds = new AxisAlignedBB(this.posX - R, this.posY - RY, this.posZ - R, this.posX + R, this.posY + RY, this.posZ + R);
                List players = this.world.getEntitiesWithinAABB(EntityPlayer.class, bounds);
                EntityPlayer ownerEntity = this.getOwner();
                boolean ownerFound = false;
                EntityPlayer closest = null;
                double distance = Double.MAX_VALUE;
                for (EntityPlayer player : players) {
                    double newDistance = player.getDistanceSq((Entity)this);
                    if (closest == null || newDistance < distance) {
                        closest = player;
                        distance = newDistance;
                    }
                    if (ownerEntity != player) continue;
                    ownerFound = true;
                }
                if (ownerEntity == null || !ownerFound) {
                    if (closest != null) {
                        this.setOwnerId(closest.getUniqueID());
                    } else {
                        this.setOwnerId(null);
                    }
                }
                boolean resetGear = true;
                if (this.getOwnerId() != null) {
                    EntityPlayer owner;
                    EntityPlayer entityPlayer = owner = ownerEntity == null || !ownerFound ? this.getOwner() : ownerEntity;
                    if (owner != null) {
                        ItemStack offHand;
                        ItemStack mainHand;
                        for (int i = 2; i <= 5; ++i) {
                            EntityEquipmentSlot slot = PotionIllFitting.SLOTS[i];
                            ItemStack armor = owner.getItemStackFromSlot(slot);
                            if (!armor.isEmpty()) {
                                armor = armor.copy();
                            }
                            this.setItemStackToSlot(slot, armor);
                        }
                        ItemStack bestWeapon = ItemStack.EMPTY;
                        ItemStack shield = ItemStack.EMPTY;
                        ItemStack crossbow = ItemStack.EMPTY;
                        double bestDamage = 0.0;
                        for (int hot = -1; hot < 9; ++hot) {
                            ItemStack hotbarItem;
                            ItemStack itemStack = hotbarItem = hot == -1 ? owner.getHeldItemOffhand() : owner.inventory.getStackInSlot(hot);
                            if (hotbarItem.isEmpty()) continue;
                            if (shield.isEmpty() && hotbarItem.getItemUseAction() == EnumAction.BLOCK) {
                                shield = hotbarItem;
                            }
                            if (crossbow.isEmpty() && hotbarItem.getItem() instanceof ItemCrossbowPistol) {
                                crossbow = hotbarItem;
                            }
                            double damage = 0.0;
                            for (AttributeModifier modifier : hotbarItem.getAttributeModifiers(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName())) {
                                if (modifier.getOperation() != 0) continue;
                                damage += modifier.getAmount();
                            }
                            if (!(damage > bestDamage)) continue;
                            bestWeapon = hotbarItem;
                            bestDamage = damage;
                        }
                        PlayerExtendedData playerEx = WitcheryUtils.getExtension(owner);
                        this.setReflected(owner);
                        if (!shield.isEmpty() && shield == bestWeapon) {
                            mainHand = shield;
                            offHand = owner.getHeldItemOffhand();
                        } else {
                            ItemStack bestOffHand;
                            ItemStack itemStack = bestOffHand = shield.isEmpty() ? owner.getHeldItemOffhand() : shield;
                            if (crossbow.isEmpty()) {
                                mainHand = bestWeapon.isEmpty() ? owner.getHeldItemMainhand() : bestWeapon;
                                offHand = bestOffHand;
                            } else {
                                mainHand = bestOffHand.isEmpty() ? bestWeapon : bestOffHand;
                                offHand = crossbow;
                            }
                        }
                        mainHand = mainHand.copy();
                        offHand = offHand.copy();
                        AlternateForm.Stats stats2 = AlternateFormStatManager.INSTANCE.getStats(playerEx.getEffectiveForm());
                        if (stats2.getHoldableItem() != Items.AIR) {
                            if (mainHand.getItem() != stats2.getHoldableItem()) {
                                mainHand = ItemStack.EMPTY;
                            }
                            if (offHand.getItem() != stats2.getHoldableItem()) {
                                offHand = ItemStack.EMPTY;
                            }
                        }
                        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(stats2.getReflectionDamage());
                        ShapeShift.INSTANCE.initCurrentShift((EntityLivingBase)this, owner, false);
                        this.setHeldItem(EnumHand.MAIN_HAND, mainHand);
                        this.setHeldItem(EnumHand.OFF_HAND, offHand);
                        resetGear = false;
                        if (this.ticksExisted % 60 == 1) {
                            this.clearActivePotions();
                            for (PotionEffect effect : owner.getActivePotionEffects()) {
                                this.addPotionEffect(new PotionEffect(effect));
                            }
                        }
                    }
                }
                if (resetGear) {
                    for (EntityPlayer slot2 : EntityEquipmentSlot.values()) {
                        this.setItemStackToSlot((EntityEquipmentSlot)slot2, ItemStack.EMPTY);
                    }
                }
                if ((held = this.getHeldItemMainhand()).getItem() == WitcheryGeneralItems.MYSTIC_BRANCH || held.getItem() instanceof ItemBow || this.getHeldItemOffhand().getItem() instanceof ItemCrossbowPistol) {
                    if (this.task != Task.RANGED) {
                        this.tasks.removeTask((EntityAIBase)this.aiAttackOnCollide);
                    }
                    this.tasks.addTask(2, this.bowAttack);
                    this.task = Task.RANGED;
                } else {
                    if (this.task != Task.MELEE) {
                        this.tasks.removeTask(this.bowAttack);
                    }
                    this.tasks.addTask(2, (EntityAIBase)this.aiAttackOnCollide);
                    this.task = Task.MELEE;
                }
                if (this.isEntityAlive() && this.getAttackTarget() != null && this.getNavigator().noPath() && this.getEntitySenses().canSee((Entity)this.getAttackTarget())) {
                    EntityLivingBase attackTarget = this.getAttackTarget();
                    float par2 = 1.0f;
                    this.castSpell(attackTarget, par2, WitcherySymbolEffects.ATTRAHO);
                }
            }
            if (!this.world.isRemote && this.world.rand.nextDouble() < 0.05 && this.getAttackTarget() != null && (this.getAttackTarget().isAirBorne || this.getAttackTarget() instanceof EntityPlayer && ((EntityPlayer)this.getAttackTarget()).capabilities.isFlying) && !this.getAttackTarget().isPotionActive(MobEffects.SLOWNESS)) {
                this.getAttackTarget().addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 200, 5));
            }
        }
    }

    public void onDeath(DamageSource p_70645_1_) {
        super.onDeath(p_70645_1_);
        WitcheryBlocks.MIRROR.demonSlain(this.world, this.posX, this.posY, this.posZ);
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, source, damage)) {
            return super.attackEntityFrom(source, damage);
        }
        if (!this.isHandActive()) {
            ItemStack mainHand = this.getHeldItemMainhand();
            ItemStack offHand = this.getHeldItemOffhand();
            Object blocking = mainHand.getItemUseAction() == EnumAction.BLOCK ? EnumHand.MAIN_HAND : (offHand.getItemUseAction() == EnumAction.BLOCK ? EnumHand.OFF_HAND : null);
            if (blocking != null && this.rand.nextInt(3) != 0) {
                this.setActiveHand((EnumHand)blocking);
                return false;
            }
        }
        return super.attackEntityFrom(source, Math.min(damage, 6.0f));
    }

    @Override
    public float getCapDT(DamageSource source) {
        return 2.0f;
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        UUID id = this.getOwnerId();
        if (id != null) {
            nbtRoot.setUniqueId("Owner", id);
        }
        nbtRoot.setBoolean("FreeSpawn", this.freeSpawn);
        nbtRoot.setInteger("LivingTicks", this.livingTicks);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasUniqueId("Owner")) {
            this.setOwnerId(nbtRoot.getUniqueId("Owner"));
        }
        this.freeSpawn = nbtRoot.getBoolean("FreeSpawn");
        this.livingTicks = nbtRoot.getInteger("LivingTicks");
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        return super.attackEntityAsMob(par1Entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
        } else {
            super.handleStatusUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness() {
        return 1.0f;
    }

    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_REFLECTION_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_REFLECTION_HURT;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_REFLECTION_DEATH;
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.entityDropItem(new ItemStack((Block)WitcheryBlocks.DEMON_HEART), 0.0f);
    }

    protected void dropEquipment(boolean p_82160_1_, int p_82160_2_) {
    }

    protected Item getDropItem() {
        return null;
    }

    protected boolean canDespawn() {
        return false;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float par2) {
        if (this.getHeldItemOffhand().getItem() instanceof ItemCrossbowPistol) {
            ItemCrossbowPistol.Companion.launchNPCBolt(this.getHeldItemOffhand(), this.world, (EntityLiving)this, par2, (ItemCrossbowBolt)ItemCrossbowPistol.Companion.getProjectile(this.getHeldItemOffhand()));
        } else {
            ItemStack held = this.getHeldItemMainhand();
            if (held.isEmpty()) {
                return;
            }
            this.attackTimer = 10;
            this.world.setEntityState((Entity)this, (byte)4);
            if (held.getItem() == WitcheryGeneralItems.MYSTIC_BRANCH) {
                if (this.world.rand.nextBoolean()) {
                    this.castSpell(target, par2, WeightedElementKt.getWeighted(SPELLS, this.rand));
                }
            } else if (held.getItem() == WitcheryGeneralItems.CROSSBOW_PISTOL) {
                ItemCrossbowPistol.Companion.launchNPCBolt(held, this.world, (EntityLiving)this, par2);
            } else {
                EntityArrow entityarrow2 = ((ItemArrow)Items.ARROW).createArrow(this.world, new ItemStack(Items.ARROW), (EntityLivingBase)this);
                double d0 = target.posX - this.posX;
                double d1 = target.getEntityBoundingBox().minY + (double)(target.height / 3.0f) - entityarrow2.posY;
                double d2 = target.posZ - this.posZ;
                double d3 = MathHelper.sqrt((double)(d0 * d0 + d2 * d2));
                entityarrow2.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.world.getDifficulty().getId() * 3));
                int i = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.POWER, (ItemStack)this.getHeldItemMainhand());
                int j = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.PUNCH, (ItemStack)this.getHeldItemMainhand());
                entityarrow2.setDamage((double)(par2 * 2.0f) + this.rand.nextGaussian() * 0.25 + (double)((float)this.world.getDifficulty().getId() * 0.11f));
                if (i > 0) {
                    entityarrow2.setDamage(entityarrow2.getDamage() + (double)i * 0.5 + 0.5);
                }
                if (j > 0) {
                    entityarrow2.setKnockbackStrength(j);
                }
                if (EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.FLAME, (ItemStack)this.getHeldItemMainhand()) > 0) {
                    entityarrow2.setFire(100);
                }
                this.playSound(SoundEvents.ENTITY_ARROW_SHOOT, 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
                this.world.spawnEntity((Entity)entityarrow2);
            }
        }
    }

    public void setSwingingArms(boolean b) {
    }

    private void castSpell(EntityLivingBase targetEntity, float par2, ProjectileSymbolEffect spell) {
        double d0 = targetEntity.posX - this.posX;
        double d2 = targetEntity.getEntityBoundingBox().minY + (double)(targetEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
        double d3 = targetEntity.posZ - this.posZ;
        float f1 = MathHelper.sqrt((float)par2) * 0.5f;
        if (!this.world.isRemote) {
            this.world.playEvent(1009, this.getPosition(), 0);
            EntitySpellEffect effect = new EntitySpellEffect(this.world, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d2, d3 + this.rand.nextGaussian() * (double)f1, spell, 1);
            effect.posX = this.posX;
            effect.posY = this.posY + (double)(this.height / 2.0f);
            effect.posZ = this.posZ;
            this.world.spawnEntity((Entity)effect);
        }
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData data) {
        this.freeSpawn = true;
        return super.onInitialSpawn(difficulty, data);
    }

    private static enum Task {
        MELEE,
        RANGED;

    }
}

