/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityBrazier;
import net.msrandom.witchery.block.entity.TileEntityKettle;
import net.msrandom.witchery.entity.EntitySummonedUndead;
import net.msrandom.witchery.init.WitcherySounds;

public class EntityPoltergeist
extends EntitySummonedUndead {
    private int attackTimer;

    public EntityPoltergeist(World par1World) {
        super(par1World);
        ((PathNavigateGround)this.getNavigator()).setBreakDoors(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.3);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(3.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 15;
        } else {
            super.handleStatusUpdate(par1);
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.ticksExisted % 100 == 0) {
            double RADIUS = 16.0;
            double RADIUS_SQ = 256.0;
            double THROW_RANGE = 3.0;
            double THROW_RANGE_SQ = 9.0;
            double EVIL_RANGE = 8.0;
            double EVIL_RANGE_SQ = 64.0;
            double MAX_SPEED = 0.6;
            AxisAlignedBB bounds = new AxisAlignedBB(this.posX - RADIUS, this.posY - RADIUS, this.posZ - RADIUS, this.posX + RADIUS, this.posY + RADIUS, this.posZ + RADIUS);
            List hangingItems = this.world.getEntitiesWithinAABB(EntityHanging.class, bounds);
            for (EntityHanging hanging : hangingItems) {
                if (!(this.getDistanceSq((Entity)hanging) <= RADIUS_SQ)) continue;
                if (this.getDistanceSq((Entity)hanging) <= THROW_RANGE_SQ) {
                    if (!this.world.isRemote) {
                        hanging.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)THROW_RANGE);
                    }
                    this.attackTimer = 15;
                    this.world.setEntityState((Entity)this, (byte)4);
                } else {
                    this.getNavigator().tryMoveToXYZ(hanging.posX, hanging.posY, hanging.posZ, 1.0);
                }
                return;
            }
            EntityPlayer summoner = this.getOwner();
            if (summoner != null && this.getDistanceSq((Entity)summoner) <= EVIL_RANGE_SQ) {
                TileEntity closest = null;
                double closestDist = -1.0;
                for (TileEntity tile : this.world.loadedTileEntityList) {
                    double distSq;
                    if (!(tile instanceof IInventory) || tile instanceof TileEntityKettle || tile instanceof TileEntityBrazier || (distSq = this.getDistanceSq(0.5 + (double)tile.getPos().getX(), 0.5 + (double)tile.getPos().getY(), 0.5 + (double)tile.getPos().getZ())) > 256.0) continue;
                    IInventory inventory = (IInventory)tile;
                    ArrayList<Integer> indices = new ArrayList<Integer>();
                    for (int i = 0; i < inventory.getSizeInventory(); ++i) {
                        if (inventory.getStackInSlot(i).isEmpty()) continue;
                        indices.add(i);
                    }
                    if (indices.size() <= 0 || closest != null && distSq >= closestDist) continue;
                    closest = tile;
                    closestDist = distSq;
                }
                if (closest != null) {
                    IInventory inventory2 = (IInventory)closest;
                    ArrayList<Integer> indices2 = new ArrayList<Integer>();
                    for (int j = 0; j < inventory2.getSizeInventory(); ++j) {
                        if (inventory2.getStackInSlot(j).isEmpty()) continue;
                        indices2.add(j);
                    }
                    if (indices2.size() > 0) {
                        if (this.getDistanceSq(closest.getPos()) <= 9.0) {
                            if (!this.world.isRemote) {
                                int slot = (Integer)indices2.get(this.world.rand.nextInt(indices2.size()));
                                ItemStack stack = inventory2.getStackInSlot(slot);
                                if (stack.getCount() > 1) {
                                    stack.shrink(1);
                                    stack = stack.copy();
                                    stack.setCount(1);
                                } else {
                                    inventory2.setInventorySlotContents(slot, ItemStack.EMPTY);
                                }
                                EntityItem itemEntity = new EntityItem(this.world, 0.5 + (double)closest.getPos().getX(), 0.5 + (double)closest.getPos().getY(), 0.5 + (double)closest.getPos().getZ(), stack);
                                this.world.spawnEntity((Entity)itemEntity);
                                itemEntity.lifespan = 18000;
                                itemEntity.motionX = -0.3 + this.world.rand.nextDouble() * MAX_SPEED;
                                itemEntity.motionY = 0.1 + this.world.rand.nextDouble() * 0.2;
                                itemEntity.motionZ = -0.3 + this.world.rand.nextDouble() * MAX_SPEED;
                            }
                            this.attackTimer = 15;
                            this.world.setEntityState((Entity)this, (byte)4);
                        } else {
                            this.getNavigator().tryMoveToXYZ((double)closest.getPos().getX(), (double)closest.getPos().getY(), (double)closest.getPos().getZ(), 1.0);
                        }
                        return;
                    }
                }
            }
            List droppedItems = this.world.getEntitiesWithinAABB(EntityItem.class, bounds);
            for (EntityItem dropped : droppedItems) {
                if (!(this.getDistanceSq((Entity)dropped) <= 256.0)) continue;
                if (this.getDistanceSq((Entity)dropped) <= 9.0) {
                    if (!this.world.isRemote) {
                        dropped.motionX = -0.3 + this.world.rand.nextDouble() * MAX_SPEED;
                        dropped.motionY = 0.1 + this.world.rand.nextDouble() * 0.2;
                        dropped.motionZ = -0.3 + this.world.rand.nextDouble() * MAX_SPEED;
                    }
                    this.attackTimer = 15;
                    this.world.setEntityState((Entity)this, (byte)4);
                    continue;
                }
                this.getNavigator().tryMoveToXYZ(dropped.posX, dropped.posY, dropped.posZ, 1.0);
            }
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_SPECTRE_DEATH;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_SPECTRE_DEATH;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        IEntityLivingData par1EntityLivingData2 = super.onInitialSpawn(difficulty, par1EntityLivingData);
        this.addPotionEffect(new PotionEffect(MobEffects.INVISIBILITY, Integer.MAX_VALUE));
        return par1EntityLivingData2;
    }
}

