/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class EntityParasyticLouse
extends EntityMob {
    private static final DataParameter<String> EFFECT = EntityDataManager.createKey(EntityParasyticLouse.class, (DataSerializer)DataSerializers.STRING);

    public EntityParasyticLouse(World par1World) {
        super(par1World);
    }

    protected void initEntityAI() {
        super.initEntityAI();
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 10));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, false, null));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(4.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(1.0);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(8.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(EFFECT, (Object)PotionTypes.EMPTY.getRegistryName().toString());
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setString("BitePotionEffect", this.getBitePotionEffect().getRegistryName().toString());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasKey("BitePotionEffect")) {
            this.setBitePotionEffect(PotionType.getPotionTypeForName((String)par1NBTTagCompound.getString("BitePotionEffect")));
        }
    }

    public PotionType getBitePotionEffect() {
        return PotionType.getPotionTypeForName((String)((String)this.dataManager.get(EFFECT)));
    }

    public void setBitePotionEffect(PotionType par1) {
        this.dataManager.set(EFFECT, (Object)par1.getRegistryName().toString());
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_SILVERFISH_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_SILVERFISH_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_SILVERFISH_DEATH;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        if (par1Entity instanceof EntityLivingBase && !this.world.isRemote) {
            EntityLivingBase living = (EntityLivingBase)par1Entity;
            PotionType potionEffect = this.getBitePotionEffect();
            if (potionEffect != PotionTypes.EMPTY) {
                List list2 = potionEffect.getEffects();
                if (!list2.isEmpty()) {
                    PotionEffect effect = new PotionEffect((PotionEffect)list2.get(0));
                    living.addPotionEffect(effect);
                }
                this.setBitePotionEffect(PotionTypes.EMPTY);
            }
        }
        return super.attackEntityAsMob(par1Entity);
    }

    protected void playStepSound(BlockPos pos, Block block) {
        this.playSound(SoundEvents.ENTITY_SILVERFISH_STEP, 0.15f, 1.0f);
    }

    protected Item getDropItem() {
        return Items.AIR;
    }

    public void onUpdate() {
        this.renderYawOffset = this.rotationYaw;
        super.onUpdate();
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.world.isRemote && this.getAttackTarget() != null && !this.hasPath()) {
            this.setAttackTarget(null);
        }
    }

    public float getBlockPathWeight(BlockPos pos) {
        return this.world.getBlockState(pos.down()).getBlock() == Blocks.STONE ? 10.0f : super.getBlockPathWeight(pos);
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    public boolean getCanSpawnHere() {
        if (super.getCanSpawnHere()) {
            EntityPlayer entityplayer = this.world.getClosestPlayerToEntity((Entity)this, 5.0);
            return entityplayer == null;
        }
        return false;
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected boolean processInteract(EntityPlayer player, EnumHand hand) {
        this.setDead();
        if (!this.world.isRemote && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = new ItemStack((Item)WitcheryGeneralItems.PARASYTIC_LOUSE);
            EntityItem item = new EntityItem(this.world, this.posX, 0.4 + this.posY, this.posZ, stack);
            this.world.spawnEntity((Entity)item);
            return true;
        }
        return super.processInteract(player, hand);
    }
}

