/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.rites.WitcheryCurses;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ingredients.IngredientItem;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.SpiritWorldData;

public class EntityNightmare
extends EntityMob {
    private static final DataParameter<Optional<UUID>> VICTIM = EntityDataManager.createKey(EntityNightmare.class, (DataSerializer)DataSerializers.OPTIONAL_UNIQUE_ID);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.createKey(EntityNightmare.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static final DataParameter<Boolean> DEFENDED = EntityDataManager.createKey(EntityNightmare.class, (DataSerializer)DataSerializers.BOOLEAN);
    private int attackTimer;
    private int defenseTimer;

    public EntityNightmare(World par1World) {
        super(par1World);
        this.isImmuneToFire = true;
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, entity -> this.getVictimId() == null || entity != null && entity.getUniqueID().equals(this.getVictimId())));
        this.experienceValue = 25;
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(VICTIM, (Object)Optional.absent());
        this.dataManager.register(SCREAMING, (Object)false);
        this.dataManager.register(DEFENDED, (Object)false);
    }

    public void setInWeb() {
    }

    public void fall(float distance, float damageMultiplier) {
    }

    public boolean isScreaming() {
        return (Boolean)this.dataManager.get(SCREAMING);
    }

    public void setScreaming(boolean par1) {
        this.dataManager.set(SCREAMING, (Object)par1);
    }

    public boolean isDefended() {
        return (Boolean)this.dataManager.get(DEFENDED);
    }

    public void setDefended(boolean par1) {
        this.dataManager.set(DEFENDED, (Object)par1);
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (!this.world.isRemote && this.isEntityAlive()) {
            this.setScreaming(this.getAttackTarget() != null);
        }
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(100.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
        this.getEntityAttribute(SharedMonsterAttributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        UUID victimId = this.getVictimId();
        if (victimId != null) {
            par1NBTTagCompound.setUniqueId("Victim", victimId);
        }
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasUniqueId("Victim")) {
            this.setVictimId(par1NBTTagCompound.getUniqueId("Victim"));
        }
    }

    public UUID getVictimId() {
        return (UUID)((Optional)this.dataManager.get(VICTIM)).orNull();
    }

    public void setVictimId(UUID victim) {
        this.dataManager.set(VICTIM, (Object)Optional.fromNullable((Object)victim));
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.world.isRemote) {
            if (this.defenseTimer > 0 && --this.defenseTimer == 0) {
                this.setDefended(false);
            }
            if (!this.isDead && this.getVictimId() != null && this.getAttackTarget() != null && (this.getAttackTarget().isDead || this.getDistanceSq((Entity)this.getAttackTarget()) > 256.0) || this.world.rand.nextInt(5) == 0 && this.getAttackTarget() instanceof EntityPlayer && WitcheryUtils.getExtension((EntityPlayer)this.getAttackTarget()).getSpiritData().getNightmareLevel() == SpiritWorldData.NightmareLevel.DREAM && !this.isWakingNightmare((EntityPlayer)this.getAttackTarget())) {
                this.world.setEntityState((Entity)this, (byte)5);
                this.setDead();
            }
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    private boolean isWakingNightmare(EntityPlayer player) {
        int level = WitcheryDataExtensions.LIVING.get((EntityLivingBase)player).getCurses().getInt((Object)WitcheryCurses.getWakingNightmare());
        if (level > 0) {
            return true;
        }
        return player.isPotionActive(WitcheryPotionEffects.WAKING_NIGHTMARE);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 15;
        } else if (par1 == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(par1);
        }
    }

    public boolean attackEntityAsMob(Entity entity) {
        boolean flag;
        this.attackTimer = 15;
        this.world.setEntityState((Entity)this, (byte)4);
        if (entity instanceof EntityPlayer) {
            int index;
            EntityPlayer player = (EntityPlayer)entity;
            if (IngredientItem.getItemSlotFromInventory(player.inventory, WitcheryIngredientItems.DISRUPTED_DREAMS_CHARM) == -1 && !((ItemStack)player.inventory.armorInventory.get(index = player.world.rand.nextInt(player.inventory.armorInventory.size()))).isEmpty()) {
                Infusion.dropEntityItemWithRandomChoice((EntityLivingBase)player, (ItemStack)player.inventory.armorInventory.get(index), true);
                player.inventory.armorInventory.set(index, (Object)ItemStack.EMPTY);
            }
        }
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue();
        if (!WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
            f = 0.5f;
        }
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getModifierForCreature((ItemStack)this.getHeldItemMainhand(), (EnumCreatureAttribute)((EntityLivingBase)entity).getCreatureAttribute());
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this);
        }
        if (flag = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                entity.setFire(j * 4);
            }
        }
        return flag;
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        EntityLivingBase living;
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, source, damage)) {
            return super.attackEntityFrom(source, damage);
        }
        if (this.isDefended()) {
            return false;
        }
        boolean weakeningWeapon = false;
        if (source instanceof EntityDamageSource && source.getTrueSource() != null && source.getTrueSource() instanceof EntityLivingBase && !(living = (EntityLivingBase)source.getTrueSource()).getHeldItemMainhand().isEmpty() && living.getHeldItemMainhand().getItem() == WitcheryGeneralItems.HUNTSMANS_SPEAR) {
            weakeningWeapon = true;
        }
        if (!this.world.isRemote && this.world.getBlockState(this.getPosition()).getBlock() != WitcheryBlocks.FLOWING_SPIRIT) {
            this.defenseTimer = WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this) ? (weakeningWeapon ? 40 : 80) : (weakeningWeapon ? 30 : 40);
            this.setDefended(true);
        }
        return super.attackEntityFrom(source, Math.min(damage, 15.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_NIGHTMARE_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_NIGHTMARE_DEATH;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_NIGHTMARE_HURT;
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
            int chance = this.rand.nextInt(Math.max(10 - par2, 5));
            int quantity = par2 > 0 && chance == 0 ? 2 : 1;
            this.entityDropItem(new ItemStack(WitcheryFumeItems.MELLIFLUOUS_HUNGER, quantity), 0.0f);
        }
    }

    public void onDeath(DamageSource source) {
        if (!this.world.isRemote && source.getTrueSource() != null && source.getTrueSource() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.getTrueSource();
            UUID victim = this.getVictimId();
            if (victim != null && player.getUniqueID().equals(victim) && WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
                WitcheryUtils.getExtension(player).getSpiritData().setLastNightmareKill(this.world.getTotalWorldTime());
            }
        }
        super.onDeath(source);
    }

    protected boolean canDespawn() {
        return true;
    }
}

