/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.rite.effect.RiteEffectProtectionCircleRepulsive;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityMorsmordre
extends EntityLiving {
    private long ticksAlive = 0L;

    public EntityMorsmordre(World world) {
        super(world);
        this.isImmuneToFire = true;
        this.tasks.addTask(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    protected float getSoundPitch() {
        return 1.0f;
    }

    public int getTalkInterval() {
        return 80;
    }

    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_TORMENT_LAUGH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent getDeathSound() {
        return null;
    }

    public boolean canBePushed() {
        return false;
    }

    protected void collideWithEntity(Entity par1Entity) {
    }

    protected void collideWithNearbyEntities() {
    }

    public void onLivingUpdate() {
        long ticksAlive;
        super.onLivingUpdate();
        long n = this.ticksExisted;
        this.ticksAlive = ticksAlive = this.ticksAlive + 1L;
        this.ticksAlive = Math.max(n, ticksAlive);
        if (this.ticksAlive > 6000L) {
            if (!this.world.isRemote) {
                this.setDead();
            }
        } else if (this.world.isRemote && this.ticksAlive % 4L == 0L) {
            double radius = 10.0;
            AxisAlignedBB bounds = new AxisAlignedBB(this.posX - radius, 1.0, this.posZ - radius, this.posX + radius, 255.0, this.posZ + radius);
            List list2 = this.world.getEntitiesWithinAABB(EntityCreature.class, bounds);
            for (Entity entity : list2) {
                if (!(entity.getDistance(this.posX, 1.0, this.posZ) <= 10.0)) continue;
                RiteEffectProtectionCircleRepulsive.push(entity, new BlockPos(this.posX, entity.posY, this.posZ));
            }
        }
    }

    public void onUpdate() {
        super.onUpdate();
        this.motionY = 0.0;
        if (this.world.isRemote) {
            for (int i = 0; i < 5; ++i) {
                this.world.spawnParticle(EnumParticleTypes.SMOKE_LARGE, this.posX - 1.4 + this.world.rand.nextDouble() * 2.8, this.posY + this.world.rand.nextDouble() * 2.0, this.posZ - 1.4 + this.world.rand.nextDouble() * 2.8, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected void dropFewItems(boolean par1, int par2) {
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    protected void updateFallState(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean doesEntityNotTriggerPressurePlate() {
        return true;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, par1DamageSource, par2)) {
            return super.attackEntityFrom(par1DamageSource, par2);
        }
        return false;
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.ticksAlive = nbtRoot.getLong("WitcheryTicksAlive");
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setLong("WitcheryTicksAlive", this.ticksAlive);
    }
}

