/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.BlockUtil;

public class EntityMindrake
extends EntityTameable {
    public EntityMindrake(World world) {
        super(world);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityPlayer.class, true, null));
        this.experienceValue = 0;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(4.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.4);
    }

    public int getMaxFallHeight() {
        return this.getAttackTarget() == null ? 3 : 3 + (int)(this.getHealth() - 1.0f);
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_GHAST_SCREAM;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_GHAST_DEATH;
    }

    public boolean attackEntityAsMob(Entity entity) {
        if (!this.world.isRemote) {
            this.world.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 1.5f, false);
            this.setDead();
            IBlockState block = BlockUtil.getBlock(this.world, this.posX, this.getEntityBoundingBox().minY - 1.0, this.posZ);
            if (block.getMaterial() == Material.GRASS || block.getMaterial() == Material.GROUND) {
                BlockUtil.setBlock(this.world, this.posX, this.getEntityBoundingBox().minY, this.posZ, (Block)(this.rand.nextBoolean() ? Blocks.RED_FLOWER : Blocks.YELLOW_FLOWER));
            }
        }
        return true;
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (!this.world.isRemote) {
            this.world.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 1.0f, false);
        }
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.entityDropItem(new ItemStack((Block)WitcheryBlocks.MANDRAKE_SEEDS, this.world.rand.nextDouble() <= 0.25 ? 2 : 1), 0.0f);
    }

    public EntityAgeable createChild(EntityAgeable var1) {
        return null;
    }
}

