/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntitySpirit;
import net.msrandom.witchery.entity.ai.EntityAIFlyerAttackOnCollide;
import net.msrandom.witchery.entity.ai.EntityAIFlyerLand;
import net.msrandom.witchery.entity.ai.EntityAISitAndStay;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityLostSoul
extends EntitySpirit {
    private static final DataParameter<Integer> TYPE = EntityDataManager.createKey(EntityLostSoul.class, (DataSerializer)DataSerializers.VARINT);
    private int timeToLive = -1;

    public EntityLostSoul(World world) {
        super(world);
        this.tasks.taskEntries.clear();
        this.targetTasks.taskEntries.clear();
        this.tasks.addTask(1, (EntityAIBase)new EntityAISitAndStay(this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIFlyerAttackOnCollide((EntityCreature)this, 1.0, true));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, true));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 0.2f));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    public void setTimeToLive(int i) {
        this.timeToLive = i;
    }

    public boolean isTemp() {
        return this.timeToLive != -1;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("FeatherColor", this.getFeatherColor());
        par1NBTTagCompound.setByte("SoulType", (byte)this.getSoulType());
        par1NBTTagCompound.setInteger("SuicideIn", this.timeToLive);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasKey("FeatherColor")) {
            this.setFeatherColor(par1NBTTagCompound.getInteger("FeatherColor"));
        }
        if (par1NBTTagCompound.hasKey("SoulType")) {
            this.setSoulType(par1NBTTagCompound.getByte("SoulType"));
        }
        this.timeToLive = par1NBTTagCompound.hasKey("SuicideIn") ? par1NBTTagCompound.getInteger("SuicideIn") : -1;
    }

    public void setInWeb() {
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(TYPE, (Object)this.world.rand.nextInt(3));
        switch (this.getSoulType()) {
            case 0: {
                this.setFeatherColor(0xFF0000);
                break;
            }
            case 1: {
                this.setFeatherColor(65280);
                break;
            }
            case 2: {
                this.setFeatherColor(255);
            }
        }
    }

    public int getSoulType() {
        return (Integer)this.dataManager.get(TYPE);
    }

    public void setSoulType(int par1) {
        this.dataManager.set(TYPE, (Object)par1);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.4);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(2.0);
    }

    public boolean attackEntityAsMob(Entity targetEntity) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue();
        int i = 0;
        if (targetEntity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getModifierForCreature((ItemStack)this.getHeldItemMainhand(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).getCreatureAttribute());
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this);
        }
        DamageSource source = null;
        if (this.world.rand.nextInt(4) == 0) {
            switch (this.getSoulType()) {
                case 0: {
                    source = DamageSource.IN_FIRE;
                    break;
                }
                case 1: {
                    source = DamageSource.causeMobDamage((EntityLivingBase)this);
                    break;
                }
                case 2: {
                    source = DamageSource.MAGIC;
                }
            }
        }
        if (source == null) {
            source = DamageSource.causeMobDamage((EntityLivingBase)this);
        }
        if (flag = targetEntity.attackEntityFrom(source, f)) {
            int j;
            if (i > 0) {
                targetEntity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                targetEntity.setFire(j * 4);
            }
            if (targetEntity instanceof EntityLivingBase) {
                EnchantmentHelper.applyThornEnchantments((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
            }
            EnchantmentHelper.applyArthropodEnchantments((EntityLivingBase)this, (Entity)targetEntity);
        }
        return flag;
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, source, damage)) {
            return super.attackEntityFrom(source, damage);
        }
        float MAX_DAMAGE = 15.0f;
        switch (this.getSoulType()) {
            case 0: {
                if (!source.isFireDamage() && !source.isExplosion()) break;
                return super.attackEntityFrom(source, Math.min(damage, MAX_DAMAGE));
            }
            case 1: {
                if (source.isProjectile() || source.isMagicDamage() || source.isFireDamage() || source.isExplosion() || source == DamageSource.IN_WALL || source == DamageSource.CACTUS || source == DamageSource.DROWN || source == DamageSource.WITHER) break;
                return super.attackEntityFrom(source, Math.min(damage, MAX_DAMAGE));
            }
            case 2: {
                if (!source.isMagicDamage()) break;
                return super.attackEntityFrom(source, Math.min(damage, MAX_DAMAGE));
            }
        }
        return false;
    }

    @Override
    protected void updateAITasks() {
        super.updateAITasks();
        if (!this.world.isRemote && this.timeToLive != -1 && --this.timeToLive <= 0) {
            this.setDead();
        }
    }
}

