/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityFlyingMob;
import net.msrandom.witchery.entity.EntitySoulfire;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.entity.ai.EntityAIFlyerArrowAttack;
import net.msrandom.witchery.entity.ai.EntityAIFlyerLand;
import net.msrandom.witchery.entity.ai.EntityAIFlyerWander;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcherySymbolEffects;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.util.damage.DemonicDamageSource;
import net.msrandom.witchery.world.dimension.torment.TormentWorldData;
import net.msrandom.witchery.world.dimension.torment.WorldProviderTorment;

public class EntityLordOfTorment
extends EntityFlyingMob
implements IRangedAttackMob,
IHandleDeathTouch {
    private final Set<UUID> attackers = new HashSet<UUID>();
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.getDisplayName(), BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_10).setDarkenSky(true);
    private int attackTimer;

    public EntityLordOfTorment(World world) {
        super(world);
        this.isImmuneToFire = true;
        this.experienceValue = 50;
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.experienceValue = 80;
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIFlyerArrowAttack(this, 1.0, 20, 60, 12.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIFlyerWander((EntityLiving)this, 10.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(500.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.2);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(8.0);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(50.0);
    }

    protected void updateAITasks() {
        super.updateAITasks();
        this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
    }

    public void addTrackingPlayer(EntityPlayerMP player) {
        super.addTrackingPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void removeTrackingPlayer(EntityPlayerMP player) {
        super.removeTrackingPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean isNonBoss() {
        return false;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.world.isRemote) {
            this.world.spawnParticle(EnumParticleTypes.FLAME, this.posX - (double)this.width * 0.5 + this.world.rand.nextDouble() * (double)this.width, 0.1 + this.posY + this.world.rand.nextDouble() * 2.0, this.posZ - (double)this.width * 0.5 + this.world.rand.nextDouble() * (double)this.width, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    protected boolean canDespawn() {
        return false;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.world.rand.nextDouble() < 0.05 && this.getAttackTarget() != null && this.getAttackTarget() instanceof EntityPlayer && ((EntityPlayer)this.getAttackTarget()).capabilities.isFlying && !this.getAttackTarget().isPotionActive(MobEffects.SLOWNESS)) {
            this.getAttackTarget().addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 200, 5));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte state) {
        if (state == 4) {
            this.attackTimer = 10;
            this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        } else {
            super.handleStatusUpdate(state);
        }
    }

    public boolean attackEntityAsMob(Entity target) {
        this.attackTimer = 10;
        this.world.setEntityState((Entity)this, (byte)4);
        boolean flag = target.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)(7 + this.rand.nextInt(15)));
        if (flag) {
            target.motionY += (double)0.4f;
        }
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness() {
        return 1.0f;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        if (nbtRoot.hasKey("Attackers")) {
            NBTTagList nbtAttackers = nbtRoot.getTagList("Attackers", 8);
            for (int i = 0; i < nbtAttackers.tagCount(); ++i) {
                String attacker = nbtAttackers.getStringTagAt(i);
                this.attackers.add(UUID.fromString(attacker));
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        NBTTagList nbtAttackers = new NBTTagList();
        for (UUID attacker : this.attackers) {
            nbtAttackers.appendTag((NBTBase)new NBTTagString(attacker.toString()));
        }
        nbtRoot.setTag("Attackers", (NBTBase)nbtAttackers);
        return nbtRoot;
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, source, damage)) {
            return super.attackEntityFrom(source, damage);
        }
        if (source.isExplosion()) {
            return false;
        }
        if (source.getImmediateSource() != null && source.getImmediateSource() instanceof EntityPlayer) {
            EntityPlayer attacker = (EntityPlayer)source.getImmediateSource();
            this.attackers.add(attacker.getUniqueID());
        }
        float damageCap = source instanceof DemonicDamageSource ? 8.0f : 5.0f;
        boolean damaged = super.attackEntityFrom(source, Math.min(damage, damageCap));
        if (!WitcheryDimensions.TORMENT.isInDimension((Entity)this) && this.getHealth() <= this.getMaxHealth() * 0.5f) {
            if (!this.world.isRemote) {
                int tormentlevel = WorldProviderTorment.getRandomTormentLevel(this.world);
                double R = 16.0;
                double Ry = 32.0;
                AxisAlignedBB bb = new AxisAlignedBB(this.posX - R, this.posY - Ry, this.posZ - R, this.posX + R, this.posY + Ry, this.posZ + R);
                List players = this.world.getEntitiesWithinAABB(EntityPlayer.class, bb);
                for (EntityPlayer otherPlayer : players) {
                    WorldProviderTorment.setPlayerMustTorment(otherPlayer, TormentWorldData.TormentType.BOSS, tormentlevel);
                }
                for (UUID player : this.attackers) {
                    EntityPlayer otherPlayer = WitcheryUtils.getPlayer(this.world, player);
                    if (otherPlayer == null || otherPlayer.dimension != this.dimension) continue;
                    WorldProviderTorment.setPlayerMustTorment(otherPlayer, TormentWorldData.TormentType.BOSS, tormentlevel);
                }
                this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                this.setDead();
            }
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        return damaged;
    }

    @Override
    public float getCapDT(DamageSource source) {
        return 5.0f;
    }

    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_TORMENT_LAUGH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_TORMENT_HURT;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_TORMENT_DEATH;
    }

    public int getTalkInterval() {
        return 200;
    }

    protected Item getDropItem() {
        return Items.AIR;
    }

    protected void dropFewItems(boolean par1, int par2) {
        Enchantment enchantment = (Enchantment)Enchantment.REGISTRY.getRandomObject(this.rand);
        int k = MathHelper.getInt((Random)this.rand, (int)Math.min(enchantment.getMinLevel() + 3, enchantment.getMaxLevel()), (int)enchantment.getMaxLevel());
        ItemStack itemstack = ItemEnchantedBook.getEnchantedItemStack((EnchantmentData)new EnchantmentData(enchantment, k));
        this.entityDropItem(itemstack, 0.0f);
        Enchantment enchantment2 = (Enchantment)Enchantment.REGISTRY.getRandomObject(this.rand);
        int k2 = MathHelper.getInt((Random)this.rand, (int)Math.min(enchantment2.getMinLevel() + 1, enchantment.getMaxLevel()), (int)enchantment.getMaxLevel());
        ItemStack itemstack2 = ItemEnchantedBook.getEnchantedItemStack((EnchantmentData)new EnchantmentData(enchantment2, k2));
        this.entityDropItem(itemstack2, 0.0f);
        this.entityDropItem(new ItemStack((Block)WitcheryBlocks.DEMON_HEART), 0.0f);
        this.entityDropItem(new ItemStack((Item)WitcheryBrewItems.SOUL_TORMENT_BREW), 0.0f);
    }

    protected float getSoundVolume() {
        return 2.0f;
    }

    public boolean getCanSpawnHere() {
        return true;
    }

    public int getMaxSpawnedInChunk() {
        return 1;
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    public void attackEntityWithRangedAttack(EntityLivingBase targetEntity, float par2) {
        this.attackTimer = 10;
        this.world.setEntityState((Entity)this, (byte)4);
        double d0 = targetEntity.posX - this.posX;
        double d2 = targetEntity.getEntityBoundingBox().minY + (double)(targetEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
        double d3 = targetEntity.posZ - this.posZ;
        float f1 = MathHelper.sqrt((float)par2) * 0.5f;
        if (!this.world.isRemote) {
            this.world.playEvent(1009, this.getPosition(), 0);
            int count = this.rand.nextInt(10) == 0 ? 9 : 3;
            EntitySpellEffect effect = new EntitySpellEffect(this.world, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d2, d3 + this.rand.nextGaussian() * (double)f1, WitcherySymbolEffects.IGNIANIMA, 1);
            effect.posX = this.posX;
            effect.posY = this.posY + (double)(this.height / 2.0f);
            effect.posZ = this.posZ;
            this.world.spawnEntity((Entity)effect);
            for (int i = 0; i < count; ++i) {
                EntitySoulfire fireballEntity = new EntitySoulfire(this.world, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d2, d3 + this.rand.nextGaussian() * (double)f1);
                fireballEntity.posX = this.posX;
                fireballEntity.posY = this.posY + (double)(this.height / 2.0f) + 0.5;
                fireballEntity.posZ = this.posZ;
                this.world.spawnEntity((Entity)fireballEntity);
            }
        }
    }

    public void setSwingingArms(boolean b) {
    }
}

