/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.collections.CollectionsKt;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.msrandom.witchery.WitcheryResurrectedClient;
import net.msrandom.witchery.entity.EntityLostSoul;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.symbol.ConfudusSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ExpelliarmusSymbolEffect;
import net.msrandom.witchery.infusion.symbol.FlipendoSymbolEffect;
import net.msrandom.witchery.infusion.symbol.IgnianimaSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ImpedimentaSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcherySymbolEffects;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.BlockActionSphere;
import net.msrandom.witchery.util.ElementWeight;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WeightedElement;
import net.msrandom.witchery.util.WeightedElementKt;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityLeonard
extends EntityMob
implements IRangedAttackMob,
IHandleDeathTouch {
    public static final List<WeightedElement<ProjectileSymbolEffect>> SPELLS = WeightedElementKt.toWeightedList(CollectionsKt.listOf((Object[])new ElementWeight[]{new ElementWeight<IgnianimaSymbolEffect>(14, WitcherySymbolEffects.IGNIANIMA), new ElementWeight<ExpelliarmusSymbolEffect>(2, WitcherySymbolEffects.EXPELLIARMUS), new ElementWeight<FlipendoSymbolEffect>(2, WitcherySymbolEffects.FLIPENDO), new ElementWeight<ImpedimentaSymbolEffect>(2, WitcherySymbolEffects.IMPEDIMENTA), new ElementWeight<ConfudusSymbolEffect>(2, WitcherySymbolEffects.CONFUNDUS)}));
    private static final DataParameter<Boolean> PLAYER_CREATED = EntityDataManager.createKey(EntityLeonard.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static final DataParameter<Integer> INVULNERABLE = EntityDataManager.createKey(EntityLeonard.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Integer> LIFE_TIME = EntityDataManager.createKey(EntityLeonard.class, (DataSerializer)DataSerializers.VARINT);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.getDisplayName(), BossInfo.Color.YELLOW, BossInfo.Overlay.NOTCHED_12).setDarkenSky(true);
    private int attackTimer;
    private boolean isImmune;
    private int spawnDelay;

    public EntityLeonard(World world) {
        super(world);
        this.isImmuneToFire = true;
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 20, 30.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.experienceValue = 100;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(PLAYER_CREATED, (Object)false);
        this.dataManager.register(INVULNERABLE, (Object)0);
        this.dataManager.register(LIFE_TIME, (Object)0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(600.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
    }

    public void addTrackingPlayer(EntityPlayerMP player) {
        super.addTrackingPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void removeTrackingPlayer(EntityPlayerMP player) {
        super.removeTrackingPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean isNonBoss() {
        return false;
    }

    public int getTotalArmorValue() {
        return 0;
    }

    public void setInWeb() {
    }

    public int getInvulnerableStartTicks() {
        return (Integer)this.dataManager.get(INVULNERABLE);
    }

    public void setInvulnerableStartTicks(int par1) {
        this.dataManager.set(INVULNERABLE, (Object)par1);
    }

    public int getLifetime() {
        return (Integer)this.dataManager.get(LIFE_TIME);
    }

    public void setLifetime(int par1) {
        this.dataManager.set(LIFE_TIME, (Object)par1);
    }

    public void setInvulnerableStart() {
        this.setInvulnerableStartTicks(150);
        this.setHealth(this.getMaxHealth() / 4.0f);
    }

    protected void updateAITasks() {
        if (this.getInvulnerableStartTicks() > 0) {
            int i = this.getInvulnerableStartTicks() - 1;
            if (i <= 0) {
                this.world.playBroadcastSound(1013, this.getPosition(), 0);
            }
            this.setInvulnerableStartTicks(i);
            if (this.ticksExisted % 10 == 0) {
                this.heal(this.getMaxHealth() * 0.75f / 15.0f);
            }
        } else {
            super.updateAITasks();
            this.setLifetime(this.getLifetime() + 1);
            if (this.ticksExisted % 20 == 0) {
                this.heal(1.0f);
            }
            if (this.ticksExisted % 20 == 0 && this.world.rand.nextInt(5) == 0 && !this.world.isRemote) {
                EntityPlayer player2;
                int R = 40;
                double RY = 40.0;
                double RSQ = 1600.0;
                AxisAlignedBB bounds = new AxisAlignedBB(this.posX - (double)R, this.posY - RY, this.posZ - (double)R, this.posX + (double)R, this.posY + RY, this.posZ + (double)R);
                List players = this.world.getEntitiesWithinAABB(EntityPlayer.class, bounds);
                boolean hexed = false;
                for (EntityPlayer player : players) {
                    if (!(this.getDistanceSq(player.posX, this.posY, player.posZ) <= RSQ) || player.isDead || !(player.getHealth() > 0.0f) || player.isPotionActive(WitcheryPotionEffects.MORTAL_COIL)) continue;
                    hexed = true;
                    player.playSound(SoundEvents.BLOCK_FIRE_EXTINGUISH, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)5);
                    player.addPotionEffect(new PotionEffect(WitcheryPotionEffects.MORTAL_COIL, 1800));
                }
                if (hexed) {
                    this.playSound(SoundEvents.BLOCK_NOTE_HARP, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)6);
                } else if (this.world.rand.nextInt(5) == 1 && players.size() > 0 && (player2 = (EntityPlayer)players.get(this.world.rand.nextInt(players.size()))) != null && this.getDistanceSq(player2.posX, this.posY, player2.posZ) <= 1600.0 && !player2.isDead && player2.getHealth() > 0.0f) {
                    player2.playSound(SoundEvents.BLOCK_FIRE_EXTINGUISH, 0.5f, 0.4f / (player2.world.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)5);
                    switch (this.world.rand.nextInt(10)) {
                        case 0: 
                        case 1: 
                        case 2: {
                            ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
                            Collection effects2 = player2.getActivePotionEffects();
                            for (PotionEffect effect : effects2) {
                                Potion potion = effect.getPotion();
                                if (WitcheryPotion.isDebuff(potion) || !WitcheryPotion.isCurable(potion)) continue;
                                effectsToRemove.add(potion);
                            }
                            for (Potion potion2 : effectsToRemove) {
                                player2.removePotionEffect(potion2);
                            }
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            player2.addPotionEffect(new PotionEffect(WitcheryPotionEffects.SINKING, 1200, 3));
                            this.playSound(SoundEvents.BLOCK_NOTE_HARP, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                            this.world.setEntityState((Entity)this, (byte)6);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            player2.addPotionEffect(new PotionEffect(WitcheryPotionEffects.INSANITY, 1200, 3));
                            this.playSound(SoundEvents.BLOCK_NOTE_HARP, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                            this.world.setEntityState((Entity)this, (byte)6);
                            break;
                        }
                        case 9: {
                            player2.addPotionEffect(new PotionEffect(WitcheryPotionEffects.OVERHEATING, 1200, 3));
                            this.playSound(SoundEvents.BLOCK_NOTE_HARP, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                            this.world.setEntityState((Entity)this, (byte)6);
                        }
                    }
                }
            }
            if (this.ticksExisted % 20 == 2) {
                if (this.world.rand.nextInt(5) == 0) {
                    new BlockActionSphere(){

                        @Override
                        protected void onBlock(World world, BlockPos pos) {
                            Block block = world.getBlockState(pos).getBlock();
                            if (block == WitcheryBlocks.BREW_GAS || block == WitcheryBlocks.BREW_LIQUID) {
                                world.setBlockState(pos, Blocks.FIRE.getDefaultState());
                            }
                        }
                    }.drawFilledSphere(this.world, this.getPosition().up(2), 4);
                }
                if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.5) {
                    if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.25 && this.world.rand.nextInt(3) == 1 && !this.isPotionActive(WitcheryPotionEffects.RESIZING)) {
                        this.addPotionEffect(new PotionEffect(WitcheryPotionEffects.RESIZING, 1200, 3));
                    }
                    int SPAWN_DELAY = 10;
                    int R = 15;
                    double RY = 5.0;
                    double RSQ = 225.0;
                    AxisAlignedBB bounds2 = new AxisAlignedBB(this.posX - (double)R, this.posY - RY, this.posZ - (double)R, this.posX + (double)R, this.posY + RY, this.posZ + (double)R);
                    List souls = this.world.getEntitiesWithinAABB(EntityLostSoul.class, bounds2);
                    if (souls.size() == 0) {
                        this.isImmune = false;
                        if (--this.spawnDelay <= 0) {
                            EntityLostSoul soul;
                            int j;
                            this.removeCoilEffects(15, RY);
                            this.spawnDelay = SPAWN_DELAY;
                            int spawned = 0;
                            for (j = 0; j < 4 + this.world.rand.nextInt(2); ++j) {
                                soul = (EntityLostSoul)Infusion.spawnCreature(this.world, EntityLostSoul.class, this.getPosition().up(), null, 1, 4, EnumParticleTypes.SMOKE_NORMAL, SoundEvents.ENTITY_ITEM_PICKUP);
                                if (soul == null) continue;
                                soul.setTimeToLive(60 + this.world.rand.nextInt(30) * 20);
                                ++spawned;
                            }
                            for (j = spawned; j < 3; ++j) {
                                soul = (EntityLostSoul)Infusion.spawnCreature(this.world, EntityLostSoul.class, this.getPosition().up(), null, 0, 0, EnumParticleTypes.SMOKE_NORMAL, SoundEvents.ENTITY_ITEM_PICKUP);
                                if (soul == null) continue;
                                soul.setTimeToLive((60 + this.world.rand.nextInt(30)) * 20);
                            }
                        }
                    } else {
                        this.isImmune = true;
                    }
                } else {
                    this.isImmune = false;
                }
            }
        }
        this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
    }

    public void onDeath(DamageSource source) {
        super.onDeath(source);
        this.removeCoilEffects(40, 40.0);
    }

    private void removeCoilEffects(int R, double RY) {
        AxisAlignedBB bounds2 = new AxisAlignedBB(this.posX - (double)R, this.posY - RY, this.posZ - (double)R, this.posX + (double)R, this.posY + RY, this.posZ + (double)R);
        List players = this.world.getEntitiesWithinAABB(EntityPlayer.class, bounds2);
        for (EntityPlayer player : players) {
            if (player.isDead || !(player.getHealth() > 0.0f) || !player.isPotionActive(WitcheryPotionEffects.MORTAL_COIL)) continue;
            player.removePotionEffect(WitcheryPotionEffects.MORTAL_COIL);
            WitcheryUtils.getExtension(player).clearCachedIncurablePotionEffect(WitcheryPotionEffects.MORTAL_COIL);
        }
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, source, damage)) {
            return super.attackEntityFrom(source, damage);
        }
        if (this.isImmune) {
            return false;
        }
        if (!source.getDamageType().equals("player")) {
            return false;
        }
        if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.25) {
            boolean isLarge = this.isPotionActive(WitcheryPotionEffects.RESIZING) && this.getActivePotionEffect(WitcheryPotionEffects.RESIZING).getAmplifier() >= 2;
            return super.attackEntityFrom(source, Math.min(damage, isLarge ? 1.0f : 4.0f));
        }
        return super.attackEntityFrom(source, Math.min(damage, 12.0f));
    }

    @Override
    public float getCapDT(DamageSource source) {
        return this.isImmune || !source.getDamageType().equals("player") ? 0.0f : 2.0f;
    }

    public void attackEntityFromWeakness(int damage) {
        if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.4) {
            boolean isLarge = this.isPotionActive(WitcheryPotionEffects.RESIZING) && this.getActivePotionEffect(WitcheryPotionEffects.RESIZING).getAmplifier() >= 2;
            super.attackEntityFrom(DamageSource.MAGIC, Math.min((float)damage, isLarge ? 8.0f : 15.0f));
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("PlayerCreated", this.isPlayerCreated());
        par1NBTTagCompound.setInteger("Invul", this.getInvulnerableStartTicks());
        par1NBTTagCompound.setLong("Lifetime", (long)this.getLifetime());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setPlayerCreated(par1NBTTagCompound.getBoolean("PlayerCreated"));
        this.setInvulnerableStartTicks(par1NBTTagCompound.getInteger("Invul"));
        this.setLifetime(par1NBTTagCompound.getInteger("Lifetime"));
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        this.world.setEntityState((Entity)this, (byte)4);
        boolean flag = par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)(7 + this.rand.nextInt(15)));
        if (flag) {
            par1Entity.motionY += (double)0.4f;
        }
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        return flag;
    }

    public void handleStatusUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        } else if (par1 == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (par1 == 6) {
            for (int i = 0; i < 20; ++i) {
                WitcheryResurrectedClient.INSTANCE.addColoredSmokeParticle(this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, 0xFFFFFF);
            }
        } else {
            super.handleStatusUpdate(par1);
        }
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness() {
        return 1.0f;
    }

    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_LEONARD_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_LEONARD_HURT;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_LEONARD_DEATH;
    }

    protected void dropFewItems(boolean par1, int par2) {
        Enchantment enchantment = (Enchantment)Enchantment.REGISTRY.getRandomObject(this.rand);
        int k = MathHelper.getInt((Random)this.rand, (int)Math.min(enchantment.getMinLevel() + 2, enchantment.getMaxLevel()), (int)enchantment.getMaxLevel());
        ItemStack itemstack = ItemEnchantedBook.getEnchantedItemStack((EnchantmentData)new EnchantmentData(enchantment, k));
        this.entityDropItem(itemstack, 0.0f);
        this.entityDropItem(new ItemStack((Block)WitcheryBlocks.DEMON_HEART), 0.0f);
        this.entityDropItem(new ItemStack((Item)WitcheryGeneralItems.LEONARDS_URNS.get(0)), 0.0f);
    }

    protected Item getDropItem() {
        return null;
    }

    public boolean isPlayerCreated() {
        return (Boolean)this.dataManager.get(PLAYER_CREATED);
    }

    public void setPlayerCreated(boolean par1) {
        this.enablePersistence();
        this.dataManager.set(PLAYER_CREATED, (Object)par1);
    }

    protected boolean canDespawn() {
        return false;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase targetEntity, float par2) {
        if (this.world.rand.nextBoolean()) {
            this.attackTimer = 10;
            this.world.setEntityState((Entity)this, (byte)4);
            double d0 = targetEntity.posX - this.posX;
            double d2 = targetEntity.getEntityBoundingBox().minY + (double)(targetEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
            double d3 = targetEntity.posZ - this.posZ;
            float f1 = MathHelper.sqrt((float)par2) * 0.5f;
            if (!this.world.isRemote) {
                this.world.playEvent(1009, this.getPosition(), 0);
                EntitySpellEffect effect = new EntitySpellEffect(this.world, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d2, d3 + this.rand.nextGaussian() * (double)f1, WeightedElementKt.getWeighted(SPELLS, this.rand), 1);
                effect.posX = this.posX;
                effect.posY = this.posY + (double)(this.height / 2.0f);
                effect.posZ = this.posZ;
                this.world.spawnEntity((Entity)effect);
            }
        }
    }

    public void setSwingingArms(boolean b) {
    }
}

