/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.ai.EntityAIWanderWithRestriction;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.init.items.WitcheryContractItems;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.contracts.ItemActivatableContract;

public class EntityImp
extends EntityTameable
implements IMob {
    private static final DataParameter<Integer> AFFECTION = EntityDataManager.createKey(EntityImp.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.createKey(EntityImp.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static final HashMap<Item, Integer> shinies = new HashMap();
    private static final int REWARD_AFFECTION_LEVEL = 20;
    private static final long GIFT_DELAY_TICKS = 3600L;
    private static final ItemStack[] EXTRA_DROPS = new ItemStack[]{new ItemStack(WitcheryIngredientItems.BAT_WOOL, 5), new ItemStack(WitcheryIngredientItems.DOG_TONGUE, 5), new ItemStack(WitcheryIngredientItems.FROG_TOE, 2), new ItemStack(WitcheryIngredientItems.OWLETS_WING, 2), new ItemStack(WitcheryIngredientItems.ENT_TWIG, 1), new ItemStack(WitcheryFumeItems.DEMONIC_BLOOD, 2), new ItemStack(WitcheryIngredientItems.CREEPER_HEART, 2)};
    private static final String[] DEMON_NAMES = new String[]{"Ppaironael", "Aethon", "Tyrnak", "Beelzebuth", "Botis", "Moloch", "Taet", "Epnanaet", "Unonom", "Hexpemsazon", "Thayax", "Ethahoat", "Pruslas", "Ahtuxies", "Laripael", "Elxar", "Tarihimal", "Sapanolr", "Sahaminapiel", "Honed", "Oghmus", "Zedeson", "Halmaneop", "Nopoz", "Ekarnahox", "Sacuhatakael", "Ticos", "Arametheus", "Azmodaeus", "Larhepeis", "Topriraiz", "Rarahaimzah", "Tedrahamael", "Osaselael", "Phlegon", "Nelokhiel", "Haristum", "Zul", "Larhepeis", "Aamon", "Tramater", "Ehhbes", "Kra`an", "Quarax", "Hotesiatrem", "Surgat", "Nu`uhn", "Litedabh", "Unonom", "Bolenoz", "Hilopael", "Haristum", "Uhn", "Hiepacth", "Pemcapso", "Ankou", "Pundohien", "Koit", "Montobulus", "Amsaset", "Aropet", "Isnal", "Solael", "Exroh", "Sidragrosam", "Pnecamob", "Malashim", "Beelzebuth", "Ehohit", "Izatap", "Olon", "Assoaz", "Agalierept", "Krakus", "Umlaboor", "Aknrar", "Damaz", "Rhysus", "Pundohien", "Ba`al", "Rasuniolpas", "Anhoor", "Nyarlathotep", "Krakus", "Larhepeis", "Itakup", "Erdok", "Umlaboor", "Ezon", "Krakus", "Glassyalabolas", "Kra`an", "Ehnnat", "Terxor", "Asramel", "Tadal", "Arpzih", "Azmodaeus", "Henbolaron", "Rhysus"};
    private int secretsShared;
    private BlockPos home;
    private long lastGiftTime;
    private long powerUpExpiry;

    public EntityImp(World par1World) {
        super(par1World);
        this.isImmuneToFire = true;
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWanderWithRestriction(this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, target -> !this.isTamed() ? target instanceof EntityPlayer : target == this.getAttackTarget()));
        this.setTamed(false);
        this.home = BlockPos.ORIGIN;
    }

    private static String getDemonName(Random rand) {
        if (rand.nextInt(5) == 0) {
            return DEMON_NAMES[rand.nextInt(DEMON_NAMES.length)];
        }
        return DEMON_NAMES[rand.nextInt(DEMON_NAMES.length)] + " " + DEMON_NAMES[rand.nextInt(DEMON_NAMES.length)];
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue((double)0.3f);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(50.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(AFFECTION, (Object)0);
        this.dataManager.register(POWERED, (Object)false);
    }

    private int getAffection() {
        return (Integer)this.dataManager.get(AFFECTION);
    }

    private void setAffection(int affection) {
        this.dataManager.set(AFFECTION, (Object)affection);
    }

    public boolean isPowered() {
        return (Boolean)this.dataManager.get(POWERED);
    }

    private void setPowered(boolean powered) {
        if (!this.world.isRemote) {
            this.dataManager.set(POWERED, (Object)powered);
        }
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger("Affection", this.getAffection());
        compound.setInteger("SecretsShared", this.secretsShared);
        compound.setLong("LastGiftTime", this.lastGiftTime);
        compound.setLong("PowerUpUntil2", this.powerUpExpiry);
        compound.setInteger("HomeLocX", this.home.getX());
        compound.setInteger("HomeLocY", this.home.getY());
        compound.setInteger("HomeLocZ", this.home.getZ());
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.setAffection(compound.getInteger("Affection"));
        this.secretsShared = compound.getInteger("SecretsShared");
        this.lastGiftTime = compound.getLong("LastGiftTime");
        long time = MinecraftServer.getCurrentTimeMillis() / 50L;
        if (compound.hasKey("PowerUpUntil2")) {
            this.powerUpExpiry = compound.getLong("PowerUpUntil2");
        } else if (compound.hasKey("PowerUpUntil")) {
            this.powerUpExpiry = compound.getLong("PowerUpUntil");
            if (this.powerUpExpiry > 0L) {
                this.powerUpExpiry = time + 72000L;
            }
        }
        if (time < this.powerUpExpiry) {
            this.setPowered(true);
        }
        this.home = new BlockPos(compound.getInteger("HomeLocX"), compound.getInteger("HomeLocY"), compound.getInteger("HomeLocZ"));
    }

    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_IMP_LAUGH;
    }

    protected float getSoundPitch() {
        return this.isPowered() ? (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.7f : (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.1f;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_IMP_HURT;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_IMP_DEATH;
    }

    protected float getSoundVolume() {
        return 0.5f;
    }

    public int getTalkInterval() {
        return 800;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        EntityLivingBase owner = this.getOwner();
        if (!this.world.isRemote && this.ticksExisted % 600 == 0 && owner != null && owner instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)owner;
            this.setAffection(Math.max(0, this.getAffection() - 1));
            if (this.getAffection() == 0 && this.ticksExisted > 72000 && this.world.rand.nextDouble() < 0.01) {
                this.playSound(WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, 1.0f, 1.0f);
                this.world.setEntityState((Entity)this, (byte)4);
                player.sendMessage(new TextComponentTranslation("entity.witchery.imp.goodbye", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                this.setDead();
            }
        }
        if (!this.world.isRemote && this.powerUpExpiry > 0L && this.isPowerupExpired()) {
            this.setPowered(false);
            this.powerUpExpiry = 0L;
        }
        if (this.ticksExisted % 20 == 0) {
            if (this.isPowered()) {
                if ((double)this.width != 0.6) {
                    this.setSize(0.6f, 1.3f);
                }
                if (!this.world.isRemote) {
                    this.heal(1.0f);
                }
            } else if ((double)this.width != 0.4) {
                this.setSize(0.4f, 1.3f);
            }
        }
        if (this.ticksExisted % 400 == 0) {
            this.heal(1.0f);
        }
    }

    private boolean isPowerupExpired() {
        return MinecraftServer.getCurrentTimeMillis() / 50L >= this.powerUpExpiry;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.world.isRemote && this.isPowered()) {
            this.world.spawnParticle(EnumParticleTypes.FLAME, this.posX - (double)this.width * 0.5 + this.world.rand.nextDouble() * (double)this.width, 0.1 + this.posY + this.world.rand.nextDouble() * 2.0, this.posZ - (double)this.width * 0.5 + this.world.rand.nextDouble() * (double)this.width, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        return super.attackEntityFrom(source, Math.min(damage, this.isPowered() ? 5.0f : 15.0f));
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), this.isPowered() ? 8.0f : 4.0f);
    }

    public boolean processInteract(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (stack.isEmpty()) {
            return true;
        }
        if (this.world.isRemote) {
            return false;
        }
        if (this.isTamed()) {
            if (stack.getItem() == Item.getItemFromBlock((Block)WitcheryBlocks.DEMON_HEART)) {
                if (!player.capabilities.isCreativeMode) {
                    stack.shrink(1);
                }
                if (!this.world.isRemote) {
                    this.powerUpExpiry = MinecraftServer.getCurrentTimeMillis() / 50L + 72000L;
                    this.setPowered(true);
                    this.world.playSound(null, player.getPosition(), WitcherySounds.ENTITY_IMP_LAUGH, this.getSoundCategory(), 0.5f, this.getSoundPitch());
                    player.sendMessage(new TextComponentTranslation("entity.witchery.imp.gift.overwhelming_power", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                }
            } else if (stack.getItem() == WitcheryIngredientItems.ICY_NEEDLE) {
                if (!player.capabilities.isCreativeMode) {
                    stack.shrink(1);
                }
                if (!this.world.isRemote) {
                    this.powerUpExpiry = 0L;
                    this.setPowered(false);
                    this.world.playSound(null, player.getPosition(), WitcherySounds.ENTITY_IMP_LAUGH, this.getSoundCategory(), 0.5f, this.getSoundPitch());
                    player.sendMessage(new TextComponentTranslation("entity.witchery.imp.gift.gift.weakened", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                }
            } else {
                if (!ItemActivatableContract.isBoundContract(stack)) {
                    if (!this.world.isRemote) {
                        Integer affectionBoost = shinies.get(stack.getItem());
                        if (affectionBoost != null && stack.getItemDamage() == 0) {
                            long timeNow = MinecraftServer.getCurrentTimeMillis() / 50L;
                            if (!player.capabilities.isCreativeMode) {
                                stack.shrink(1);
                            }
                            int affection = this.getAffection() + affectionBoost;
                            this.world.playSound(null, player.getPosition(), WitcherySounds.ENTITY_IMP_LAUGH, this.getSoundCategory(), 0.5f, this.getSoundPitch());
                            if (affection >= 20 && (timeNow > this.lastGiftTime + 3600L || player.capabilities.isCreativeMode) && this.rand.nextInt(Math.max(1, 10 - Math.max(affection - 20, 0))) == 0) {
                                ItemStack stackForPlayer;
                                this.lastGiftTime = timeNow;
                                affection = 0;
                                player.sendMessage(new TextComponentTranslation("entity.witchery.imp.gift.reciprocate", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                                switch (this.secretsShared) {
                                    case 0: {
                                        stackForPlayer = new ItemStack((Item)WitcheryBrewItems.SOUL_HUNGER_BREW);
                                        ++this.secretsShared;
                                        break;
                                    }
                                    case 1: {
                                        stackForPlayer = new ItemStack((Item)WitcheryBrewItems.SOUL_FEAR_BREW);
                                        ++this.secretsShared;
                                        break;
                                    }
                                    case 2: {
                                        stackForPlayer = new ItemStack((Item)WitcheryBrewItems.SOUL_ANGUISH_BREW);
                                        ++this.secretsShared;
                                        break;
                                    }
                                    case 3: {
                                        stackForPlayer = new ItemStack((Item)WitcheryContractItems.TORMENT_CONTRACT);
                                        ++this.secretsShared;
                                        break;
                                    }
                                    default: {
                                        stackForPlayer = EXTRA_DROPS[this.rand.nextInt(EXTRA_DROPS.length)].copy();
                                    }
                                }
                                if (stackForPlayer != null) {
                                    this.playSound(SoundEvents.BLOCK_NOTE_HARP, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                                    this.world.setEntityState((Entity)this, (byte)5);
                                    this.world.spawnEntity((Entity)new EntityItem(this.world, this.posX, this.posY, this.posZ, stackForPlayer));
                                }
                            } else if (timeNow < this.lastGiftTime + 3600L) {
                                player.sendMessage(new TextComponentTranslation("entity.witchery.imp.gift.too_many", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                            } else {
                                player.sendMessage(new TextComponentTranslation("entity.witchery.imp.gift.like", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                            }
                            this.setAffection(affection);
                        } else {
                            this.world.playSound(null, player.getPosition(), WitcherySounds.ENTITY_IMP_LAUGH, this.getSoundCategory(), 0.5f, this.getSoundPitch());
                            player.sendMessage(new TextComponentTranslation("entity.witchery.imp.gift.hate", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                        }
                    }
                    return true;
                }
                if (!this.world.isRemote) {
                    this.world.playSound(null, player.getPosition(), WitcherySounds.ENTITY_IMP_LAUGH, this.getSoundCategory(), 0.5f, this.getSoundPitch());
                    if (!this.isPowered()) {
                        if (this.getAffection() >= 20) {
                            long timeNow2 = MinecraftServer.getCurrentTimeMillis() / 50L;
                            if (timeNow2 > this.lastGiftTime + 3600L || player.capabilities.isCreativeMode) {
                                ItemActivatableContract contract = ItemActivatableContract.getContract(stack);
                                EntityLivingBase targetEntity = ItemTaglockKit.getBoundEntity(this.world, stack, 0);
                                if (contract != null && targetEntity != null) {
                                    if (contract.activate(targetEntity)) {
                                        this.lastGiftTime = timeNow2;
                                        player.sendMessage(new TextComponentTranslation("entity.witchery.imp.spell.feel_the_flames", new Object[]{this.getName(), targetEntity.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                                        if (!player.capabilities.isCreativeMode) {
                                            stack.shrink(1);
                                        }
                                    } else {
                                        player.sendMessage(new TextComponentTranslation("entity.witchery.imp.spell.failed", new Object[]{this.getName(), targetEntity.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                                    }
                                } else {
                                    ITextComponent name2 = ItemTaglockKit.getBoundEntityName(stack, 0);
                                    player.sendMessage(new TextComponentTranslation("entity.witchery.imp.spell.cannot_find_entity", new Object[]{this.getName(), name2}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                                }
                            } else {
                                player.sendMessage(new TextComponentTranslation("entity.witchery.imp.spell.cooldown", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                            }
                        } else {
                            player.sendMessage(new TextComponentTranslation("entity.witchery.imp.spell.dislike", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                        }
                    } else {
                        player.sendMessage(new TextComponentTranslation("entity.witchery.imp.spell.too_much_power", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                    }
                }
            }
        } else if (stack.getItem() == WitcheryContractItems.DEMONIC_CONTRACT) {
            if (!this.world.isRemote) {
                EntityLivingBase boundEntity = ItemActivatableContract.getBoundEntity(this.world, stack);
                if (boundEntity == player) {
                    int EXPERIENCE_NEEDED = 25;
                    if (player.experienceLevel >= EXPERIENCE_NEEDED || player.capabilities.isCreativeMode) {
                        if (!player.capabilities.isCreativeMode) {
                            stack.shrink(1);
                        }
                        player.addExperienceLevel(-EXPERIENCE_NEEDED);
                        this.setTamed(true);
                        this.setOwnerId(player.getUniqueID());
                        this.setAttackTarget(null);
                        this.getNavigator().clearPath();
                        this.home = this.getPosition();
                        this.enablePersistence();
                        this.world.playSound(null, player.getPosition(), WitcherySounds.ENTITY_IMP_LAUGH, this.getSoundCategory(), 0.5f, this.getSoundPitch());
                        player.sendMessage(new TextComponentTranslation("entity.witchery.imp.contract.deal", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                        this.setCustomNameTag(EntityImp.getDemonName(this.rand));
                    } else {
                        this.world.playSound(null, player.getPosition(), WitcherySounds.ENTITY_IMP_LAUGH, this.getSoundCategory(), 0.5f, this.getSoundPitch());
                        player.sendMessage(new TextComponentTranslation("entity.witchery.imp.contract.little_experience", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                    }
                } else if (boundEntity != null) {
                    this.world.playSound(null, player.getPosition(), WitcherySounds.ENTITY_IMP_LAUGH, this.getSoundCategory(), 0.5f, this.getSoundPitch());
                    player.sendMessage(new TextComponentTranslation("entity.witchery.imp.contract.wrong_blood_signature", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                } else {
                    this.world.playSound(null, player.getPosition(), WitcherySounds.ENTITY_IMP_LAUGH, this.getSoundCategory(), 0.5f, this.getSoundPitch());
                    player.sendMessage(new TextComponentTranslation("entity.witchery.imp.contract.not_signed", new Object[]{this.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                }
            }
            return true;
        }
        return super.processInteract(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte id) {
        if (id == 4) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.REDSTONE, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.SPELL_INSTANT, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    public EntityImp createChild(EntityAgeable par1EntityAgeable) {
        return null;
    }

    public boolean canMateWith(EntityAnimal par1EntityAnimal) {
        return false;
    }

    protected boolean canDespawn() {
        return true;
    }

    public BlockPos getHomePos() {
        return this.home;
    }

    static {
        shinies.put(new ItemStack(Items.DIAMOND).getItem(), 8);
        shinies.put(new ItemStack(Items.DIAMOND_AXE).getItem(), 24);
        shinies.put(new ItemStack(Items.DIAMOND_HOE).getItem(), 16);
        shinies.put(new ItemStack(Items.DIAMOND_SWORD).getItem(), 16);
        shinies.put(new ItemStack(Items.DIAMOND_SHOVEL).getItem(), 8);
        shinies.put(new ItemStack(Items.DIAMOND_PICKAXE).getItem(), 24);
        shinies.put(new ItemStack(Items.EMERALD).getItem(), 3);
        shinies.put(new ItemStack(Items.GOLD_INGOT).getItem(), 1);
        shinies.put(new ItemStack(Items.NETHER_STAR).getItem(), 16);
        shinies.put(new ItemStack(Items.BLAZE_ROD).getItem(), 1);
        shinies.put(new ItemStack(Items.GHAST_TEAR).getItem(), 4);
        shinies.put(new ItemStack(Items.GOLDEN_AXE).getItem(), 3);
        shinies.put(new ItemStack(Items.GOLDEN_SWORD).getItem(), 2);
        shinies.put(new ItemStack(Items.GOLDEN_HOE).getItem(), 2);
        shinies.put(new ItemStack(Items.GOLDEN_SHOVEL).getItem(), 1);
        shinies.put(new ItemStack(Items.GOLDEN_PICKAXE).getItem(), 3);
        shinies.put(new ItemStack(Blocks.GOLD_BLOCK).getItem(), 9);
        shinies.put(new ItemStack(Blocks.EMERALD_BLOCK).getItem(), 27);
        shinies.put(new ItemStack(Blocks.DIAMOND_BLOCK).getItem(), 72);
        shinies.put(new ItemStack(Blocks.LAPIS_BLOCK).getItem(), 7);
        shinies.put(new ItemStack(Blocks.REDSTONE_BLOCK).getItem(), 5);
    }
}

