/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.msrandom.witchery.util.WitcheryUtils;

public abstract class EntityIllusion
extends EntityMob {
    private static final DataParameter<Optional<UUID>> VICTIM = EntityDataManager.createKey(EntityIllusion.class, (DataSerializer)DataSerializers.OPTIONAL_UNIQUE_ID);
    private static final DataParameter<Integer> TYPE = EntityDataManager.createKey(EntityIllusion.class, (DataSerializer)DataSerializers.VARINT);
    private EntityPlayer victimPlayer = null;

    public EntityIllusion(World world) {
        super(world);
        this.isImmuneToFire = true;
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected SoundEvent getFakeLivingSound() {
        return null;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(0.0);
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    public EntityLivingBase getAttackTarget() {
        if (this.victimPlayer == null) {
            this.victimPlayer = WitcheryUtils.getPlayer(this.world, this.getVictimId());
        }
        return this.victimPlayer;
    }

    public int getMaxFallHeight() {
        return this.getAttackTarget() == null ? 3 : 3 + (int)(this.getHealth() - 1.0f);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(VICTIM, (Object)Optional.absent());
        this.dataManager.register(TYPE, (Object)0);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        UUID victimId = this.getVictimId();
        if (victimId != null) {
            par1NBTTagCompound.setUniqueId("Victim", victimId);
        }
        par1NBTTagCompound.setInteger("IllusionType", this.getIllusionType());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasUniqueId("Victim")) {
            this.setVictimId(par1NBTTagCompound.getUniqueId("Victim"));
        }
        this.setIllusionType(par1NBTTagCompound.getInteger("IllusionType"));
    }

    public UUID getVictimId() {
        return (UUID)((Optional)this.dataManager.get(VICTIM)).orNull();
    }

    public void setVictimId(UUID victim) {
        this.dataManager.set(VICTIM, (Object)Optional.fromNullable((Object)victim));
    }

    public int getIllusionType() {
        return (Integer)this.dataManager.get(TYPE);
    }

    public void setIllusionType(int par1) {
        this.dataManager.set(TYPE, (Object)par1);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.world.isRemote) {
            if (this.world.rand.nextInt(15) == 0) {
                float newHealth = this.getHealth() - 1.0f;
                if ((double)newHealth <= 0.5) {
                    this.setDead();
                } else {
                    this.setHealth(newHealth);
                }
            }
            if (this.world.rand.nextInt(40) == 0) {
                SoundEvent sound = this.getFakeLivingSound();
                if (this.getAttackTarget() instanceof EntityPlayer && sound != null && this.getAttackTarget().getDistanceSq((Entity)this) < 64.0) {
                    WitcheryUtils.playSoundAt((EntityPlayer)this.getAttackTarget(), sound, this.getSoundCategory(), 1.0f, 1.0f);
                }
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent getDeathSound() {
        return null;
    }

    public boolean attackEntityAsMob(Entity entity) {
        return true;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, par1DamageSource, par2)) {
            return super.attackEntityFrom(par1DamageSource, par2);
        }
        return false;
    }

    protected void dropFewItems(boolean par1, int par2) {
    }
}

