/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntityGoblinMog;
import net.msrandom.witchery.entity.ai.EntityAIMoveTowardsEntityClass;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityGoblinGulg
extends EntityMob
implements IHandleDeathTouch {
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.createKey(EntityGoblinGulg.class, (DataSerializer)DataSerializers.VARINT);
    private static final double INVULNRABLE = 9.0;
    private static final double PERCENT_20 = 36.0;
    private static final double PERCENT_50 = 81.0;
    private static final double PERCENT_80 = 256.0;
    private final BossInfoServer bossInfo = new BossInfoServer(this.getDisplayName(), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_6);
    long ticksSinceTeleport = 0L;
    private int attackTimer;

    public EntityGoblinGulg(World world) {
        super(world);
        this.isImmuneToFire = true;
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIMoveTowardsEntityClass((EntityCreature)this, EntityGoblinMog.class, 1.0, 6.0f, 64.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 48.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.experienceValue = 35;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(INVULNERABILITY_TIME, (Object)0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(400.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
    }

    public void addTrackingPlayer(EntityPlayerMP player) {
        super.addTrackingPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void removeTrackingPlayer(EntityPlayerMP player) {
        super.removeTrackingPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean isNonBoss() {
        return false;
    }

    public int getTotalArmorValue() {
        return 8;
    }

    public void setInWeb() {
    }

    public void setRevengeTarget(EntityLivingBase entity) {
        if (!(entity instanceof EntityGoblinMog || entity instanceof EntityGoblin || entity instanceof EntityGoblinGulg)) {
            super.setRevengeTarget(entity);
        }
    }

    public int getInvulTime() {
        return (Integer)this.dataManager.get(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int par1) {
        this.dataManager.set(INVULNERABILITY_TIME, (Object)par1);
    }

    public void ignite() {
        this.setInvulTime(150);
        this.setHealth(this.getMaxHealth() / 4.0f);
    }

    protected void updateAITasks() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.world.playBroadcastSound(1013, this.getPosition(), 0);
            }
            this.setInvulTime(i);
            if (this.ticksExisted % 10 == 0) {
                this.heal(20.0f);
            }
        } else {
            super.updateAITasks();
            if (this.ticksExisted % 20 == 0) {
                this.heal(2.0f);
            }
            if (!this.world.isRemote && this.getNavigator().noPath() && this.getAttackTarget() != null && (long)this.ticksExisted - this.ticksSinceTeleport > 200L) {
                this.ticksSinceTeleport = this.ticksExisted;
                this.teleportToEntity((Entity)this.getAttackTarget());
            }
            this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
        }
    }

    protected void teleportToEntity(Entity par1Entity) {
        Vec3d vec3 = new Vec3d(this.posX - par1Entity.posX, this.getEntityBoundingBox().minY + (double)(this.height / 2.0f) - par1Entity.posY + (double)par1Entity.getEyeHeight(), this.posZ - par1Entity.posZ);
        vec3 = vec3.normalize();
        double d0 = 16.0;
        double d2 = this.posX + (this.rand.nextDouble() - 0.5) * 8.0 - vec3.x * d0;
        double d3 = this.posY + (double)(this.rand.nextInt(16) - 8) - vec3.y * d0;
        double d4 = this.posZ + (this.rand.nextDouble() - 0.5) * 8.0 - vec3.z * d0;
        this.teleportTo(d2, d3, d4);
    }

    protected void teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        double d3 = this.posX;
        double d4 = this.posY;
        double d5 = this.posZ;
        this.posX = par1;
        this.posY = par3;
        this.posZ = par5;
        boolean flag = false;
        int i = MathHelper.floor((double)this.posX);
        BlockPos pos = new BlockPos(i, j = MathHelper.floor((double)this.posY), k = MathHelper.floor((double)this.posZ));
        if (this.world.isBlockLoaded(pos)) {
            boolean flag2 = false;
            while (!flag2 && j > 0) {
                IBlockState block = this.world.getBlockState(pos.down());
                if (block.getMaterial().blocksMovement()) {
                    flag2 = true;
                    continue;
                }
                this.posY -= 1.0;
                --j;
            }
            if (flag2) {
                this.setPosition(this.posX, this.posY, this.posZ);
                if (this.world.getCollisionBoxes((Entity)this, this.getEntityBoundingBox()).isEmpty() && !this.world.containsAnyLiquid(this.getEntityBoundingBox())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.setPosition(d3, d4, d5);
            return;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f3 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.posX - d3) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            double d8 = d4 + (this.posY - d4) * d6 + this.rand.nextDouble() * (double)this.height;
            double d9 = d5 + (this.posZ - d5) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            this.world.spawnParticle(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f2, (double)f3, new int[0]);
        }
        this.world.playSound(d3, d4, d5, SoundEvents.ENTITY_ENDERMEN_TELEPORT, this.getSoundCategory(), 1.0f, 1.0f, false);
        this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 1.0f, 1.0f);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, source, damage)) {
            return super.attackEntityFrom(source, damage);
        }
        double distance = this.getDistanceSqToPartner();
        double scale = 1.0;
        if (distance <= 9.0) {
            return false;
        }
        if (distance <= 36.0) {
            scale = 0.2;
        } else if (distance <= 81.0) {
            scale = 0.5;
        } else if (distance <= 256.0) {
            scale = 0.8;
        }
        return super.attackEntityFrom(source, (float)Math.min((double)damage * scale, 15.0));
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        double distance = this.getDistanceSqToPartner();
        double height2 = 0.0;
        int force = 4;
        if (distance <= 9.0) {
            height2 = 1.0;
            force = 20;
        } else if (distance <= 36.0) {
            height2 = 0.8;
            force = 15;
        } else if (distance <= 81.0) {
            height2 = 0.5;
            force = 10;
        } else if (distance <= 256.0) {
            height2 = 0.2;
            force = 6;
        }
        this.world.setEntityState((Entity)this, (byte)4);
        boolean flag = par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)(6 + this.rand.nextInt(force)));
        if (flag) {
            par1Entity.motionY += 0.5 + height2;
        }
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        return flag;
    }

    private double getDistanceSqToPartner() {
        double R = 16.0;
        AxisAlignedBB bb = new AxisAlignedBB(this.posX - R, this.posY - R, this.posZ - R, this.posX + R, this.posY + R, this.posZ + R);
        List mogs = this.world.getEntitiesWithinAABB(EntityGoblinMog.class, bb);
        double minDistance = Double.MAX_VALUE;
        for (EntityGoblinMog mog : mogs) {
            double distance = this.getDistanceSq((Entity)mog);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
        }
        return minDistance;
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("Invul", this.getInvulTime());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setInvulTime(par1NBTTagCompound.getInteger("Invul"));
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        } else {
            super.handleStatusUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness() {
        return 1.0f;
    }

    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_GOBLIN_GULG_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_ZOMBIE_HORSE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_WITHER_DEATH;
    }

    protected void playStepSound(BlockPos pos, Block block) {
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_STEP, 1.0f, 1.0f);
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.entityDropItem(new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET, this.rand.nextInt(3) + 1), 0.0f);
        ItemStack armor = ItemStack.EMPTY;
        switch (this.rand.nextInt(4)) {
            case 0: {
                armor = new ItemStack((Item)Items.CHAINMAIL_BOOTS);
                break;
            }
            case 1: {
                armor = new ItemStack((Item)Items.CHAINMAIL_LEGGINGS);
                break;
            }
            case 2: {
                armor = new ItemStack((Item)Items.CHAINMAIL_CHESTPLATE);
                break;
            }
            case 3: {
                armor = new ItemStack((Item)Items.CHAINMAIL_HELMET);
            }
        }
        if (!armor.isEmpty()) {
            EnchantmentHelper.addRandomEnchantment((Random)this.world.rand, (ItemStack)armor, (int)30, (boolean)false);
            this.entityDropItem(armor, 0.0f);
        }
        if (this.world.rand.nextBoolean()) {
            this.entityDropItem(new ItemStack((Item)WitcheryEquipmentItems.GULGS_GURDLE), 0.0f);
        }
    }

    protected Item getDropItem() {
        return Items.AIR;
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        this.enablePersistence();
        return super.onInitialSpawn(difficulty, par1EntityLivingData);
    }

    protected boolean canDespawn() {
        return false;
    }
}

