/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.entity.ai.EntityAIAvoidEntityConditionally;
import net.msrandom.witchery.entity.ai.EntityAIDigBlocks;
import net.msrandom.witchery.entity.ai.EntityAIDropOffBlocks;
import net.msrandom.witchery.entity.ai.EntityAIGoblinMate;
import net.msrandom.witchery.entity.ai.EntityAILookAtTradePlayerGeneric;
import net.msrandom.witchery.entity.ai.EntityAIMoveIndoorsLeashAware;
import net.msrandom.witchery.entity.ai.EntityAIPickUpBlocks;
import net.msrandom.witchery.entity.ai.EntityAITradePlayerGeneric;
import net.msrandom.witchery.entity.ai.EntityAIWorship;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class EntityGoblin
extends EntityAgeable
implements IMerchant,
INpc,
EntityAIAvoidEntityConditionally.IAvoidEntities {
    public static final Map<Item, Tuple<Integer, Integer>> villagersSellingList = new HashMap<Item, Tuple<Integer, Integer>>();
    public static final Map<Item, Tuple<Integer, Integer>> blacksmithSellingList = new HashMap<Item, Tuple<Integer, Integer>>();
    private static final DataParameter<Integer> PROFESSION = EntityDataManager.createKey(EntityGoblin.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Boolean> CLIMBING = EntityDataManager.createKey(EntityGoblin.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static final DataParameter<Boolean> WORKING = EntityDataManager.createKey(EntityGoblin.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static final DataParameter<Boolean> WORSHIPPING = EntityDataManager.createKey(EntityGoblin.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static final double KOBOLDITE_HARVEST_CHANCE = 0.02;
    Village village;
    private int randomTickDivider;
    private boolean isMating;
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private int wealth;
    private UUID lastBuyingPlayer;
    private boolean isLookingForHome;
    private float probability;
    private final EntityAIWorship aiWorship;
    private boolean preventDespawn;
    private boolean testingLeashRange;

    public EntityGoblin(World par1World) {
        super(par1World);
        this.setProfession(this.rand.nextInt(4));
        ((PathNavigateGround)this.getNavigator()).setBreakDoors(true);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.aiWorship = new EntityAIWorship(this, 600 + this.rand.nextInt(10));
        this.tasks.addTask(1, (EntityAIBase)this.aiWorship);
        this.tasks.addTask(2, (EntityAIBase)new EntityAIPickUpBlocks(this, 24.0));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIDropOffBlocks(this, 24.0));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIDigBlocks(this, 16.0, 0.02));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 0.6, 0.6));
        this.tasks.addTask(3, new EntityAIAvoidEntityConditionally<EntityVillageGuard>((EntityCreature)this, EntityVillageGuard.class, 12.0f, 0.8, 0.8, this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAITradePlayerGeneric(this, (EntityLiving)this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAILookAtTradePlayerGeneric((EntityLiving)this, this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveIndoorsLeashAware((EntityCreature)this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIGoblinMate(this));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityGoblin.class, 5.0f, 0.02f));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, true, true, entity -> !(entity instanceof EntityVillager) || this.world.getEntitiesWithinAABB(EntityGoblin.class, this.getEntityBoundingBox().grow(8.0)).size() >= 3));
    }

    public static void addItemToSwapForAnEmerald(MerchantRecipeList buyList, Item item, Random rand, float probability) {
        if (rand.nextFloat() < probability) {
            if (rand.nextInt(3) == 0) {
                buyList.add((Object)new MerchantRecipe(EntityGoblin.getItemStackToSwapForAnEmerald(item, rand), new ItemStack(WitcheryIngredientItems.KOBOLDITE_DUST)));
            } else {
                buyList.add((Object)new MerchantRecipe(EntityGoblin.getItemStackToSwapForAnEmerald(item, rand), Items.EMERALD));
            }
        }
    }

    private static ItemStack getItemStackToSwapForAnEmerald(Item item, Random rand) {
        return new ItemStack(item, EntityGoblin.getQuantityToSwapForAnEmerald(item, rand), 0);
    }

    private static int getQuantityToSwapForAnEmerald(Item item, Random rand) {
        Tuple<Integer, Integer> tuple = villagersSellingList.get(item);
        return tuple == null ? 1 : ((Integer)tuple.getFirst() >= (Integer)tuple.getSecond() ? (Integer)tuple.getFirst() : (Integer)tuple.getFirst() + rand.nextInt((Integer)tuple.getSecond() - (Integer)tuple.getFirst()));
    }

    public static void addItemToBuyOrSell(MerchantRecipeList list2, Item item, Random rand, float probability) {
        if (rand.nextFloat() < probability) {
            ItemStack itemstack2;
            ItemStack itemstack;
            int i = EntityGoblin.quantityToBuyOrSell(item, rand);
            if (i < 0) {
                itemstack = new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET, 1);
                itemstack2 = new ItemStack(item, -i, 0);
            } else {
                itemstack = new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET, i);
                itemstack2 = new ItemStack(item, 1, 0);
            }
            list2.add((Object)new MerchantRecipe(itemstack, itemstack2));
        }
    }

    private static int quantityToBuyOrSell(Item item, Random rand) {
        Tuple<Integer, Integer> tuple = blacksmithSellingList.get(item);
        return tuple == null ? 1 : ((Integer)tuple.getFirst() >= (Integer)tuple.getSecond() ? (Integer)tuple.getFirst() : (Integer)tuple.getFirst() + rand.nextInt((Integer)tuple.getSecond() - (Integer)tuple.getFirst()));
    }

    @Override
    public boolean shouldAvoid() {
        double R = 8.0;
        return this.world.getEntitiesWithinAABB(EntityGoblin.class, new AxisAlignedBB(this.posX - R, this.posY - R, this.posZ - R, this.posX + R, this.posY + R, this.posZ + R)).size() >= 3;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.4);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(2.0);
    }

    public boolean attackEntityAsMob(Entity targetEntity) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue();
        int i = 0;
        if (targetEntity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getModifierForCreature((ItemStack)this.getHeldItemMainhand(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).getCreatureAttribute());
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this);
        }
        if (flag = targetEntity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                targetEntity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                targetEntity.setFire(j * 4);
            }
            if (targetEntity instanceof EntityLivingBase) {
                EnchantmentHelper.applyThornEnchantments((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
            }
            EnchantmentHelper.applyArthropodEnchantments((EntityLivingBase)this, (Entity)targetEntity);
        }
        return flag;
    }

    protected void updateAITasks() {
        int randomTickDivider;
        this.randomTickDivider = randomTickDivider = this.randomTickDivider - 1;
        if (randomTickDivider <= 0) {
            this.world.villageCollection.addToVillagerPositionList(this.getPosition());
            this.randomTickDivider = 70 + this.rand.nextInt(50);
            this.village = this.world.villageCollection.getNearestVillage(this.getPos(), 32);
            if (this.village == null) {
                this.detachHome();
            } else {
                this.preventDespawn = true;
                BlockPos chunkcoordinates = this.village.getCenter();
                this.setHomePosAndDistance(chunkcoordinates, (int)((float)this.village.getVillageRadius() * 0.6f));
                if (this.isLookingForHome) {
                    this.isLookingForHome = false;
                    this.village.setDefaultPlayerReputation(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    if (this.buyingList.size() > 1) {
                        for (MerchantRecipe merchantrecipe : this.buyingList) {
                            if (!merchantrecipe.isRecipeDisabled()) continue;
                            merchantrecipe.increaseMaxTradeUses(this.rand.nextInt(6) + this.rand.nextInt(6) + 2);
                        }
                    }
                    this.addDefaultEquipmentAndRecipies();
                    this.needsInitilization = false;
                    if (this.village != null && this.lastBuyingPlayer != null) {
                        this.world.setEntityState((Entity)this, (byte)14);
                        this.village.modifyPlayerReputation(this.lastBuyingPlayer, 1);
                    }
                }
                this.addPotionEffect(new PotionEffect(MobEffects.REGENERATION, 200, 0));
            }
        }
        super.updateAITasks();
    }

    protected void updateLeashedState() {
        try {
            this.testingLeashRange = true;
            if (this.getLeashed()) {
                this.preventDespawn = true;
            }
            super.updateLeashedState();
        }
        finally {
            this.testingLeashRange = false;
        }
    }

    public float getDistance(Entity par1Entity) {
        float distance = super.getDistance(par1Entity);
        if (this.testingLeashRange && distance < 9.0f) {
            distance *= 0.5f;
        }
        return distance;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.world.isRemote) {
            this.setBesideClimbableBlock(this.collidedHorizontally);
        }
    }

    public boolean isWorking() {
        return (Boolean)this.dataManager.get(WORKING);
    }

    public void setWorking(boolean par1) {
        this.dataManager.set(WORKING, (Object)par1);
    }

    public boolean isWorshipping() {
        return (Boolean)this.dataManager.get(WORSHIPPING);
    }

    public void setWorshipping(boolean worshiping) {
        this.dataManager.set(WORSHIPPING, (Object)worshiping);
    }

    public void beginWorship(TileEntity tile) {
        this.aiWorship.begin(tile);
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.dataManager.get(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean par1) {
        this.dataManager.set(CLIMBING, (Object)par1);
    }

    public boolean processInteract(EntityPlayer player, EnumHand hand) {
        boolean heldSpawnEgg;
        ItemStack stack = player.getHeldItem(hand);
        boolean bl = heldSpawnEgg = !stack.isEmpty() && stack.getItem() == Items.SPAWN_EGG;
        if (!(heldSpawnEgg || !this.isEntityAlive() || this.isTrading() || this.isChild() || player.isSneaking())) {
            if (this.getLeashed()) {
                if (this.getHeldItem(hand).isEmpty()) {
                    if (!stack.isEmpty() && stack.getItem() instanceof ItemPickaxe) {
                        this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, stack);
                        player.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    }
                } else {
                    if (!this.world.isRemote) {
                        ItemStack goblinItem = this.getHeldItem(hand);
                        if (!player.inventory.addItemStackToInventory(goblinItem)) {
                            this.entityDropItem(goblinItem, 1.0f);
                        } else if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                        }
                    }
                    this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                }
            } else if (!(this.isWorking() || this.isWorshipping() || this.village == null || this.world.isRemote)) {
                this.setCustomer(player);
                player.displayVillagerTradeGui((IMerchant)this);
            }
            return true;
        }
        return super.processInteract(player, hand);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(PROFESSION, (Object)0);
        this.dataManager.register(CLIMBING, (Object)false);
        this.dataManager.register(WORKING, (Object)false);
        this.dataManager.register(WORSHIPPING, (Object)false);
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setInteger("Profession", this.getProfession());
        nbtRoot.setInteger("Riches", this.wealth);
        nbtRoot.setBoolean("Worshipping", this.isWorshipping());
        if (this.buyingList != null) {
            nbtRoot.setTag("Offers", (NBTBase)this.buyingList.getRecipiesAsTags());
        }
        nbtRoot.setBoolean("PreventDespawn", this.preventDespawn);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.setProfession(nbtRoot.getInteger("Profession"));
        this.wealth = nbtRoot.getInteger("Riches");
        if (nbtRoot.getBoolean("Worshipping") && !this.world.isRemote) {
            this.setWorshipping(true);
        }
        if (nbtRoot.hasKey("Offers", 10)) {
            NBTTagCompound nbttagcompound1 = nbtRoot.getCompoundTag("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound1);
        }
        this.preventDespawn = nbtRoot.getBoolean("PreventDespawn");
    }

    protected float getSoundPitch() {
        return 1.2f;
    }

    protected boolean canDespawn() {
        return WitcheryConfigOptions.goblinDespawns && this.village == null && !this.preventDespawn && !this.isWorshipping();
    }

    protected SoundEvent getAmbientSound() {
        return this.isTrading() ? WitcherySounds.ENTITY_GOBLIN_HAGGLE : WitcherySounds.ENTITY_GOBLIN_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_GOBLIN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_GOBLIN_DEATH;
    }

    public int getProfession() {
        return (Integer)this.dataManager.get(PROFESSION);
    }

    public void setProfession(int par1) {
        this.dataManager.set(PROFESSION, (Object)par1);
    }

    public boolean isMating() {
        return this.isMating;
    }

    public void setMating(boolean par1) {
        this.isMating = par1;
    }

    public void setRevengeTarget(EntityLivingBase par1EntityLivingBase) {
        super.setRevengeTarget(par1EntityLivingBase);
        if (this.village != null && par1EntityLivingBase != null) {
            this.village.addOrRenewAgressor(par1EntityLivingBase);
            if (par1EntityLivingBase instanceof EntityPlayer) {
                if (this.isChild()) {
                    this.village.modifyPlayerReputation(par1EntityLivingBase.getUniqueID(), -3);
                }
                if (this.isEntityAlive()) {
                    this.world.setEntityState((Entity)this, (byte)13);
                }
            }
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        if (this.village != null) {
            Entity entity = par1DamageSource.getTrueSource();
            if (entity != null) {
                if (!(entity instanceof EntityPlayer) && entity instanceof IMob) {
                    this.village.endMatingSeason();
                }
            } else {
                EntityPlayer entityplayer = this.world.getClosestPlayerToEntity((Entity)this, 16.0);
                if (entityplayer != null) {
                    this.village.endMatingSeason();
                }
            }
        }
        super.onDeath(par1DamageSource);
    }

    public boolean getCanSpawnHere() {
        int k;
        int j;
        int i = MathHelper.floor((double)this.posX);
        return this.world.getBlockState(new BlockPos(i, (j = MathHelper.floor((double)this.getEntityBoundingBox().minY)) - 1, k = MathHelper.floor((double)this.posZ))).getBlock() == Blocks.GRASS && this.world.getLight(new BlockPos(i, j, k)) > 8 && super.getCanSpawnHere();
    }

    public EntityPlayer getCustomer() {
        return this.buyingPlayer;
    }

    public void setCustomer(EntityPlayer par1EntityPlayer) {
        this.buyingPlayer = par1EntityPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void useRecipe(MerchantRecipe par1MerchantRecipe) {
        par1MerchantRecipe.incrementToolUses();
        this.livingSoundTime = -this.getTalkInterval();
        this.playSound(WitcherySounds.ENTITY_GOBLIN_YES, this.getSoundVolume(), this.getSoundPitch());
        if (par1MerchantRecipe.getToolUses() == 1 || this.rand.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.getUniqueID() : null;
        }
        if (par1MerchantRecipe.getItemToBuy().getItem() == Items.EMERALD) {
            this.wealth += par1MerchantRecipe.getItemToBuy().getCount();
        }
    }

    public void verifySellingItem(ItemStack par1ItemStack) {
        if (!this.world.isRemote && this.livingSoundTime > -this.getTalkInterval() + 20) {
            this.livingSoundTime = -this.getTalkInterval();
            this.playSound(WitcherySounds.ENTITY_GOBLIN_YES, this.getSoundVolume(), this.getSoundPitch());
        }
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.getPosition();
    }

    public MerchantRecipeList getRecipes(EntityPlayer par1EntityPlayer) {
        if (this.buyingList == null) {
            this.addDefaultEquipmentAndRecipies();
        }
        return this.buyingList;
    }

    private float adjustProbability(float par1) {
        float f1 = par1 + this.probability;
        return f1 > 0.9f ? 0.9f - (f1 - 0.9f) : f1;
    }

    private void addDefaultEquipmentAndRecipies() {
        this.probability = this.buyingList != null ? MathHelper.sqrt((float)this.buyingList.size()) * 0.2f : 0.0f;
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        boolean shuffle = true;
        switch (this.getProfession()) {
            case 0: {
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.WHEAT, this.rand, this.adjustProbability(0.9f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Item.getItemFromBlock((Block)Blocks.WOOL), this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.CHICKEN, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.COOKED_FISH, this.rand, this.adjustProbability(0.4f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.BREAD, this.rand, this.adjustProbability(0.9f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.MELON, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.APPLE, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.COOKIE, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.SHEARS, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.FLINT_AND_STEEL, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.COOKED_CHICKEN, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.ARROW, this.rand, this.adjustProbability(0.5f));
                if (!(this.rand.nextFloat() < this.adjustProbability(0.5f))) break;
                merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(Blocks.GRAVEL, 10), new ItemStack(Items.EMERALD), new ItemStack(Items.FLINT, 4 + this.rand.nextInt(2), 0)));
                break;
            }
            case 1: 
            case 2: {
                shuffle = false;
                if (this.buyingList == null) {
                    merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(WitcheryIngredientItems.KOBOLDITE_DUST, 9), new ItemStack(Items.GOLD_NUGGET, 5), new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET)));
                    break;
                }
                if (this.buyingList.size() == 1) {
                    merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(WitcheryIngredientItems.KOBOLDITE_DUST, 16), new ItemStack(Items.GOLD_INGOT), new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET, 2)));
                    break;
                }
                if (this.buyingList.size() != 2) break;
                merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET, 9), new ItemStack(Items.EMERALD), new ItemStack(WitcheryIngredientItems.KOBOLDITE_INGOT)));
                break;
            }
            case 3: {
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.COAL, this.rand, this.adjustProbability(0.7f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.IRON_INGOT, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.GOLD_INGOT, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.DIAMOND, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.IRON_SWORD, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.DIAMOND_SWORD, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.IRON_AXE, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.DIAMOND_AXE, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.IRON_PICKAXE, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.DIAMOND_PICKAXE, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.IRON_SHOVEL, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.DIAMOND_SHOVEL, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.IRON_HOE, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.DIAMOND_HOE, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.IRON_BOOTS, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.DIAMOND_BOOTS, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.IRON_HELMET, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.DIAMOND_HELMET, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.IRON_CHESTPLATE, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.DIAMOND_CHESTPLATE, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.IRON_LEGGINGS, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.DIAMOND_LEGGINGS, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.CHAINMAIL_BOOTS, this.rand, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.CHAINMAIL_HELMET, this.rand, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.CHAINMAIL_CHESTPLATE, this.rand, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.CHAINMAIL_LEGGINGS, this.rand, this.adjustProbability(0.1f));
                break;
            }
            case 4: {
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.COAL, this.rand, this.adjustProbability(0.7f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.PORKCHOP, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.BEEF, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.SADDLE, this.rand, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.LEATHER_CHESTPLATE, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.LEATHER_BOOTS, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.LEATHER_HELMET, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.LEATHER_LEGGINGS, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.COOKED_PORKCHOP, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.COOKED_BEEF, this.rand, this.adjustProbability(0.3f));
            }
        }
        if (merchantrecipelist.isEmpty()) {
            merchantrecipelist.add((Object)new MerchantRecipe(EntityGoblin.getItemStackToSwapForAnEmerald(Items.GOLD_INGOT, this.rand), Items.EMERALD));
        }
        if (shuffle) {
            Collections.shuffle(merchantrecipelist);
        }
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (int l = 0; l < 1 && l < merchantrecipelist.size(); ++l) {
            this.buyingList.add(merchantrecipelist.get(l));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setRecipes(MerchantRecipeList par1MerchantRecipeList) {
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte par1) {
        if (par1 == 12) {
            this.generateRandomParticles(EnumParticleTypes.HEART);
        } else if (par1 == 13) {
            this.generateRandomParticles(EnumParticleTypes.VILLAGER_ANGRY);
        } else if (par1 == 14) {
            this.generateRandomParticles(EnumParticleTypes.VILLAGER_HAPPY);
        } else {
            super.handleStatusUpdate(par1);
        }
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.onInitialSpawn(difficulty, par1EntityLivingData);
        int trade = this.rand.nextInt(5);
        this.setProfession(trade);
        return par1EntityLivingData;
    }

    @SideOnly(value=Side.CLIENT)
    private void generateRandomParticles(EnumParticleTypes par1Enm) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            double d3 = this.rand.nextGaussian() * 0.02;
            this.world.spawnParticle(par1Enm, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 1.0 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d0, d2, d3, new int[0]);
        }
    }

    public void setLookingForHome() {
        this.isLookingForHome = true;
    }

    public EntityGoblin createChild(EntityAgeable par1EntityAgeable) {
        EntityGoblin entityvillager = new EntityGoblin(this.world);
        entityvillager.onInitialSpawn(this.world.getDifficultyForLocation(entityvillager.getPosition()), null);
        return entityvillager;
    }

    static {
        villagersSellingList.put(Items.COAL, (Tuple<Integer, Integer>)new Tuple((Object)16, (Object)24));
        villagersSellingList.put(Items.IRON_INGOT, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)10));
        villagersSellingList.put(Items.GOLD_INGOT, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)10));
        villagersSellingList.put(Items.DIAMOND, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        villagersSellingList.put(Items.PAPER, (Tuple<Integer, Integer>)new Tuple((Object)24, (Object)36));
        villagersSellingList.put(Items.BOOK, (Tuple<Integer, Integer>)new Tuple((Object)11, (Object)13));
        villagersSellingList.put(Items.WRITTEN_BOOK, (Tuple<Integer, Integer>)new Tuple((Object)1, (Object)1));
        villagersSellingList.put(Items.ENDER_PEARL, (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        villagersSellingList.put(Items.ENDER_EYE, (Tuple<Integer, Integer>)new Tuple((Object)2, (Object)3));
        villagersSellingList.put(Items.PORKCHOP, (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)18));
        villagersSellingList.put(Items.BEEF, (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)18));
        villagersSellingList.put(Items.CHICKEN, (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)18));
        villagersSellingList.put(Items.COOKED_FISH, (Tuple<Integer, Integer>)new Tuple((Object)9, (Object)13));
        villagersSellingList.put(Items.WHEAT_SEEDS, (Tuple<Integer, Integer>)new Tuple((Object)34, (Object)48));
        villagersSellingList.put(Items.MELON_SEEDS, (Tuple<Integer, Integer>)new Tuple((Object)30, (Object)38));
        villagersSellingList.put(Items.PUMPKIN_SEEDS, (Tuple<Integer, Integer>)new Tuple((Object)30, (Object)38));
        villagersSellingList.put(Items.WHEAT, (Tuple<Integer, Integer>)new Tuple((Object)18, (Object)22));
        villagersSellingList.put(Item.getItemFromBlock((Block)Blocks.WOOL), (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)22));
        villagersSellingList.put(Items.ROTTEN_FLESH, (Tuple<Integer, Integer>)new Tuple((Object)36, (Object)64));
        blacksmithSellingList.put(Items.FLINT_AND_STEEL, (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        blacksmithSellingList.put((Item)Items.SHEARS, (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        blacksmithSellingList.put(Items.IRON_SWORD, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)11));
        blacksmithSellingList.put(Items.DIAMOND_SWORD, (Tuple<Integer, Integer>)new Tuple((Object)12, (Object)14));
        blacksmithSellingList.put(Items.IRON_AXE, (Tuple<Integer, Integer>)new Tuple((Object)6, (Object)8));
        blacksmithSellingList.put(Items.DIAMOND_AXE, (Tuple<Integer, Integer>)new Tuple((Object)9, (Object)12));
        blacksmithSellingList.put(Items.IRON_PICKAXE, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)9));
        blacksmithSellingList.put(Items.DIAMOND_PICKAXE, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        blacksmithSellingList.put(Items.IRON_SHOVEL, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put(Items.DIAMOND_SHOVEL, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put(Items.IRON_HOE, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put(Items.DIAMOND_HOE, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put((Item)Items.IRON_BOOTS, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put((Item)Items.DIAMOND_BOOTS, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put((Item)Items.IRON_HELMET, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put((Item)Items.DIAMOND_HELMET, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put((Item)Items.IRON_CHESTPLATE, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)14));
        blacksmithSellingList.put((Item)Items.DIAMOND_CHESTPLATE, (Tuple<Integer, Integer>)new Tuple((Object)16, (Object)19));
        blacksmithSellingList.put((Item)Items.IRON_LEGGINGS, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)10));
        blacksmithSellingList.put((Item)Items.DIAMOND_LEGGINGS, (Tuple<Integer, Integer>)new Tuple((Object)11, (Object)14));
        blacksmithSellingList.put((Item)Items.CHAINMAIL_BOOTS, (Tuple<Integer, Integer>)new Tuple((Object)5, (Object)7));
        blacksmithSellingList.put((Item)Items.CHAINMAIL_HELMET, (Tuple<Integer, Integer>)new Tuple((Object)5, (Object)7));
        blacksmithSellingList.put((Item)Items.CHAINMAIL_CHESTPLATE, (Tuple<Integer, Integer>)new Tuple((Object)11, (Object)15));
        blacksmithSellingList.put((Item)Items.CHAINMAIL_LEGGINGS, (Tuple<Integer, Integer>)new Tuple((Object)9, (Object)11));
        blacksmithSellingList.put(Items.BREAD, (Tuple<Integer, Integer>)new Tuple((Object)-4, (Object)-2));
        blacksmithSellingList.put(Items.MELON, (Tuple<Integer, Integer>)new Tuple((Object)-8, (Object)-4));
        blacksmithSellingList.put(Items.APPLE, (Tuple<Integer, Integer>)new Tuple((Object)-8, (Object)-4));
        blacksmithSellingList.put(Items.COOKIE, (Tuple<Integer, Integer>)new Tuple((Object)-10, (Object)-7));
        blacksmithSellingList.put(Item.getItemFromBlock((Block)Blocks.GLASS), (Tuple<Integer, Integer>)new Tuple((Object)-5, (Object)-3));
        blacksmithSellingList.put(Item.getItemFromBlock((Block)Blocks.BOOKSHELF), (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        blacksmithSellingList.put((Item)Items.LEATHER_CHESTPLATE, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)5));
        blacksmithSellingList.put((Item)Items.LEATHER_BOOTS, (Tuple<Integer, Integer>)new Tuple((Object)2, (Object)4));
        blacksmithSellingList.put((Item)Items.LEATHER_HELMET, (Tuple<Integer, Integer>)new Tuple((Object)2, (Object)4));
        blacksmithSellingList.put((Item)Items.LEATHER_LEGGINGS, (Tuple<Integer, Integer>)new Tuple((Object)2, (Object)4));
        blacksmithSellingList.put(Items.SADDLE, (Tuple<Integer, Integer>)new Tuple((Object)6, (Object)8));
        blacksmithSellingList.put(Items.EXPERIENCE_BOTTLE, (Tuple<Integer, Integer>)new Tuple((Object)-4, (Object)-1));
        blacksmithSellingList.put(Items.REDSTONE, (Tuple<Integer, Integer>)new Tuple((Object)-4, (Object)-1));
        blacksmithSellingList.put(Items.COMPASS, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        blacksmithSellingList.put(Items.CLOCK, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        blacksmithSellingList.put(Item.getItemFromBlock((Block)Blocks.GLOWSTONE), (Tuple<Integer, Integer>)new Tuple((Object)-3, (Object)-1));
        blacksmithSellingList.put(Items.COOKED_PORKCHOP, (Tuple<Integer, Integer>)new Tuple((Object)-7, (Object)-5));
        blacksmithSellingList.put(Items.COOKED_BEEF, (Tuple<Integer, Integer>)new Tuple((Object)-7, (Object)-5));
        blacksmithSellingList.put(Items.COOKED_CHICKEN, (Tuple<Integer, Integer>)new Tuple((Object)-8, (Object)-6));
        blacksmithSellingList.put(Items.ENDER_EYE, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)11));
        blacksmithSellingList.put(Items.ARROW, (Tuple<Integer, Integer>)new Tuple((Object)-12, (Object)-8));
    }
}

