/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityFlyingMob
extends EntityMob {
    public EntityFlyingMob(World par1World) {
        super(par1World);
    }

    public void fall(float distance, float damageMultiplier) {
    }

    protected void updateFallState(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public void travel(float strafe, float vertical, float forward) {
        if (this.isInWater()) {
            this.moveRelative(strafe, vertical, forward, 0.02f);
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.8f;
            this.motionY *= (double)0.8f;
            this.motionZ *= (double)0.8f;
        } else if (this.isInLava()) {
            this.moveRelative(strafe, vertical, forward, 0.02f);
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        } else {
            float f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.54600006f;
                BlockPos pos = new BlockPos(MathHelper.floor((double)this.posX), MathHelper.floor((double)this.getEntityBoundingBox().minY) - 1, MathHelper.floor((double)this.posZ));
                IBlockState state = this.world.getBlockState(pos);
                Block i = state.getBlock();
                if (i != Blocks.AIR) {
                    f2 = i.getSlipperiness(state, (IBlockAccess)this.world, pos, (Entity)this) * 0.91f;
                }
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            this.moveRelative(strafe, vertical, forward, this.onGround ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.54600006f;
                BlockPos pos = new BlockPos(MathHelper.floor((double)this.posX), MathHelper.floor((double)this.getEntityBoundingBox().minY) - 1, MathHelper.floor((double)this.posZ));
                IBlockState state = this.world.getBlockState(pos);
                Block j = state.getBlock();
                if (j != Blocks.AIR) {
                    f2 = j.getSlipperiness(state, (IBlockAccess)this.world, pos, (Entity)this) * 0.91f;
                }
            }
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)f2;
            this.motionY *= (double)f2;
            this.motionZ *= (double)f2;
        }
        this.prevLimbSwingAmount = this.limbSwingAmount;
        double d0 = this.posX - this.prevPosX;
        double d2 = this.posZ - this.prevPosZ;
        float f4 = MathHelper.sqrt((double)(d0 * d0 + d2 * d2)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.limbSwingAmount += (f4 - this.limbSwingAmount) * 0.4f;
        this.limbSwing += this.limbSwingAmount;
    }

    public boolean isOnLadder() {
        return false;
    }
}

