/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.WitcheryWoodType;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityEnt
extends EntityMob
implements IEntityOwnable {
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.createKey(EntityEnt.class, (DataSerializer)DataSerializers.OPTIONAL_UNIQUE_ID);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.createKey(EntityEnt.class, (DataSerializer)DataSerializers.BOOLEAN);
    private int attackTimer;
    private EntityPlayer owner;

    public EntityEnt(World par1World) {
        super(par1World);
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, null));
        this.experienceValue = 25;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(OWNER, (Object)Optional.absent());
        this.dataManager.register(SCREAMING, (Object)false);
    }

    public boolean isScreaming() {
        return (Boolean)this.dataManager.get(SCREAMING);
    }

    public void setScreaming(boolean par1) {
        this.dataManager.set(SCREAMING, (Object)par1);
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (!this.world.isRemote && this.isEntityAlive()) {
            this.setScreaming(this.getAttackTarget() != null);
        }
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(200.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.4);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
        this.getEntityAttribute(SharedMonsterAttributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        Block l;
        int k;
        int j;
        int i2;
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.world.isRemote && this.world.rand.nextInt(300) == 0) {
            try {
                i2 = MathHelper.floor((double)this.posX);
                j = MathHelper.floor((double)this.posY) - 1;
                k = MathHelper.floor((double)this.posZ);
                ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.DYE, 1, EnumDyeColor.WHITE.getDyeDamage()), (World)this.world, (BlockPos)new BlockPos(i2, j, k));
            }
            catch (Throwable i2) {
                // empty catch block
            }
        }
        if (this.motionX * this.motionX + this.motionZ * this.motionZ > 2.500000277905201E-7 && this.rand.nextInt(5) == 0 && (l = this.world.getBlockState(new BlockPos(i2 = MathHelper.floor((double)this.posX), j = MathHelper.floor((double)(this.posY - (double)0.2f)), k = MathHelper.floor((double)this.posZ))).getBlock()) != Blocks.AIR) {
            this.world.spawnParticle(EnumParticleTypes.BLOCK_CRACK, this.posX + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, this.getEntityBoundingBox().minY + 0.1, this.posZ + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, 4.0 * ((double)this.rand.nextFloat() - 0.5), 0.5, ((double)this.rand.nextFloat() - 0.5) * 4.0, new int[]{Block.REGISTRY.getIDForObject((Object)l)});
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        UUID ownerId = this.getOwnerId();
        if (ownerId != null) {
            par1NBTTagCompound.setUniqueId("Owner", ownerId);
        }
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasUniqueId("Owner")) {
            this.setOwnerId(par1NBTTagCompound.getUniqueId("Owner"));
        }
    }

    public UUID getOwnerId() {
        return (UUID)((Optional)this.dataManager.get(OWNER)).orNull();
    }

    public void setOwnerId(UUID owner) {
        this.enablePersistence();
        this.dataManager.set(OWNER, (Object)Optional.fromNullable((Object)owner));
    }

    public EntityPlayer getOwner() {
        if (this.owner == null) {
            this.owner = WitcheryUtils.getPlayer(this.world, this.getOwnerId());
        }
        return this.owner;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        this.world.setEntityState((Entity)this, (byte)4);
        boolean flag = super.attackEntityAsMob(par1Entity);
        if (flag) {
            par1Entity.motionY += (double)0.4f;
        }
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        } else {
            super.handleStatusUpdate(par1);
        }
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, par1DamageSource, par2)) {
            return super.attackEntityFrom(par1DamageSource, par2);
        }
        Entity entity = par1DamageSource.getTrueSource();
        par2 = Math.min(par2, 15.0f);
        if (entity instanceof EntityLivingBase && (par1DamageSource.damageType.equals("mob") || par1DamageSource.damageType.equals("player")) && !((EntityLivingBase)entity).getHeldItemMainhand().isEmpty() && ((EntityLivingBase)entity).getHeldItemMainhand().getItem() instanceof ItemAxe) {
            par2 *= 3.0f;
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness() {
        return 1.0f;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_ZOMBIE_HORSE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_ZOMBIE_HORSE_DEATH;
    }

    protected void playStepSound(BlockPos pos, Block block) {
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_STEP, 1.0f, 1.0f);
    }

    protected void dropFewItems(boolean par1, int par2) {
        WitcheryWoodType type;
        this.entityDropItem(new ItemStack(WitcheryIngredientItems.ENT_TWIG), 0.0f);
        switch (this.rand.nextInt(3)) {
            default: {
                type = WitcheryWoodTypes.ROWAN;
                break;
            }
            case 1: {
                type = WitcheryWoodTypes.ALDER;
                break;
            }
            case 2: {
                type = WitcheryWoodTypes.HAWTHORN;
            }
        }
        this.entityDropItem(new ItemStack((Block)type.getSapling()), 0.0f);
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
    }

    protected boolean canDespawn() {
        return true;
    }
}

