/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.util.EntityUtil;

public class EntityDroplet
extends Entity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.createKey(EntityDroplet.class, (DataSerializer)DataSerializers.VARINT);
    public int throwableShake;
    protected boolean inGround;
    private BlockPos pos = BlockPos.ORIGIN;
    private Block tile;
    private int ticksInGround;
    private int ticksInAir;
    private NBTTagCompound nbtBrew;

    public EntityDroplet(World world) {
        super(world);
    }

    public EntityDroplet(World world, double x, double y, double z, NBTTagCompound nbtBrew) {
        super(world);
        this.ticksInGround = 0;
        this.setPosition(x, y, z);
        this.nbtBrew = nbtBrew;
    }

    protected void entityInit() {
        this.dataManager.register(COLOR, (Object)0);
    }

    public int getColor() {
        return (Integer)this.dataManager.get(COLOR);
    }

    protected void setColor(int color2) {
        this.dataManager.set(COLOR, (Object)color2);
    }

    public NBTTagCompound getBrew() {
        return this.nbtBrew;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double distSq) {
        double d1 = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        return distSq < (d1 *= 64.0) * d1;
    }

    public void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        float n2;
        float n;
        float f2 = MathHelper.sqrt((double)(p_70186_1_ * p_70186_1_ + p_70186_3_ * p_70186_3_ + p_70186_5_ * p_70186_5_));
        p_70186_1_ /= (double)f2;
        p_70186_3_ /= (double)f2;
        p_70186_5_ /= (double)f2;
        p_70186_1_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        p_70186_3_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        p_70186_5_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        this.motionX = p_70186_1_ *= (double)p_70186_7_;
        this.motionY = p_70186_3_ *= (double)p_70186_7_;
        this.motionZ = p_70186_5_ *= (double)p_70186_7_;
        float f3 = MathHelper.sqrt((double)(p_70186_1_ * p_70186_1_ + p_70186_5_ * p_70186_5_));
        this.rotationYaw = n = (float)(Math.atan2(p_70186_1_, p_70186_5_) * 180.0 / Math.PI);
        this.prevRotationYaw = n;
        this.rotationPitch = n2 = (float)(Math.atan2(p_70186_3_, f3) * 180.0 / Math.PI);
        this.prevRotationPitch = n2;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double motionX, double motionY, double motionZ) {
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float n2;
            float n;
            float f = MathHelper.sqrt((double)(motionX * motionX + motionZ * motionZ));
            this.rotationYaw = n = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
            this.prevRotationYaw = n;
            this.rotationPitch = n2 = (float)(Math.atan2(motionY, f) * 180.0 / Math.PI);
            this.prevRotationPitch = n2;
        }
    }

    public void onUpdate() {
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        super.onUpdate();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            if (this.world.getBlockState(this.pos).getBlock() == this.tile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.setDead();
                }
                return;
            }
            this.inGround = false;
            this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vec3d vec3 = this.getPositionVector();
        Vec3d vec4 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        RayTraceResult movingobjectposition = this.world.rayTraceBlocks(vec3, vec4);
        vec3 = this.getPositionVector();
        vec4 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (movingobjectposition != null) {
            vec4 = new Vec3d(movingobjectposition.hitVec.x, movingobjectposition.hitVec.y, movingobjectposition.hitVec.z);
        }
        if (!this.world.isRemote) {
            Entity entity = null;
            List list2 = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.getEntityBoundingBox().expand(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (Entity entity2 : list2) {
                double d2;
                if (!entity2.canBeCollidedWith() || this.ticksInAir < 5) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity2.getEntityBoundingBox().expand((double)f, (double)f, (double)f);
                RayTraceResult movingobjectposition2 = axisalignedbb.calculateIntercept(vec3, vec4);
                if (movingobjectposition2 == null || !((d2 = vec3.distanceTo(movingobjectposition2.hitVec)) < d0) && d0 != 0.0) continue;
                entity = entity2;
                d0 = d2;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.typeOfHit == RayTraceResult.Type.BLOCK && this.world.getBlockState(new BlockPos(movingobjectposition.getBlockPos().getX(), movingobjectposition.getBlockPos().getY(), movingobjectposition.getBlockPos().getZ())).getBlock() == Blocks.PORTAL) {
                this.setPortal(this.getPosition());
            } else {
                this.onImpact(movingobjectposition);
            }
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f2 = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f2) * 180.0 / Math.PI);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f3 = 0.99f;
        float f4 = this.getGravityVelocity();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float f5 = 0.25f;
                this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * (double)f5, this.posY - this.motionY * (double)f5, this.posZ - this.motionZ * (double)f5, this.motionX, this.motionY, this.motionZ, new int[0]);
            }
            f3 = 0.8f;
        }
        this.motionX *= (double)f3;
        this.motionY *= (double)f3;
        this.motionZ *= (double)f3;
        this.motionY -= (double)f4;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected void onImpact(RayTraceResult mop) {
        if (!this.world.isRemote) {
            this.world.playEvent(1016, this.getPosition(), this.getColor());
            if (mop != null) {
                ModifiersEffect modifiers = new ModifiersEffect(1.0, 1.0, false, this.getPositionVector(), true, 1, EntityUtil.playerOrFake(this.world, null));
                switch (mop.typeOfHit) {
                    case BLOCK: {
                        WitcheryBrewEffects.applyToBlock(this.world, mop.getBlockPos(), mop.sideHit, 1, this.nbtBrew, modifiers);
                        break;
                    }
                    case ENTITY: {
                        if (!(mop.entityHit instanceof EntityLivingBase)) break;
                        WitcheryBrewEffects.applyToEntity(this.world, (EntityLivingBase)mop.entityHit, this.nbtBrew, modifiers);
                    }
                }
            }
        }
        this.setDead();
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.setInteger("xTile", this.pos.getX());
        nbtRoot.setInteger("yTile", this.pos.getY());
        nbtRoot.setInteger("zTile", this.pos.getZ());
        nbtRoot.setByte("inTile", (byte)Block.getIdFromBlock((Block)this.tile));
        nbtRoot.setByte("shake", (byte)this.throwableShake);
        nbtRoot.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        if (this.nbtBrew != null) {
            nbtRoot.setTag("Brew", (NBTBase)this.nbtBrew.copy());
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        this.pos = new BlockPos(nbtRoot.getInteger("xTile"), nbtRoot.getInteger("yTile"), nbtRoot.getInteger("zTile"));
        this.tile = Block.getBlockById((int)(nbtRoot.getByte("inTile") & 0xFF));
        this.throwableShake = nbtRoot.getByte("shake") & 0xFF;
        boolean bl = this.inGround = nbtRoot.getByte("inGround") == 1;
        if (nbtRoot.hasKey("Brew", 10)) {
            this.nbtBrew = nbtRoot.getCompoundTag("Brew").copy();
        }
        if (this.nbtBrew == null) {
            this.setDead();
        }
    }
}

