/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.ai.EntityAIAttackCloseTargetOnCollide;
import net.msrandom.witchery.entity.ai.EntityAIDemonicBarginPlayer;
import net.msrandom.witchery.entity.ai.EntityAILookAtDemonicBarginPlayer;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.SpiritWorldData;

public class EntityDemon
extends EntityGolem
implements IRangedAttackMob,
IMerchant,
IAnimals {
    private static final DataParameter<Integer> ATTACK_TIMER = EntityDataManager.createKey(EntityDemon.class, (DataSerializer)DataSerializers.VARINT);
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private int tryEscape = -1;

    public EntityDemon(World par1World) {
        super(par1World);
        this.isImmuneToFire = true;
        this.tasks.addTask(1, (EntityAIBase)new EntityAIAttackCloseTargetOnCollide((EntityCreature)this, 1.0, true, 3.0));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 20, 15.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIDemonicBarginPlayer(this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAILookAtDemonicBarginPlayer(this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, true, false, null));
        this.experienceValue = 10;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(ATTACK_TIMER, (Object)0);
    }

    public boolean processInteract(EntityPlayer par1EntityPlayer, EnumHand hand) {
        boolean flag;
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
            return super.processInteract(par1EntityPlayer, hand);
        }
        ItemStack itemstack = par1EntityPlayer.getHeldItem(hand);
        boolean bl = flag = !itemstack.isEmpty() && (itemstack.getItem() == Items.SPAWN_EGG || itemstack.getItem() == Items.NAME_TAG);
        if (!flag && this.isEntityAlive() && !this.isTrading() && !this.isChild()) {
            if (!this.world.isRemote) {
                this.setCustomer(par1EntityPlayer);
                par1EntityPlayer.displayVillagerTradeGui((IMerchant)this);
            }
            return true;
        }
        return super.processInteract(par1EntityPlayer, hand);
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, par1DamageSource, par2)) {
            return super.attackEntityFrom(par1DamageSource, par2);
        }
        return super.attackEntityFrom(par1DamageSource, Math.min(par2, 15.0f));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(100.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    public void onLivingUpdate() {
        int k;
        int j;
        int i;
        IBlockState state;
        Block l;
        int attackTimer;
        super.onLivingUpdate();
        if (this.world.getDifficulty() == EnumDifficulty.PEACEFUL) {
            this.setAttackTarget(null);
        }
        if ((attackTimer = this.getAttackTimer()) > 0) {
            this.setAttackTimer(attackTimer - 1);
        }
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this) && WitcheryUtils.getNightmareLevel(this.world) != SpiritWorldData.NightmareLevel.DEMONIC) {
            this.setDead();
        }
        if (this.tryEscape == 0) {
            this.tryEscape = -1;
            this.world.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 3.0f, true);
        } else if (this.tryEscape > 0) {
            --this.tryEscape;
        }
        if (this.motionX * this.motionX + this.motionZ * this.motionZ > 2.500000277905201E-7 && this.rand.nextInt(5) == 0 && (l = (state = this.world.getBlockState(new BlockPos(i = MathHelper.floor((double)this.posX), j = MathHelper.floor((double)(this.posY - (double)0.2f)), k = MathHelper.floor((double)this.posZ)))).getBlock()) != Blocks.AIR) {
            this.world.spawnParticle(EnumParticleTypes.BLOCK_CRACK, this.posX + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, this.getEntityBoundingBox().minY + 0.1, this.posZ + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, 4.0 * ((double)this.rand.nextFloat() - 0.5), 0.5, ((double)this.rand.nextFloat() - 0.5) * 4.0, new int[]{Block.getStateId((IBlockState)state)});
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        if (this.buyingList != null) {
            par1NBTTagCompound.setTag("Bargains", (NBTBase)this.buyingList.getRecipiesAsTags());
        }
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasKey("Bargains")) {
            NBTTagCompound nbttagcompound1 = par1NBTTagCompound.getCompoundTag("Bargains");
            this.buyingList = new MerchantRecipeList(nbttagcompound1);
        }
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        boolean flag = par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)(7 + this.rand.nextInt(15)));
        if (flag) {
            par1Entity.motionY += (double)0.4f;
        }
        this.setAttackTimer(10);
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        return flag;
    }

    public int getAttackTimer() {
        return (Integer)this.dataManager.get(ATTACK_TIMER);
    }

    public void setAttackTimer(int timer) {
        this.dataManager.set(ATTACK_TIMER, (Object)timer);
    }

    public float getBrightness() {
        return 1.0f;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_BLAZE_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_WITHER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_WITHER_DEATH;
    }

    protected void playStepSound(BlockPos pos, Block block) {
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_STEP, 1.0f, 1.0f);
    }

    public void fall(float distance, float damageMultiplier) {
    }

    public int getTalkInterval() {
        return 120;
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (par1) {
            int j = this.rand.nextInt(2 + par2);
            for (int k = 0; k < j; ++k) {
                this.dropItem(Items.MAGMA_CREAM, 1);
            }
        }
    }

    protected Item getDropItem() {
        return Items.MAGMA_CREAM;
    }

    protected boolean canDespawn() {
        return true;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase targetEntity, float par2) {
        if (!targetEntity.isHandActive() || targetEntity.getHeldItem(targetEntity.getActiveHand()).getItem() != WitcheryGeneralItems.DEVILS_TONGUE_CHARM || this.world.rand.nextDouble() < 0.05) {
            double d0 = targetEntity.posX - this.posX;
            double d2 = targetEntity.getEntityBoundingBox().minY + (double)(targetEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
            double d3 = targetEntity.posZ - this.posZ;
            float f1 = MathHelper.sqrt((float)par2) * 0.5f;
            EntityLargeFireball fireballEntity = new EntityLargeFireball(this.world, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d2, d3 + this.rand.nextGaussian() * (double)f1);
            double d4 = 1.0;
            Vec3d vec3 = this.getLook(1.0f);
            fireballEntity.posX = this.posX + vec3.x * d4;
            fireballEntity.posY = this.posY + (double)(this.height / 2.0f) + 0.5;
            fireballEntity.posZ = this.posZ + vec3.z * d4;
            if (!this.world.isRemote) {
                this.world.playEvent(1009, this.getPos(), 0);
                this.world.spawnEntity((Entity)fireballEntity);
            }
        }
    }

    public void setSwingingArms(boolean b) {
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        this.addPotionEffect(new PotionEffect(MobEffects.JUMP_BOOST, Integer.MAX_VALUE, 4));
        return super.onInitialSpawn(difficulty, par1EntityLivingData);
    }

    public EntityPlayer getCustomer() {
        return this.buyingPlayer;
    }

    public void setCustomer(EntityPlayer par1EntityPlayer) {
        this.buyingPlayer = par1EntityPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void useRecipe(MerchantRecipe par1MerchantRecipe) {
        par1MerchantRecipe.incrementToolUses();
        Item itemToBuy = par1MerchantRecipe.getItemToBuy().getItem();
        if (!(this.world.isRemote || itemToBuy != Items.MAGMA_CREAM && itemToBuy != Items.BLAZE_ROD)) {
            this.playSound(SoundEvents.ENTITY_WITHER_SHOOT, this.getSoundVolume(), this.getSoundPitch());
            this.tryEscape = 50;
        } else {
            this.playSound(SoundEvents.ENTITY_PLAYER_BREATH, this.getSoundVolume(), this.getSoundPitch());
        }
        if (this.getCustomer() != null && (this.getCustomer().getHeldItemMainhand().getItem() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM || this.getCustomer().getHeldItemOffhand().getItem() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM)) {
            (this.getCustomer().getHeldItemMainhand().getItem() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM ? this.getCustomer().getHeldItemMainhand() : this.getCustomer().getHeldItemOffhand()).damageItem(5, (EntityLivingBase)this.getCustomer());
        }
    }

    public void verifySellingItem(ItemStack par1ItemStack) {
        if (!this.world.isRemote && this.livingSoundTime > -this.getTalkInterval() + 20) {
            this.livingSoundTime = -this.getTalkInterval();
            if (par1ItemStack.isEmpty()) {
                this.playSound(SoundEvents.ENTITY_WITHER_AMBIENT, this.getSoundVolume(), this.getSoundPitch());
            }
        }
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.getPosition();
    }

    public MerchantRecipeList getRecipes(EntityPlayer par1EntityPlayer) {
        if (this.buyingList == null) {
            this.addDefaultEquipmentAndRecipies(this.rand.nextInt(4) + 6);
        }
        if (this.getCustomer() != null && (this.getCustomer().getHeldItemMainhand().getItem() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM || this.getCustomer().getHeldItemOffhand().getItem() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM)) {
            MerchantRecipeList list2 = new MerchantRecipeList();
            for (MerchantRecipe recipe : this.buyingList) {
                NBTTagCompound nbtTag = recipe.writeToTags();
                MerchantRecipe recipe2 = new MerchantRecipe(nbtTag);
                ItemStack cost = recipe2.getItemToBuy();
                cost.setCount(Math.max(cost.getCount() - (cost.getItem() == Items.GOLD_INGOT ? 5 : (cost.getItem() == Items.EMERALD ? 2 : (cost.getItem() == Items.DIAMOND ? 0 : 1))), 1));
                list2.add((Object)recipe2);
            }
            return list2;
        }
        return this.buyingList;
    }

    private Item getCurrency() {
        double chance = this.rand.nextDouble();
        if (chance < 0.2) {
            return Items.BLAZE_ROD;
        }
        if (chance < 0.4) {
            return Items.MAGMA_CREAM;
        }
        if (chance < 0.5) {
            return Items.DIAMOND;
        }
        if (chance < 0.75) {
            return Items.EMERALD;
        }
        return Items.GOLD_INGOT;
    }

    private ItemStack getPrice(int basePriceInEmeralds) {
        Item currency = this.getCurrency();
        int multiplier = currency == Items.GOLD_INGOT ? 1 : (currency == Items.EMERALD ? 3 : (currency == Items.DIAMOND ? 5 : 4));
        int quantity = Math.max(1, basePriceInEmeralds / multiplier);
        return new ItemStack(currency, quantity);
    }

    private void addDefaultEquipmentAndRecipies(int par1) {
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        int STOCK_REDUCTION = -5;
        for (int i = 0; i < par1; ++i) {
            Enchantment enchantment = (Enchantment)Enchantment.REGISTRY.getRandomObject(this.rand);
            int k = MathHelper.getInt((Random)this.rand, (int)enchantment.getMinLevel(), (int)enchantment.getMaxLevel());
            ItemStack itemstack = ItemEnchantedBook.getEnchantedItemStack((EnchantmentData)new EnchantmentData(enchantment, k));
            int j = 2 + this.rand.nextInt(5 + k * 10) + 3 * k;
            MerchantRecipe recipe = new MerchantRecipe(this.getPrice(j), itemstack);
            recipe.increaseMaxTradeUses(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe);
        }
        if (this.rand.nextDouble() < 0.25) {
            MerchantRecipe recipe2 = new MerchantRecipe(this.getPrice(this.rand.nextInt(3) + 8), new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST, this.rand.nextInt(4) + 3));
            recipe2.increaseMaxTradeUses(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe2);
        }
        if (this.rand.nextDouble() < 0.25) {
            MerchantRecipe recipe2 = new MerchantRecipe(this.getPrice(this.rand.nextInt(3) + 8), new ItemStack(WitcheryIngredientItems.DOG_TONGUE, this.rand.nextInt(4) + 4));
            recipe2.increaseMaxTradeUses(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe2);
        }
        if (this.rand.nextDouble() < 0.15) {
            MerchantRecipe recipe2 = new MerchantRecipe(this.getPrice(this.rand.nextInt(10) + 20), new ItemStack((Item)WitcheryBrewItems.REDSTONE_SOUP, 1));
            recipe2.increaseMaxTradeUses(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe2);
        }
        if (this.rand.nextDouble() < 0.15) {
            MerchantRecipe recipe2 = new MerchantRecipe(new ItemStack(Items.DIAMOND), new ItemStack(Items.GHAST_TEAR, 2));
            recipe2.increaseMaxTradeUses(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe2);
        }
        if (this.rand.nextDouble() < 0.15) {
            MerchantRecipe recipe2 = new MerchantRecipe(new ItemStack(Items.DIAMOND), new ItemStack(Items.ENDER_PEARL, 2));
            recipe2.increaseMaxTradeUses(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe2);
        }
        Collections.shuffle(merchantrecipelist);
        Item currencyForHeart = this.getCurrency();
        MerchantRecipe heartRecipe = new MerchantRecipe(new ItemStack(currencyForHeart, currencyForHeart == Items.GOLD_INGOT ? 30 : 3), new ItemStack((Block)WitcheryBlocks.DEMON_HEART, 1));
        heartRecipe.increaseMaxTradeUses(STOCK_REDUCTION);
        merchantrecipelist.add(this.rand.nextInt(3), (Object)heartRecipe);
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (int j2 = 0; j2 < par1 && j2 < merchantrecipelist.size(); ++j2) {
            this.buyingList.add(merchantrecipelist.get(j2));
        }
    }

    public void setRecipes(MerchantRecipeList par1MerchantRecipeList) {
    }
}

