/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityDeath
extends EntityMob
implements IHandleDeathTouch {
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(UUID.fromString("e942c510-c256-11e3-8a33-0800200c9a66"), "Attacking speed boost", (double)0.15f, 0).setSaved(false);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.createKey(EntityDeath.class, (DataSerializer)DataSerializers.BOOLEAN);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.getDisplayName(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_20).setDarkenSky(true);
    private int lastScream;

    public EntityDeath(World par1World) {
        super(par1World);
        this.stepHeight = 1.0f;
        this.isImmuneToFire = true;
        this.experienceValue = 80;
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new FindPlayerGoal(this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected boolean canDespawn() {
        return false;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(1000.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue((double)0.3f);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(7.0);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(64.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(SCREAMING, (Object)false);
    }

    protected void updateAITasks() {
        super.updateAITasks();
        this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
    }

    public void addTrackingPlayer(EntityPlayerMP player) {
        super.addTrackingPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void removeTrackingPlayer(EntityPlayerMP player) {
        super.removeTrackingPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean isNonBoss() {
        return false;
    }

    public void setAttackTarget(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.setAttackTarget(entitylivingbaseIn);
        IAttributeInstance instance = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        if (entitylivingbaseIn == null) {
            this.setScreaming(false);
            instance.removeModifier(ATTACKING_SPEED_BOOST);
        } else {
            this.setScreaming(true);
            if (!instance.hasModifier(ATTACKING_SPEED_BOOST)) {
                instance.applyModifier(ATTACKING_SPEED_BOOST);
            }
        }
    }

    public void notifyDataManagerChange(DataParameter<?> key) {
        if (key.equals(SCREAMING) && this.isScreaming() && this.world.isRemote && this.ticksExisted >= this.lastScream + 400) {
            this.lastScream = this.ticksExisted;
            if (!this.isSilent()) {
                this.world.playSound(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ, SoundEvents.ENTITY_WITHER_SPAWN, this.getSoundCategory(), 2.5f, 1.0f, false);
            }
        }
        super.notifyDataManagerChange(key);
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        Vec3d vec3d = player.getLook(1.0f).normalize();
        Vec3d vec3d1 = new Vec3d(this.posX - player.posX, this.getEntityBoundingBox().minY + (double)this.getEyeHeight() - (player.posY + (double)player.getEyeHeight()), this.posZ - player.posZ);
        double d0 = vec3d1.length();
        double d1 = vec3d.dotProduct(vec3d1 = vec3d1.normalize());
        return d1 > 1.0 - 0.025 / d0 && player.canEntityBeSeen((Entity)this);
    }

    public void onLivingUpdate() {
        if (this.ticksExisted % 20 == 0) {
            this.heal(1.0f);
        }
        if (this.world.isRemote) {
            for (int i = 0; i < 2; ++i) {
                this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height - 0.25, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        this.isJumping = false;
        if (this.world.rand.nextDouble() < 0.05 && this.getAttackTarget() != null && (this.getAttackTarget().isAirBorne || this.getAttackTarget() instanceof EntityPlayer && ((EntityPlayer)this.getAttackTarget()).capabilities.isFlying) && !this.getAttackTarget().isPotionActive(MobEffects.SLOWNESS)) {
            this.getAttackTarget().addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 200, 5));
        }
        super.onLivingUpdate();
    }

    protected boolean teleportRandomly() {
        double d0 = this.posX + (this.rand.nextDouble() - 0.5) * 64.0;
        double d1 = this.posY + (double)(this.rand.nextInt(64) - 32);
        double d2 = this.posZ + (this.rand.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.posX - p_70816_1_.posX, this.getEntityBoundingBox().minY + (double)(this.height / 2.0f) - p_70816_1_.posY + (double)p_70816_1_.getEyeHeight(), this.posZ - p_70816_1_.posZ);
        vec3d = vec3d.normalize();
        double d0 = 16.0;
        double d1 = this.posX + (this.rand.nextDouble() - 0.5) * 8.0 - vec3d.x * d0;
        double d2 = this.posY + (double)(this.rand.nextInt(16) - 8) - vec3d.y * d0;
        double d3 = this.posZ + (this.rand.nextDouble() - 0.5) * 8.0 - vec3d.z * d0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        boolean flag = this.attemptTeleport(x, y, z);
        if (flag) {
            this.world.playSound(null, this.prevPosX, this.prevPosY, this.prevPosZ, SoundEvents.ENTITY_ENDERMEN_TELEPORT, this.getSoundCategory(), 1.0f, 1.0f);
            this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 1.0f, 1.0f);
        }
        return flag;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_SKELETON_DEATH;
    }

    protected Item getDropItem() {
        return Items.BONE;
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.entityDropItem(new ItemStack(Items.SKULL, 1, 0), 0.0f);
        this.entityDropItem(new ItemStack(Items.BONE, 5, 0), 0.0f);
        Enchantment enchantment = (Enchantment)Enchantment.REGISTRY.getRandomObject(this.rand);
        int k = MathHelper.getInt((Random)this.rand, (int)Math.min(enchantment.getMinLevel() + 2, enchantment.getMaxLevel()), (int)enchantment.getMaxLevel());
        ItemStack itemstack = ItemEnchantedBook.getEnchantedItemStack((EnchantmentData)new EnchantmentData(enchantment, k));
        this.entityDropItem(itemstack, 0.0f);
        if (this.world.rand.nextInt(4) == 0) {
            ItemStack sword = new ItemStack(Items.DIAMOND_SWORD);
            EnchantmentHelper.addRandomEnchantment((Random)this.world.rand, (ItemStack)sword, (int)40, (boolean)false);
            sword.setStackDisplayName(WitcheryResurrected.translate("item.witchery.deaths_sword", new Object[0]));
            this.entityDropItem(sword, 0.0f);
        }
        switch (this.world.rand.nextInt(5)) {
            case 0: {
                this.entityDropItem(new ItemStack(Items.SADDLE), 0.0f);
                this.entityDropItem(new ItemStack(WitcheryIngredientItems.BINKY_HEAD), 0.0f);
                break;
            }
            case 1: {
                this.entityDropItem(new ItemStack((Item)WitcheryEquipmentItems.DEATH_HOOD), 0.0f);
                break;
            }
            case 2: {
                this.entityDropItem(new ItemStack((Item)WitcheryEquipmentItems.DEATH_ROBE), 0.0f);
                break;
            }
            case 3: {
                this.entityDropItem(new ItemStack((Item)WitcheryEquipmentItems.DEATH_FEET), 0.0f);
                break;
            }
            case 4: {
                this.entityDropItem(new ItemStack((Item)WitcheryGeneralItems.DEATH_HAND), 0.0f);
            }
        }
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, source, amount)) {
            return super.attackEntityFrom(source, amount);
        }
        if (this.isEntityInvulnerable(source)) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.attackEntityFrom(source, Math.min(amount, 15.0f));
        if (source.isUnblockable() && this.rand.nextInt(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue();
        int i = 0;
        if (par1Entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)par1Entity;
            float maxHealth = living.getMaxHealth();
            f = Math.max(maxHealth * 0.15f, 1.0f);
        }
        if (par1Entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getModifierForCreature((ItemStack)this.getHeldItemMainhand(), (EnumCreatureAttribute)((EntityLivingBase)par1Entity).getCreatureAttribute());
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this);
        }
        if (flag = EntityUtil.touchOfDeath(par1Entity, (EntityLivingBase)this, f)) {
            int j;
            if (i > 0) {
                par1Entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                par1Entity.setFire(j * 4);
            }
        }
        return flag;
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (!this.world.isRemote) {
            this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
        }
        for (int i = 0; i < 20; ++i) {
            this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
        }
        this.setDead();
    }

    public boolean isScreaming() {
        return (Boolean)this.dataManager.get(SCREAMING);
    }

    public void setScreaming(boolean par1) {
        this.dataManager.set(SCREAMING, (Object)par1);
    }

    static class FindPlayerGoal
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private final EntityDeath death;
        private EntityPlayer player;
        private int aggroTime;
        private int teleportTime;

        public FindPlayerGoal(EntityDeath death) {
            super((EntityCreature)death, EntityPlayer.class, false);
            this.death = death;
        }

        public boolean shouldExecute() {
            double d0 = this.getTargetDistance();
            this.player = this.death.world.getNearestAttackablePlayer(this.death.posX, this.death.posY, this.death.posZ, d0, d0, null, x$0 -> this.death.shouldAttackPlayer(x$0));
            return this.player != null;
        }

        public void startExecuting() {
            this.aggroTime = 5;
            this.teleportTime = 0;
        }

        public void resetTask() {
            this.player = null;
            super.resetTask();
        }

        public boolean shouldContinueExecuting() {
            if (this.player != null) {
                if (!this.death.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.death.faceEntity((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.targetEntity != null && ((EntityPlayer)this.targetEntity).isEntityAlive() || super.shouldContinueExecuting();
        }

        public void updateTask() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.targetEntity = this.player;
                    this.player = null;
                    super.startExecuting();
                }
            } else {
                if (this.targetEntity != null) {
                    if (this.death.shouldAttackPlayer((EntityPlayer)this.targetEntity)) {
                        if (((EntityPlayer)this.targetEntity).getDistanceSq((Entity)this.death) < 16.0) {
                            this.death.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (((EntityPlayer)this.targetEntity).getDistanceSq((Entity)this.death) > 256.0 && this.teleportTime++ >= 30 && this.death.teleportToEntity((Entity)this.targetEntity)) {
                        this.teleportTime = 0;
                    }
                }
                super.updateTask();
            }
        }
    }
}

