/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.infusions.WitcheryInfusedBrews;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityBroom
extends Entity {
    private static final DataParameter<Integer> BRUSH_COLOR = EntityDataManager.createKey(EntityBroom.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Integer> HIT = EntityDataManager.createKey(EntityBroom.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Integer> DIRECTION = EntityDataManager.createKey(EntityBroom.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Float> DAMAGE = EntityDataManager.createKey(EntityBroom.class, (DataSerializer)DataSerializers.FLOAT);
    private int broomPosRotationIncrements;
    private double broomX;
    private double broomY;
    private double broomZ;
    private double broomYaw;
    private double broomPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    boolean riderHasOwlFamiliar = false;
    boolean riderHasSoaringBrew = false;
    private double speedMultiplier = 0.07;

    public EntityBroom(World world) {
        super(world);
        this.preventEntitySpawning = true;
    }

    public EntityBroom(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y, z);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void entityInit() {
        this.dataManager.register(BRUSH_COLOR, (Object)-1);
        this.dataManager.register(HIT, (Object)0);
        this.dataManager.register(DIRECTION, (Object)1);
        this.dataManager.register(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void dealFireDamage(int par1) {
    }

    public EnumDyeColor getBrushColor() {
        return EnumDyeColor.byMetadata((int)((Integer)this.dataManager.get(BRUSH_COLOR)));
    }

    public void setBrushColor(EnumDyeColor color2) {
        this.dataManager.set(BRUSH_COLOR, (Object)color2.getMetadata());
    }

    public AxisAlignedBB getCollisionBox(Entity par1Entity) {
        return par1Entity.getEntityBoundingBox();
    }

    public AxisAlignedBB getCollisionBoundingBox() {
        return this.getEntityBoundingBox();
    }

    public boolean canBePushed() {
        return true;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.4;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.isEntityInvulnerable(par1DamageSource)) {
            return false;
        }
        if (!this.world.isRemote && !this.isDead) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + par2 * 10.0f);
            this.markVelocityChanged();
            boolean bl = flag = par1DamageSource.getTrueSource() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.getTrueSource()).capabilities.isCreativeMode;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!this.getPassengers().isEmpty()) {
                    this.startRiding(this);
                }
                if (!flag) {
                    ItemStack broomStack = new ItemStack((Item)WitcheryIngredientItems.ENCHANTED_BROOM);
                    if (this.hasCustomName()) {
                        broomStack.setStackDisplayName(this.getCustomNameTag());
                    }
                    WitcheryIngredientItems.ENCHANTED_BROOM.setColor(broomStack, this.getBrushColor());
                    this.entityDropItem(broomStack, 0.0f);
                }
                this.setDead();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void performHurtAnimation() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean canBeCollidedWith() {
        return !this.isDead && this.getPassengers().isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotationDirect(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.broomPosRotationIncrements = posRotationIncrements + 5;
        this.broomX = x;
        this.broomY = y;
        this.broomZ = z;
        this.broomYaw = yaw;
        this.broomPitch = pitch;
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double x, double y, double z) {
        this.motionX = x;
        this.velocityX = x;
        this.motionY = y;
        this.velocityY = y;
        this.motionZ = z;
        this.velocityZ = z;
    }

    public void onUpdate() {
        EntityPlayer rider;
        EntityPlayer entityPlayer = rider = !this.getPassengers().isEmpty() && this.getPassengers().get(0) instanceof EntityPlayer ? (EntityPlayer)this.getPassengers().get(0) : null;
        if (this.ticksExisted % 100 == 0 && rider != null) {
            this.riderHasSoaringBrew = WitcheryInfusedBrews.SOARING.isActive((EntityPlayer)this.getPassengers().get(0));
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        double initialHorzVelocity = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        if (this.world.isRemote) {
            if (this.broomPosRotationIncrements > 0) {
                double x = this.posX + (this.broomX - this.posX) / (double)this.broomPosRotationIncrements;
                double y = this.posY + (this.broomY - this.posY) / (double)this.broomPosRotationIncrements;
                double z = this.posZ + (this.broomZ - this.posZ) / (double)this.broomPosRotationIncrements;
                double yaw = MathHelper.wrapDegrees((double)(this.broomYaw - (double)this.rotationYaw));
                this.rotationYaw += (float)(yaw / (double)this.broomPosRotationIncrements);
                this.rotationPitch += (float)((this.broomPitch - (double)this.rotationPitch) / (double)this.broomPosRotationIncrements);
                --this.broomPosRotationIncrements;
                this.setPosition(x, y, z);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                this.setRotation((float)((double)this.rotationYaw + (this.broomYaw - (double)this.rotationYaw)), (float)((double)this.rotationPitch + (this.broomPitch - (double)this.rotationPitch)));
                this.setPosition(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
                this.motionX *= (double)0.99f;
                this.motionZ *= (double)0.99f;
            }
        } else {
            double newHorzVelocity;
            if (rider != null) {
                newHorzVelocity = rider.moveForward;
                if (newHorzVelocity > 0.0) {
                    double d2 = -Math.sin(rider.rotationYaw * (float)Math.PI / 180.0f);
                    double d3 = Math.cos(rider.rotationYaw * (float)Math.PI / 180.0f);
                    this.motionX += d2 * this.speedMultiplier * (0.1 + (this.riderHasSoaringBrew ? 0.1 : 0.0) + (this.riderHasOwlFamiliar ? 0.2 : 0.0));
                    this.motionZ += d3 * this.speedMultiplier * (0.1 + (this.riderHasSoaringBrew ? 0.1 : 0.0) + (this.riderHasOwlFamiliar ? 0.2 : 0.0));
                    double pitch = -Math.sin(rider.rotationPitch * (float)Math.PI / 180.0f);
                    if (pitch > -0.5 && pitch < 0.2) {
                        pitch = 0.0;
                    } else if (pitch < 0.0) {
                        pitch *= 0.5;
                    }
                    this.motionY = pitch * this.speedMultiplier * 2.0;
                } else if (newHorzVelocity == 0.0 && (this.riderHasOwlFamiliar || this.riderHasSoaringBrew)) {
                    this.motionX *= 0.9;
                    this.motionZ *= 0.9;
                }
            } else {
                this.riderHasOwlFamiliar = false;
                double moX = this.motionX * 0.9;
                double moZ = this.motionZ * 0.9;
                this.motionX = Math.abs(moX) < 0.01 ? 0.0 : moX;
                double d = this.motionZ = Math.abs(moZ) < 0.01 ? 0.0 : moZ;
                if (!this.onGround) {
                    this.motionY = -0.2;
                }
            }
            newHorzVelocity = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            double speedLimit = 0.9 + (this.riderHasOwlFamiliar ? 0.3 : 0.0) + (this.riderHasSoaringBrew ? 0.3 : 0.0);
            if (newHorzVelocity > speedLimit) {
                double d2 = speedLimit / newHorzVelocity;
                this.motionX *= d2;
                this.motionZ *= d2;
                this.motionY *= d2;
                newHorzVelocity = speedLimit;
            }
            double accelerationLimit = this.riderHasSoaringBrew || this.riderHasOwlFamiliar ? 0.35 : 0.35;
            double accelerationFactor = accelerationLimit * 100.0;
            if (newHorzVelocity > initialHorzVelocity && this.speedMultiplier < accelerationLimit) {
                this.speedMultiplier += (accelerationLimit - this.speedMultiplier) / accelerationFactor;
                if (this.speedMultiplier > accelerationLimit) {
                    this.speedMultiplier = accelerationLimit;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.07) / accelerationFactor;
                if (this.speedMultiplier < 0.07) {
                    this.speedMultiplier = 0.07;
                }
            }
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.99f;
            this.motionY *= (double)0.99f;
            this.motionZ *= (double)0.99f;
            this.rotationPitch = 0.0f;
            double d2 = this.rotationYaw;
            double d3 = this.prevPosX - this.posX;
            double d4 = this.prevPosZ - this.posZ;
            if (d3 * d3 + d4 * d4 > 0.001) {
                d2 = (float)(Math.atan2(d4, d3) * 180.0 / Math.PI);
            }
            double d5 = MathHelper.wrapDegrees((double)(d2 - (double)this.rotationYaw));
            this.setRotation(this.rotationYaw += (float)d5, this.rotationPitch);
            for (Entity entity : this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.getEntityBoundingBox().expand(0.2, 0.0, 0.2))) {
                if (entity == rider || !entity.canBePushed() || !(entity instanceof EntityBroom)) continue;
                entity.applyEntityCollision((Entity)this);
            }
            if (rider != null && rider.isDead) {
                rider.dismountEntity((Entity)this);
            }
        }
    }

    protected void writeEntityToNBT(NBTTagCompound tag) {
        tag.setByte("BrushColor", (byte)this.getBrushColor().getMetadata());
    }

    protected void readEntityFromNBT(NBTTagCompound tag) {
        if (tag.hasKey("BrushColor")) {
            this.dataManager.set(BRUSH_COLOR, (Object)tag.getByte("BrushColor"));
        }
    }

    public boolean processInitialInteract(EntityPlayer player, EnumHand hand) {
        EnumDyeColor color2;
        if (!this.getPassengers().isEmpty() && this.getPassengers().get(0) instanceof EntityPlayer && this.getPassengers().get(0) != player) {
            return true;
        }
        ItemStack itemstack = player.getHeldItem(hand);
        if (!this.world.isRemote && (color2 = WitcheryUtils.getDyeColor(itemstack)) != null) {
            this.setBrushColor(color2);
            if (!player.capabilities.isCreativeMode) {
                itemstack.shrink(1);
            }
            return true;
        }
        if (!this.world.isRemote) {
            this.riderHasOwlFamiliar = Familiars.hasFamiliarPower(player, WitcheryFamiliars.BROOM_MASTERY);
            this.riderHasSoaringBrew = WitcheryInfusedBrews.SOARING.isActive(player);
            player.startRiding((Entity)this);
        }
        return true;
    }

    public float getDamageTaken() {
        return ((Float)this.dataManager.get(DAMAGE)).floatValue();
    }

    public void setDamageTaken(float par1) {
        this.dataManager.set(DAMAGE, (Object)Float.valueOf(par1));
    }

    public int getTimeSinceHit() {
        return (Integer)this.dataManager.get(HIT);
    }

    public void setTimeSinceHit(int par1) {
        this.dataManager.set(HIT, (Object)par1);
    }

    public int getForwardDirection() {
        return (Integer)this.dataManager.get(DIRECTION);
    }

    public void setForwardDirection(int par1) {
        this.dataManager.set(DIRECTION, (Object)par1);
    }
}

